<?
$page = str_replace('/', '', $_SERVER['REQUEST_URI']);
$tipoVeiculo = get_tipo_veiculo();
if ($tipoVeiculo === 'altimuscarro') {
    $argFiltro['title'] = 'Encontre seu Novo Carro!';
}
if ($tipoVeiculo === 'altimusmoto') {
    $argFiltro['title'] = 'Encontre sua Nova Moto!';
}
if ($tipoVeiculo === 'altimuscaminhao') {
    $argFiltro['title'] = 'Encontre seu Novo Caminhão!';
}
if ($tipoVeiculo === 'altimusbarco') {
    $argFiltro['title'] = 'Encontre seu Novo Barco!';
}
if ($tipoVeiculo === 'altimusaviao') {
    $argFiltro['title'] = 'Encontre seu Novo Avião!';
}
if ($tipoVeiculo === 'altimusatrator') {
    $argFiltro['title'] = 'Encontre seu Novo Trator!';
}

if ($page == 'estoque') {
    $title = 'Filtrar veículos';
} else {
    $title = $argFiltro['title'];
}

?>
<section id="filter_form" class="bg-gray-50 border-b-2 border-gray-200 pb-8">
    <form name="formulario_busca" id="form_busca" action="<?= alt_get_url_estoque() ?>" method="get">
        <div class="w-full grid justify-items-center py-8">
            <div class="text-[#1e1b1d] text-center text-3xl font-bold">
                <?= $title ?>
            </div>
            <div class="w-full tablet:w-1/2">
                <input type="text" name="veiculo" id="veiculo" class="px-4 py-2 m-2" placeholder="busque seu veículo...">
            </div>
        </div>
        <div class="w-full flex justify-center">
            <div class="filter-max flex justify-center cursor-pointer">
                <img class="w-6 h-6" src="<?= get_template_directory_uri() . '/assets/images/icon_mais_filter.png'; ?>" alt="banner do site">
                <p class="ml-4 text-lg">Mais filtros</p>
            </div>
            <div class="filter-min flex justify-center cursor-pointer" style="display: none;">
                <img class="w-6  h-6" src="<?= get_template_directory_uri() . '/assets/images/icon_menos_filter.png'; ?>" alt="banner do site">
                <p class="ml-4 text-lg">Menos filtros</p>
            </div>

        </div>
        <div class="group-filter-max flex justify-center w-full p-6 gap-4" style="display: none;">
            <div class="select">
                <select name="marca" id="form_marca" class="form-item-select">
                    <option value selected>Marca</option>
                    <?php foreach ($arrMarcas as $marca): ?>
                        <option value="<?= $marca['slug']; ?>"><?= $marca['name']; ?></option>
                    <?php endforeach; ?>
                </select>
            </div>
            <div class="select">
                <select name="modelo" id="form_modelo" class="form-item-select">
                    <option value="" selected>Modelo</option>
                    <?php foreach ($arrModelos as $modelo): ?>
                        <option value="<?= $modelo['slug']; ?>"><?= $modelo['name']; ?></option>
                    <?php endforeach; ?>
                </select>
            </div>
            <div class="select">
                <select name="ano" id="form_ano" class="form-item-select">
                    <option value="" selected>Ano</option>
                    <?php foreach ($arrAnoModelo as $ano): ?>
                        <option value="<?= $ano ?>">
                            <?= $ano ?>
                        </option>
                    <?php endforeach; ?>
                </select>
            </div>
            <?php if ($sn_cambio): ?>
                <div class="select">
                    <select name="cambio" id="form_ano" class="bg-white border border-gray-900 text-gray-900 text-sm rounded-lg focus:ring-blue-500 focus:border-blue-500 block w-full p-2.5 mx-2">
                        <option value="" selected>Tipo de câmbio</option>
                        <?php foreach ($arrCambios as $cambio): ?>
                            <option value="<?= $cambio ?>">
                                <?= $cambio ?>
                            </option>
                        <?php endforeach; ?>
                    </select>
                </div>
            <?php endif; ?>
        </div>

        <div class="group-filter-max flex w-full m-4 p-6 items-center justify-center" style="display: none;">
            <div class="w-full relative mb-6 mr-6">
                <label for="small-range" class="block mb-2 text-sm font-medium text-gray-900 dark:text-gray-800">Preço(R$)</label>
                <input id="labels-range-input" type="range" step="1" value="<?= $arrPrecos['maximo']; ?>" min="<?= $arrPrecos['minimo']; ?>" max="<?= $arrPrecos['maximo']; ?>" class="w-full h-2 accent-[--primary_color] rounded-lg  cursor-pointer">
                <div class="w-full grid grid-cols-2 gap-4">
                    <div>
                        <span class="text-base font-semibold text-gray-800 dark:text-gray-800">R$<?= number_format($field_min_price, '0', ',', '.'); ?></span>
                    </div>
                    <div class="flex justify-end">
                        <span id="text-max" class="text-base font-semibold text-gray-800 dark:text-gray-800">R$<?= number_format($field_max_price, '0', ',', '.'); ?></span>
                    </div>
                </div>

                <input id="form_min_price" type="hidden" name="min_price" value="<?= $field_min_price; ?>" class="j-min" />
                <input id="form_max_price" type="hidden" name="max_price" value="<?= $field_max_price; ?>" class="j-max" />
            </div>
            <div class="w-2/5 flex justify-center">
                <button type="submit" class="bg-[--primary_color] w-full m-2 hover:opacity-90 text-white font-bold py-2 px-4 rounded shadow-slate-300 shadow-lg">
                    Buscar
                </button>
            </div>
        </div>
    </form>
</section>