<?php
    $lista_imagens = alt_get_imagens_veiculo($post->ID);
    $imagem_thumbnail = alt_get_imagem_destaque($post->ID, $lista_imagens);
    $total_imagens = count($lista_imagens) ?? 0;
    $elemento_id = $post->ID . "" . $total_imagens;
    $youtube = alt_get_video($post->ID);
    if (!empty($youtube)):?>
        <div class="caixa-youtube hidden">
            <?php echo $youtube; ?>
        </div>
<?php endif; ?>
<div class="vehicle-details">
    <div class="group-img <?=$total_imagens == 0 ? 'justify-center' : ''?>">
        <?if (alt_count_image($post->ID) > 0 || $imagem_thumbnail) : ?>
            <div class="content-img">
                <div class="alt-tags">
                    <? foreach (alt_get_tag_all($post->ID) as $tag) : ?>
                        <div class="item-tag">
                            <span><?= $tag ?></span>
                        </div>
                    <? endforeach ?>
                </div>
                <div class="img-destaque aspect-container" id="img-destaque">
                <?php
                
                
                if ($imagem_thumbnail) : ?>
                    <img loading="lazy" class="max-w-full max-h-full" 
                    id="img-targe-<?=$elemento_id?>" 
                    src="<?= $imagem_thumbnail; ?>" 
                    alt="Imagem de destaque do veículo"
                    onerror="this.onerror=null; this.src='<?= get_imagem_padrao_veiculo_id() ?>'; this.alt='Imagem padrão do veículo';">
                <?php endif; ?>
                </div>
            </div>
            <?if($total_imagens > 0) : ?>
                <div class="img-loop">
                    <? get_template_part('template-parts/veiculos/session-loop-veiculos'); ?>
                </div>
            <? endif ?>
        <? else : ?>
            <div class="img-no-destaque">
                <img src="<?= get_imagem_padrao_veiculo_id() ?>">
            </div>
        <? endif ?>
    </div>
    <div class="group-content">
        <div class="vehicle-content">
            <? get_template_part('template-parts/veiculos/session-veiculo'); ?>
        </div>
        <div class="dynamic-content">
            <div class="dynamic-content-all">
                <div class="dynamic-content-box">
                    <div class="close-box">
                        <h1 class="w-10 text-[--primary_color] text-center  p-2 rounded-lg"> x</h1>
                    </div>

                    <div class="form-filter">
                        <?php get_template_part('template-parts/home/session', 'filtro'); ?>
                    </div>
                    <div id="form-simulacao" class="form-simulacao">
                        <?if(alt_credere_ativado() && !empty(alt_credere_get_cnpj($post->ID))):?>
                            <div id="credere-pnp"></div>
                        <?else:?>
                            <?php echo apply_shortcodes('[contact-form-7 id="" title="Formulário (Página de simulação)"]'); ?>
                        <? endif;?>
                    </div>
                </div>
            </div>
            <div class="form-simulacao-icons">
                <div id="option-pesquisar" class="options">
                    <svg width="30" height="30" viewBox="0 0 30 30" xmlns="http://www.w3.org/2000/svg">
                        <path d="M24.3762 12.1857C24.3762 14.8748 23.5031 17.3588 22.0323 19.3741L29.4507 26.7969C30.1831 27.5292 30.1831 28.7184 29.4507 29.4508C28.7182 30.1831 27.5287 30.1831 26.7962 29.4508L19.3779 22.028C17.3622 23.5044 14.8777 24.3714 12.1881 24.3714C5.45534 24.3714 0 18.9172 0 12.1857C0 5.45428 5.45534 0 12.1881 0C18.9208 0 24.3762 5.45428 24.3762 12.1857ZM12.1881 20.622C13.2962 20.622 14.3934 20.4038 15.4171 19.9798C16.4409 19.5558 17.3711 18.9344 18.1546 18.1511C18.9381 17.3677 19.5597 16.4377 19.9837 15.4141C20.4078 14.3906 20.626 13.2936 20.626 12.1857C20.626 11.0778 20.4078 9.98083 19.9837 8.9573C19.5597 7.93376 18.9381 7.00375 18.1546 6.22038C17.3711 5.437 16.4409 4.81559 15.4171 4.39162C14.3934 3.96766 13.2962 3.74945 12.1881 3.74945C11.08 3.74945 9.98278 3.96766 8.95905 4.39162C7.93531 4.81559 7.00512 5.437 6.22159 6.22038C5.43806 7.00375 4.81653 7.93376 4.39248 8.9573C3.96844 9.98083 3.75018 11.0778 3.75018 12.1857C3.75018 13.2936 3.96844 14.3906 4.39248 15.4141C4.81653 16.4377 5.43806 17.3677 6.22159 18.1511C7.00512 18.9344 7.93531 19.5558 8.95905 19.9798C9.98278 20.4038 11.08 20.622 12.1881 20.622Z" />
                    </svg>

                    <p>Pesquisa</p>
                </div>
                <div id="option-simular" class="options active">
                    <svg width="23" height="30" viewBox="0 0 23 30" xmlns="http://www.w3.org/2000/svg">
                        <path d="M3.83333 0C1.71901 0 0 1.68164 0 3.75V26.25C0 28.3184 1.71901 30 3.83333 30H19.1667C21.281 30 23 28.3184 23 26.25V9.375H15.3333C14.2732 9.375 13.4167 8.53711 13.4167 7.5V0H3.83333ZM15.3333 0V7.5H23L15.3333 0ZM3.83333 4.6875C3.83333 4.17188 4.26458 3.75 4.79167 3.75H8.625C9.15208 3.75 9.58333 4.17188 9.58333 4.6875C9.58333 5.20312 9.15208 5.625 8.625 5.625H4.79167C4.26458 5.625 3.83333 5.20312 3.83333 4.6875ZM3.83333 8.4375C3.83333 7.92188 4.26458 7.5 4.79167 7.5H8.625C9.15208 7.5 9.58333 7.92188 9.58333 8.4375C9.58333 8.95312 9.15208 9.375 8.625 9.375H4.79167C4.26458 9.375 3.83333 8.95312 3.83333 8.4375ZM11.5 12.6562C12.0271 12.6562 12.4583 13.0781 12.4583 13.5938V14.6074C12.9674 14.6777 13.4586 14.7891 13.9018 14.9062C14.4109 15.041 14.7164 15.5508 14.5786 16.0547C14.4409 16.5586 13.9198 16.8516 13.4047 16.7168C12.7398 16.541 12.087 16.4121 11.482 16.4062C10.9789 16.4004 10.4398 16.5117 10.0685 16.7285C9.72708 16.9277 9.58333 17.1562 9.58333 17.4785C9.58333 17.6953 9.6612 17.8594 10.0206 18.0703C10.4339 18.3105 11.0148 18.4863 11.7695 18.709L11.7995 18.7148C12.4763 18.9141 13.3148 19.1602 13.9737 19.5703C14.6984 20.0156 15.3154 20.7246 15.3333 21.8086C15.3513 22.9395 14.7583 23.7598 13.9617 24.2461C13.5005 24.5273 12.9794 24.6914 12.4583 24.7793V25.7812C12.4583 26.2969 12.0271 26.7188 11.5 26.7188C10.9729 26.7188 10.5417 26.2969 10.5417 25.7812V24.7383C9.87083 24.6152 9.24193 24.4043 8.69089 24.2168C8.5651 24.1758 8.43932 24.1348 8.31953 24.0938C7.81641 23.9297 7.54688 23.3965 7.71458 22.9102C7.88229 22.4238 8.42734 22.1543 8.92448 22.3184C9.07422 22.3652 9.21198 22.4121 9.34974 22.459C10.1643 22.7285 10.8232 22.9512 11.524 22.9688C12.069 22.9863 12.5961 22.8691 12.9435 22.6582C13.249 22.4707 13.4167 22.2305 13.4107 21.8379C13.4047 21.5684 13.3029 21.3809 12.9495 21.1582C12.5422 20.9062 11.9612 20.7246 11.2125 20.502L11.1167 20.4727C10.4578 20.2793 9.6612 20.0449 9.03229 19.6699C8.31354 19.248 7.67865 18.5625 7.67266 17.4844C7.66667 16.3477 8.31953 15.5625 9.09818 15.1113C9.5474 14.8535 10.0445 14.6895 10.5417 14.6016V13.5938C10.5417 13.0781 10.9729 12.6562 11.5 12.6562Z" />
                    </svg>

                    <p class="text-center">Simular compra</p>
                </div>
                <div id="option-whatsapp" class="options">
                    <a href="<?= alt_get_matriz_whatsapp() ?>" target="_blank" class="grid justify-items-center">
                        <img class="w-[23] h-[30]" src="<?= get_template_directory_uri() . '/assets/images/icon_wht.png'; ?>" alt="banner do site">
                        <p>Whatsapp</p>
                    </a>
                </div>
            </div>
        </div>
    </div>
    <?php if(alt_get_iframe_360($post->ID)) : ?>
        <div class="iframe-360">
            <h3 class="title">Foto 360°</h3>
            <iframe src="<?= alt_get_iframe_360($post->ID) ?>" width="100%" height="500"
                style="border:0; margin-top: 15px;" allowfullscreen="" loading="lazy"
                referrerpolicy="no-referrer-when-downgrade"></iframe>
        </div>
    <?php endif?>
    <div class="info-content">
        <div class="tab-infos">
            <div class="infos-description">
                <h3 class="">Descrição</h3>
                <svg width="22" height="12" viewBox="0 0 22 12" xmlns="http://www.w3.org/2000/svg">
                    <path d="M9.89055 11.5625C10.5042 12.1484 11.5007 12.1484 12.1144 11.5625L21.5398 2.5625C22.1534 1.97656 22.1534 1.025 21.5398 0.439063C20.9261 -0.146874 19.9296 -0.146874 19.316 0.439063L11 8.37969L2.68403 0.44375C2.0704 -0.142187 1.07386 -0.142187 0.460225 0.44375C-0.153408 1.02969 -0.153408 1.98125 0.460225 2.56719L9.88564 11.5672L9.89055 11.5625Z" />
                </svg>
            </div>

            <div role="tabpanel" class="content-description tab-pane hidden" id="informacoes-sobre-veiculo">
                <?= the_content() ?>
            </div>
            <hr class="line-internal">
        </div>
        <hr class="line-external">
        <div class="tab-infos">
            <div class="infos-options">
                <h3 class="">Opcionais e Acessórios</h3>
                <svg width="22" height="12" viewBox="0 0 22 12" xmlns="http://www.w3.org/2000/svg">
                    <path d="M9.89055 11.5625C10.5042 12.1484 11.5007 12.1484 12.1144 11.5625L21.5398 2.5625C22.1534 1.97656 22.1534 1.025 21.5398 0.439063C20.9261 -0.146874 19.9296 -0.146874 19.316 0.439063L11 8.37969L2.68403 0.44375C2.0704 -0.142187 1.07386 -0.142187 0.460225 0.44375C-0.153408 1.02969 -0.153408 1.98125 0.460225 2.56719L9.88564 11.5672L9.89055 11.5625Z" />
                </svg>
            </div>
            <div class="content-options hidden">
                <?php $acessorios = alt_get_caracteristicas($post->ID, 'alt_acessorios'); ?>
                <ul class="list-disc">
                    <?php
                    $count = 0;
                    if (is_array($acessorios)) : ?>
                        <?php foreach ($acessorios as $acessorio) : ?>
                            <li class="<?= $count <= 15 ? 'item' : 'item extra' ?>" style="<?= $count <= 15 ? '' : 'display: none' ?>"><?= $acessorio['descricao'] ?></li>
                        <?php
                            $count++;
                        endforeach; ?>
                    <?php endif; ?>
                </ul>
            </div>
            <hr class="line-internal">
        </div>
        <hr class="line-external">
    </div>
    <div class="show-options">
        <div class="group-title">
            <h1 class="title">Mais informações</h1>
            <svg width="11" height="11" viewBox="0 0 11 11" fill="none" xmlns="http://www.w3.org/2000/svg">
                <path d="M6.19444 0L4.80556 0V8.33333L0.986112 4.51389L0 5.5L5.5 11L11 5.5L10.0139 4.51389L6.19444 8.33333V0Z" fill="#1F1F1F" />
            </svg>
        </div>
        <div class="group-line">
            <hr class="line-internal-bottom">
            <hr class="line-internal-bottom">
        </div>
    </div>
    <div class="group-separator">
        <hr class="line-internal-bottom">
        <hr class="line-internal-bottom">
    </div>
</div>
<div class="canva-popup">
    <div class="sombra-popup"></div>
    <svg class="bt-fechar" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 384 512">
        <path fill="#FFFFFF" d="M342.6 150.6c12.5-12.5 12.5-32.8 0-45.3s-32.8-12.5-45.3 0L192 210.7 86.6 105.4c-12.5-12.5-32.8-12.5-45.3 0s-12.5 32.8 0 45.3L146.7 256 41.4 361.4c-12.5 12.5-12.5 32.8 0 45.3s32.8 12.5 45.3 0L192 301.3 297.4 406.6c12.5 12.5 32.8 12.5 45.3 0s12.5-32.8 0-45.3L237.3 256 342.6 150.6z" />
    </svg>
    <div class="controles-popup">
        <svg class="seta-popup seta-popup-prev" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512">
            <path fill="#FFFFFF" d="M233.4 105.4c12.5-12.5 32.8-12.5 45.3 0l192 192c12.5 12.5 12.5 32.8 0 45.3s-32.8 12.5-45.3 0L256 173.3 86.6 342.6c-12.5 12.5-32.8 12.5-45.3 0s-12.5-32.8 0-45.3l192-192z" />
        </svg>
        <svg class="seta-popup seta-popup-next" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512">
            <path fill="#FFFFFF" d="M233.4 105.4c12.5-12.5 32.8-12.5 45.3 0l192 192c12.5 12.5 12.5 32.8 0 45.3s-32.8 12.5-45.3 0L256 173.3 86.6 342.6c-12.5 12.5-32.8 12.5-45.3 0s-12.5-32.8 0-45.3l192-192z" />
        </svg>
    </div>
    <div class="container-img-popup">
        <img class="img-popup" src="" alt="imagem do veiculo ampliada" />
        <span class="load-popup"></span>
    </div>
</div>

<script>
    const boxDescricao = document.querySelector(".info-content .tab-infos:nth-child(1)");
    const larguraDisplay = window.innerWidth;
    larguraDisplay > 1365 ? boxDescricao.classList.add("descricao-menor") : '';

    var infosOptions = document.querySelector('.infos-options');
    var infosOptionsContent = document.querySelector('.content-options');
    var infosOptionsArrow = document.querySelector('.infos-options svg');
    var infosDescription = document.querySelector('.infos-description');
    var infosDescriptionContent = document.querySelector('.content-description');
    var infosDescriptionArrow = document.querySelector('.infos-description svg');
    var showOptions = document.querySelector('.show-options');
    var showOptionsSvg = document.querySelector('.show-options svg');
    var showItems = document.querySelector('.list-disc .item.extra');

    infosOptions.addEventListener('click', function() {
        infosOptionsContent.classList.toggle('hidden');
        infosOptionsArrow.classList.toggle('transform-rotate-180');
    });
    infosDescription.addEventListener('click', function() {
        infosDescriptionContent.classList.toggle('hidden');
        infosDescriptionArrow.classList.toggle('transform-rotate-180');
    });
    showOptions.addEventListener('click', function() {
        showOptionsSvg.classList.toggle('transform-rotate-180');
        infosDescriptionContent.classList.toggle('hidden');
        infosOptionsContent.classList.toggle('hidden');
        document.querySelectorAll('.list-disc .extra').forEach(el => {
            el.style.display = el.style.display === 'none' ? 'block' : 'none';
            document.querySelector('.show-options .group-title .title').innerText = el.style.display === 'block' ? "Menos informações" : "Mais informações";
        });
        boxDescricao.classList.contains("descricao-menor") ? boxDescricao.classList.remove("descricao-menor") : boxDescricao.classList.add("descricao-menor");
    });

    var imgDestaque = document.querySelector('.img-destaque');
    var contentDestaque = document.querySelector('.content-img');
    var contentMiniaturas = document.querySelector('.img-loop');
    var sBrowser,
        sUsrAg = navigator.userAgent;
    if (sUsrAg.indexOf("Chrome") > -1) {
        sBrowser = "Google Chrome";
    } else if (sUsrAg.indexOf("Safari") > -1) {
        sBrowser = "Apple Safari";
    } else if (sUsrAg.indexOf("Opera") > -1) {
        sBrowser = "Opera";
    } else if (sUsrAg.indexOf("Firefox") > -1) {
        sBrowser = "Mozilla Firefox";
    }
    if (sBrowser == "Mozilla Firefox") {
        imgDestaque.classList.remove('aspect-container');
        contentDestaque.classList.add('content-destaque');
        contentMiniaturas.classList.add('content-miniaturas');
    }
</script>

<!-- Caso a Matriz ou sendo portal, a loja possua CNPJ, este será utilizado para a integração. Caso contrário, nada será retornado. -->
<?alt_credere_cnpj($post->ID);?>