<?php 
    $banners = alt_banners();
    $i = 0;
?>
<?php if($banners) :?>

<div class="flex justify-center items-center">
    <div class="w-full">
        <div class="carousel">
            <button class="carousel-prev ">
                <
            </button>
            <button class="carousel-next">
                >
            </button>
            <div class="carousel-inner">
                <?php foreach ($banners as $banner) : ?>
    
                    <!-- Slides -->
                    <div class="carousel-item <?= $i == 0 ? 'active' : ''; ?> ">
                        <?php if (!empty($banner['link'])): ?>
                            <a target="<?= $banner['newBlank'] ?>" href="<?= $banner['link']?>">
                        <?php endif; ?>
                        <?=$banner['descricao']?>
                        <div class="img-banner view-desktop">
                            <img src="<?= $banner['url_relativa_desktop'] ?>" class="img-responsive" id="img-banner-desktop" alt="image" data-id="<?=get_the_ID()?>">
                            <div class="carousel-caption"></div>                            
                        </div>
                        <div class="img-banner view-mobile">
                            <img src="<?= $banner['url_relativa_mobile'] ?>" class="img-responsive" id="img-banner-mobile" alt="image" data-id="<?=get_the_ID()?>">
                            <div class="carousel-caption"></div>
                        </div> 
                        <?php if (!empty($banner['link'])): ?>
                            </a>
                        <?php endif; ?>
                    </div>  
                    <?php $i++; ?>
                <?php endforeach; ?>
            </div>
        </div>
    </div>
</div>

<script>
    document.addEventListener("DOMContentLoaded", function () {
        const items = document.querySelectorAll(".carousel-item");
        const totalItems = items.length;
        let currentIndex = 0; 

        function ajustarAltura(){
            let dispositivo = '';
            const largutaTela = window.innerWidth;
            largutaTela > 767 ? dispositivo = 'desktop' : dispositivo = 'mobile';

            const imgBanner = document.querySelector(`.carousel-inner .active .view-${dispositivo}`);
            const bannerContainer = document.querySelector('.carousel');
            const alturaImg = imgBanner.clientHeight;
            
            bannerContainer.style.transition = '.5s';
            bannerContainer.style.height =`${alturaImg}px`;
        }
        window.addEventListener('load', ajustarAltura);

        function moveCarouselTo(index) { 
                   
            const itemWidth = items[0].clientWidth;
            const offset = index * -itemWidth;
            document.querySelector(".carousel-inner").style.transform = `translateX(${offset}px)`;
            currentIndex = index;
            
            if(totalItems > 0){
                items.forEach( item => {
                    item.classList.remove("active");
                });
            };            
            items[currentIndex].classList.add("active");

            ajustarAltura();    
        }

        function prevSlide() {
            currentIndex = (currentIndex > 0) ? currentIndex - 1 : totalItems - 1;
            moveCarouselTo(currentIndex);
        }

        function nextSlide() {
            currentIndex = (currentIndex < totalItems - 1) ? currentIndex + 1 : 0;
            moveCarouselTo(currentIndex);
        }

        document.querySelector(".carousel-prev").addEventListener("click", prevSlide);
        document.querySelector(".carousel-next").addEventListener("click", nextSlide);

        const tempoTrocaBanner = 5000;
        setInterval(nextSlide, tempoTrocaBanner);
    });
</script>

<?php endif; ?>