<?php
$arrCarroceria = alt_get_lista_carrocerias();
?>
<div>
    <h2 class="categoria_titulo">Categorias</h2>
    <div class="car-slider swiper">
    <div class="swiper-wrapper">
        <?php foreach ($arrCarroceria as $key => $carroceria) : ?>
            <div class="car-slider-slide swiper-slide shrink-0 p-2">
                <div class="card-categoria-item relative">
                    <a href="/estoque/?categoria=<?= $key ?>">
                        <div class="absolute inset-0 flex items-start">
                            <h3 class="text-white text-lg font-bold p-4">
                                <?= $carroceria['nome'] ?>
                            </h3>
                        </div>
                        <img class="w-full h-auto rounded-lg object-cover" src="<?= $carroceria['imagem']; ?>" alt="Imagem da categoria de <?= $carroceria['nome'] ?>" />
                    </a>
                </div>
            </div>
        <?php endforeach; ?>
    </div>

    <!-- Botão de navegação -->
    <div class="swiper-button-prev">
        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 320 512">
            <path d="M9.4 233.4c-12.5 12.5-12.5 32.8 0 45.3l192 192c12.5 12.5 32.8 12.5 45.3 0s12.5-32.8 0-45.3L77.3 256 246.6 86.6c12.5-12.5 12.5-32.8 0-45.3s-32.8-12.5-45.3 0l-192 192z"/>
        </svg>
    </div>
    <div class="swiper-button-next">
        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 320 512">
            <path d="M278.6 233.4c12.5 12.5 12.5 32.8 0 45.3l-160 160c-12.5 12.5-32.8 12.5-45.3 0s-12.5-32.8 0-45.3L210.7 256 73.4 118.6c-12.5-12.5-12.5-32.8 0-45.3s32.8-12.5 45.3 0l160 160z"/>
        </svg>
    </div>
</div>
</div>

<!-- <script src="https://cdn.jsdelivr.net/npm/swiper@11/swiper-bundle.min.js"></script> -->
<script>
    const swiper = new Swiper('.car-slider', {
        slidesPerView: 'auto',
        spaceBetween: 10,
        navigation: {
            nextEl: '.swiper-button-next',
            prevEl: '.swiper-button-prev',
        },
        breakpoints: {
            768: {
                slidesPerView: 4,
                spaceBetween: 10,
            },
            1024: {
                slidesPerView: 5,
                spaceBetween: 10,
            }
        }
    });
</script>
