<?
// ================================
// Variáveis relacionadas às imagens do veículo
// ================================
$lista_imagens = alt_get_imagens_veiculo($veiculo->ID);
$attachment = $lista_imagens[0]["position"];
$elemento_id = $veiculo->ID . "" . $attachment;
$total_imagens = count($lista_imagens);
$imagem_thumbnail = alt_get_imagem_destaque($veiculo->ID, $lista_imagens);

// ================================
// Variáveis relacionadas a dados do veículo
// ================================
$arrItens = get_caracteristas_widget();
?>

<div class="card-list-veiculo zoom flex flex-row flex-grow border border-gray-200 shadow rounded-md m-4 container">
    <div class="box-link-img">
        <a href="<?= get_permalink($veiculo->ID) ?>" class="list-link-img">
            <? if ($total_imagens > 0 || $imagem_thumbnail) : ?>
                <div class="img-no-destaque">
                    <?php if ($imagem_thumbnail) : ?>
                        <img loading="lazy" class="max-w-full max-h-full" 
                        id="img-targe-<?=$elemento_id?>" 
                        src="<?= $imagem_thumbnail; ?>" alt="Imagem de destaque do veículo"
                        onerror="this.onerror=null; this.src='<?= get_imagem_padrao_veiculo_id() ?>'; this.alt='Imagem padrão do veículo';">
                    <?php endif; ?>
                    <div class="alt-tags">
                        <? foreach (alt_get_tag_all($veiculo->ID) as $tag) : ?>
                            <div class="item-tag">
                                <span><?= $tag ?></span>
                            </div>
                        <? endforeach ?>
                    </div>
                </div>
            <? else : ?>
                <img src="<?= get_imagem_padrao_veiculo_id() ?>" alt="Imagem padrão do veículo">
            <? endif ?>
        </a>
        <div class="box-slide">
            <div class="slide-prev" id="slide-prev-<?=$elemento_id?>">
                <svg width="12" height="23" viewBox="0 0 12 23" xmlns="http://www.w3.org/2000/svg">
                    <path d="M0.439453 10.6601C-0.146484 11.2737 -0.146484 12.2703 0.439453 12.8839L9.43945 22.3093C10.0254 22.9229 10.977 22.9229 11.5629 22.3093C12.1488 21.6957 12.1488 20.6991 11.5629 20.0855L3.62227 11.7695L11.5582 3.45357C12.1441 2.83993 12.1441 1.84339 11.5582 1.22976C10.9723 0.616123 10.0207 0.616123 9.43476 1.22976L0.434766 10.6552L0.439453 10.6601Z"/>
                </svg>
            </div>
            <div class="slide-itens">
                <?foreach ($lista_imagens as $key => $value): ?>
                    <div class="slide-item <?= $key == 0 ? 'active' : '' ?>" id="box-veiculo-<?=$elemento_id?>">
                        <p><?= $key+1 . ' / ' . $total_imagens ?></p>
                        <input type="hidden" id="<?=$elemento_id?>-<?=$key?>" value="<?=$value['src']?>">
                    </div>
                <? endforeach ?>
            </div>
            <div class="slide-next" id="slide-next-<?=$elemento_id?>">
                <svg width="13" height="23" viewBox="0 0 13 23" xmlns="http://www.w3.org/2000/svg">
                    <path d="M12.123 12.879C12.709 12.2653 12.709 11.2688 12.123 10.6552L3.12305 1.22976C2.53711 0.616123 1.58555 0.616123 0.99961 1.22976C0.413672 1.84339 0.413672 2.83993 0.99961 3.45357L8.94023 11.7695L1.0043 20.0855C0.41836 20.6991 0.41836 21.6957 1.0043 22.3093C1.59023 22.9229 2.5418 22.9229 3.12774 22.3093L12.1277 12.8839L12.123 12.879Z"/>
                </svg>
            </div>
        </div>
    </div>
    <div class="card-content-title">
        <div class="list-link-title">
            <a href="<?= get_permalink($veiculo->ID) ?>" class="box-link-title">
                <div class="card_thumb">
                    <?= get_marca_thumb($veiculo->ID) ?>
                </div>
                <div class="tablet:w-5/6 flex items-center px-4">
                    <span class="card_title font-bold">
                        <?= get_modelo_do_veiculo($veiculo->ID); ?>
                    </span>
                </div>
            </a>
            <a href="<?= alt_get_matriz_whatsapp(get_permalink($veiculo->ID)) ?>" target="_blank" class="tablet:w-20 flex justify-end items-center">
                <svg width="20" height="23" viewBox="0 0 20 23" xmlns="http://www.w3.org/2000/svg">
                    <path d="M16.6667 15.7807C15.8222 15.7807 15.0667 16.1122 14.4889 16.6315L6.56667 12.0459C6.62222 11.7917 6.66667 11.5376 6.66667 11.2724C6.66667 11.0072 6.62222 10.753 6.56667 10.4989L14.4 5.95746C15 6.50995 15.7889 6.85249 16.6667 6.85249C17.5507 6.85249 18.3986 6.50324 19.0237 5.88157C19.6488 5.25991 20 4.41674 20 3.53757C20 2.6584 19.6488 1.81524 19.0237 1.19357C18.3986 0.571906 17.5507 0.222656 16.6667 0.222656C15.7826 0.222656 14.9348 0.571906 14.3096 1.19357C13.6845 1.81524 13.3333 2.6584 13.3333 3.53757C13.3333 3.80277 13.3778 4.05691 13.4333 4.31105L5.6 8.85249C5 8.3 4.21111 7.95746 3.33333 7.95746C2.44928 7.95746 1.60143 8.30671 0.976311 8.92838C0.35119 9.55005 0 10.3932 0 11.2724C0 12.1516 0.35119 12.9947 0.976311 13.6164C1.60143 14.238 2.44928 14.5873 3.33333 14.5873C4.21111 14.5873 5 14.2448 5.6 13.6923L13.5111 18.2779C13.4556 18.5099 13.4222 18.753 13.4222 19.0072C13.4222 20.7862 14.8778 22.2227 16.6667 22.2227C18.4556 22.2227 19.9111 20.7862 19.9111 19.0072C19.9111 18.1515 19.5693 17.3308 18.9608 16.7257C18.3524 16.1206 17.5271 15.7807 16.6667 15.7807Z" />
                </svg>
            </a>
        </div>
        <a href="<?= alt_get_matriz_whatsapp(get_permalink($veiculo->ID)) ?>" target="_blank" class="box-link-subtitle">
            <span class="card_subtitle">
                <?= get_titulo_produto($veiculo->ID, false); ?>
                <!-- <?= get_post_meta($veiculo->ID, 'alt_complemento', true); ?> -->
            </span>
        </a>
        <div class="card-content-info">
            <div class="card-list-itens">

                <?php if ($arrItens === false || in_array('alt_ano_mod', $arrItens)) : ?>
                    <div class="card-content-item ">
                        <svg width="19" height="22" viewBox="0 0 19 22" xmlns="http://www.w3.org/2000/svg">
                            <path d="M4.07143 1.375V2.75H2.03571C0.91183 2.75 0 3.67383 0 4.8125V6.875H19V4.8125C19 3.67383 18.0882 2.75 16.9643 2.75H14.9286V1.375C14.9286 0.614453 14.3221 0 13.5714 0C12.8208 0 12.2143 0.614453 12.2143 1.375V2.75H6.78571V1.375C6.78571 0.614453 6.17924 0 5.42857 0C4.6779 0 4.07143 0.614453 4.07143 1.375ZM19 8.25H0V19.9375C0 21.0762 0.91183 22 2.03571 22H16.9643C18.0882 22 19 21.0762 19 19.9375V8.25Z" />
                        </svg>
                        <span>Ano</span>
                        <?= alt_get_caracteristicas($veiculo->ID, 'alt_ano_mod'); ?>
                    </div>
                <?php endif; ?>
                <?php if ($arrItens === false || in_array('alt_kilometragem', $arrItens)) : ?>
                    <div class="card-content-item">
                        <svg viewBox="0 0 22 22" xmlns="http://www.w3.org/2000/svg">
                            <path d="M0 11C0 8.08262 1.15893 5.28473 3.22183 3.22183C5.28473 1.15893 8.08262 0 11 0C13.9174 0 16.7153 1.15893 18.7782 3.22183C20.8411 5.28473 22 8.08262 22 11C22 13.9174 20.8411 16.7153 18.7782 18.7782C16.7153 20.8411 13.9174 22 11 22C8.08262 22 5.28473 20.8411 3.22183 18.7782C1.15893 16.7153 0 13.9174 0 11ZM12.375 4.125C12.375 3.76033 12.2301 3.41059 11.9723 3.15273C11.7144 2.89487 11.3647 2.75 11 2.75C10.6353 2.75 10.2856 2.89487 10.0277 3.15273C9.76987 3.41059 9.625 3.76033 9.625 4.125C9.625 4.48967 9.76987 4.83941 10.0277 5.09727C10.2856 5.35513 10.6353 5.5 11 5.5C11.3647 5.5 11.7144 5.35513 11.9723 5.09727C12.2301 4.83941 12.375 4.48967 12.375 4.125ZM11 17.875C12.5168 17.875 13.75 16.6418 13.75 15.125C13.75 14.3773 13.4535 13.7027 12.9723 13.2086L15.7266 6.94805C15.9543 6.42812 15.718 5.81797 15.198 5.59023C14.6781 5.3625 14.068 5.59883 13.8402 6.11875L11.0816 12.375C11.0559 12.375 11.0258 12.375 11 12.375C9.4832 12.375 8.25 13.6082 8.25 15.125C8.25 16.6418 9.4832 17.875 11 17.875ZM7.5625 6.1875C7.5625 5.82283 7.41763 5.47309 7.15977 5.21523C6.90191 4.95737 6.55217 4.8125 6.1875 4.8125C5.82283 4.8125 5.47309 4.95737 5.21523 5.21523C4.95737 5.47309 4.8125 5.82283 4.8125 6.1875C4.8125 6.55217 4.95737 6.90191 5.21523 7.15977C5.47309 7.41763 5.82283 7.5625 6.1875 7.5625C6.55217 7.5625 6.90191 7.41763 7.15977 7.15977C7.41763 6.90191 7.5625 6.55217 7.5625 6.1875ZM4.125 12.375C4.48967 12.375 4.83941 12.2301 5.09727 11.9723C5.35513 11.7144 5.5 11.3647 5.5 11C5.5 10.6353 5.35513 10.2856 5.09727 10.0277C4.83941 9.76987 4.48967 9.625 4.125 9.625C3.76033 9.625 3.41059 9.76987 3.15273 10.0277C2.89487 10.2856 2.75 10.6353 2.75 11C2.75 11.3647 2.89487 11.7144 3.15273 11.9723C3.41059 12.2301 3.76033 12.375 4.125 12.375ZM19.25 11C19.25 10.6353 19.1051 10.2856 18.8473 10.0277C18.5894 9.76987 18.2397 9.625 17.875 9.625C17.5103 9.625 17.1606 9.76987 16.9027 10.0277C16.6449 10.2856 16.5 10.6353 16.5 11C16.5 11.3647 16.6449 11.7144 16.9027 11.9723C17.1606 12.2301 17.5103 12.375 17.875 12.375C18.2397 12.375 18.5894 12.2301 18.8473 11.9723C19.1051 11.7144 19.25 11.3647 19.25 11Z" />
                        </svg>
                        <span>Km</span>
                        <?= get_veiculo_km($veiculo->ID) ?>
                    </div>
                <?php endif; ?>
                <?php if ($arrItens === false || in_array('alt_combustivel', $arrItens)) : ?>
                    <div class="card-content-item">
                        <svg width="22" height="22" viewBox="0 0 22 22" xmlns="http://www.w3.org/2000/svg">
                            <path d="M1.375 2.75C1.375 1.2332 2.6082 0 4.125 0H11C12.5168 0 13.75 1.2332 13.75 2.75V11H14.0938C16.182 11 17.875 12.693 17.875 14.7812V16.1562C17.875 16.7277 18.3348 17.1875 18.9062 17.1875C19.4777 17.1875 19.9375 16.7277 19.9375 16.1562V9.53906C18.7516 9.23398 17.875 8.15547 17.875 6.875V4.125L16.5 2.75C16.1219 2.37188 16.1219 1.75312 16.5 1.375C16.8781 0.996875 17.4969 0.996875 17.875 1.375L21.1965 4.69648C21.7121 5.21211 22 5.9125 22 6.64297V7.21875V8.25V9.625V16.1562C22 17.8664 20.6164 19.25 18.9062 19.25C17.1961 19.25 15.8125 17.8664 15.8125 16.1562V14.7812C15.8125 13.8316 15.0434 13.0625 14.0938 13.0625H13.75V19.25C14.5105 19.25 15.125 19.8645 15.125 20.625C15.125 21.3855 14.5105 22 13.75 22H1.375C0.614453 22 0 21.3855 0 20.625C0 19.8645 0.614453 19.25 1.375 19.25V2.75ZM4.125 3.4375V7.5625C4.125 7.94063 4.43437 8.25 4.8125 8.25H10.3125C10.6906 8.25 11 7.94063 11 7.5625V3.4375C11 3.05938 10.6906 2.75 10.3125 2.75H4.8125C4.43437 2.75 4.125 3.05938 4.125 3.4375Z" />
                        </svg>
                        <span>Combustível</span>
                        <?= alt_get_caracteristicas($veiculo->ID, 'alt_combustivel'); ?>
                    </div>
                <?php endif; ?>
                <?php if ($arrItens === false || in_array('alt_horas', $arrItens)) : ?>
                <div class="card-content-item">
                    <svg width="28" height="22" viewBox="0 0 30 22" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <path d="M19.0909 22C16.0455 22 13.4659 20.9344 11.3523 18.8031C9.23864 16.6719 8.18182 14.0708 8.18182 11C8.18182 7.95208 9.23864 5.35677 11.3523 3.21406C13.4659 1.07135 16.0455 0 19.0909 0C22.1136 0 24.6875 1.07135 26.8125 3.21406C28.9375 5.35677 30 7.95208 30 11C30 14.0708 28.9375 16.6719 26.8125 18.8031C24.6875 20.9344 22.1136 22 19.0909 22ZM22.1932 16.1219L24.1364 14.1625L20.4545 10.45V5.5H17.7273V11.5844L22.1932 16.1219ZM1.36364 6.875V4.125H6.81818V6.875H1.36364ZM0 12.375V9.625H6.81818V12.375H0ZM1.36364 17.875V15.125H6.81818V17.875H1.36364Z"/>
                    </svg>
                    <span>Horas</span>
                    <?= alt_get_caracteristicas($veiculo->ID, 'horas_barco');?>
                </div>
            <?php endif; ?>
            <?php if ($arrItens === false || in_array('alt_motorizacao', $arrItens)) : ?>
                <div class="card-content-item">
                    <svg width="29" height="22" viewBox="0 0 29 22" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <path fill-rule="evenodd" clip-rule="evenodd" d="M10.285 21.4441L7.52848 18.7299H5.63102C4.96785 18.7299 4.42505 18.1949 4.42505 17.5414V15.5179H3.27572V17.8856C3.27572 18.3903 2.85563 18.8043 2.34351 18.8043H0.93221C0.420085 18.8043 0 18.3903 0 17.8856V9.86151C0 9.3568 0.420085 8.94281 0.93221 8.94281H2.34351C2.85563 8.94281 3.27572 9.3568 3.27572 9.86151V12.2292H4.42505V10.0522C4.42505 9.39867 4.96785 8.86373 5.63102 8.86373H7.64648L10.495 5.87969C10.8254 5.59594 11.2644 5.49593 11.7765 5.51686H23.5129C23.9189 5.56105 24.228 5.71456 24.4168 6.00296C24.6056 6.28671 24.575 6.44719 24.575 6.76583V12.2292H25.7243V9.86151C25.7243 9.3568 26.1444 8.94281 26.6565 8.94281H28.0678C28.5799 8.94281 29 9.3568 29 9.86151V17.8856C29 18.3903 28.5799 18.8043 28.0678 18.8043H26.6565C26.1444 18.8043 25.7243 18.3903 25.7243 17.8856V15.5179H24.575V15.7319C24.575 16.3668 24.5938 16.7506 24.1832 17.2762C24.1053 17.3763 24.018 17.4716 23.9212 17.56L19.7133 21.6209C19.5033 21.8511 19.1847 21.9767 18.7646 22H11.5901C11.0544 21.9767 10.6178 21.7953 10.285 21.4441ZM15.0357 14.369L12.0527 14.0922L14.526 8.75209H17.9079L15.9892 11.8152L19.4395 12.192L13.1052 19.6858L15.0357 14.369ZM12.2674 0H20.4095C20.9216 0 21.3417 0.413997 21.3417 0.918702V2.30955C21.3417 2.81425 20.9216 3.22825 20.4095 3.22825H18.007V4.39814H14.6699V3.22825H12.2674C11.7553 3.22825 11.3352 2.81425 11.3352 2.30955V0.918702C11.3352 0.413997 11.7553 0 12.2674 0Z"/>
                    </svg>
                    <span>Motorização</span>
                    <p class="w-full text-center">
                        <?= alt_get_caracteristicas($veiculo->ID, 'motorizacao_tipo');?>
                    </p>
                </div>
            <?php endif; ?>
            </div>
            <div class="card-content-price">
                <?php if ((alt_get_valor_promocional($veiculo->ID)) != false) :  ?>
                    <div class="card-price-promo">
                        <div class="price-de">
                            <span class="label">De:</span>
                            <span class="price"><?= get_preco_veiculo($veiculo->ID) ?></span>
                        </div>
                        <div class="price-por">
                            <span class="label">Por: </span>
                            <span class="price"><?= alt_get_valor_promocional($veiculo->ID); ?></span>
                        </div>
                    </div>
                <?php else : ?>
                    <span class="text-4xl font-bold px-4">
                        <?php echo get_preco_veiculo($veiculo->ID); ?>
                    </span>
                <?php endif ?>
            </div>
            <div class="card_content_buttons list-stock">
                <div class="content-btn-more-details">
                    <a href="<?= get_permalink($veiculo->ID) ?>" class="btn-more-details btn">Mais detalhes</a>
                </div>
                <div class="content-btn-more-details list-whatsapp" style="display: <?= alt_visibility_whatsapp() ?>;">
                    <a class="whatsapp-btn btn" href="<?= alt_get_matriz_whatsapp(get_permalink($veiculo->ID)) ?>" target="_blank">
                        Whatsapp
                        <svg width="25" height="25" viewBox="0 0 25 25" xmlns="http://www.w3.org/2000/svg">
                            <path id="Vector" d="M21.0466 3.54568C18.7645 1.25814 15.7253 0 12.4955 0C5.82899 0 0.404265 5.42473 0.404265 12.0913C0.404265 14.2209 0.95981 16.3014 2.01643 18.1369L0.300781 24.4004L6.71133 22.7174C8.476 23.6814 10.464 24.188 12.4901 24.188H12.4955C19.1566 24.188 24.7012 18.7632 24.7012 12.0967C24.7012 8.86693 23.3286 5.83322 21.0466 3.54568ZM12.4955 22.151C10.6873 22.151 8.91717 21.6662 7.3758 20.7512L7.01089 20.5334L3.20922 21.5301L4.22227 17.821L3.98263 17.4397C2.97502 15.8385 2.44671 13.9921 2.44671 12.0913C2.44671 6.55216 6.95642 2.04244 12.501 2.04244C15.1861 2.04244 17.7078 3.08817 19.6032 4.98901C21.4986 6.88984 22.6642 9.41158 22.6587 12.0967C22.6587 17.6413 18.0346 22.151 12.4955 22.151ZM18.0074 14.6239C17.7078 14.4714 16.2209 13.7416 15.9432 13.6435C15.6654 13.54 15.4639 13.491 15.2624 13.796C15.0608 14.101 14.4835 14.7764 14.3038 14.9834C14.1295 15.1849 13.9497 15.2121 13.6502 15.0596C11.8746 14.1718 10.7091 13.4747 9.53807 11.4649C9.22762 10.9312 9.84852 10.9693 10.4259 9.81462C10.5239 9.6131 10.4749 9.43881 10.3986 9.28631C10.3224 9.13381 9.71781 7.64691 9.46727 7.04235C9.22217 6.45412 8.97163 6.53582 8.78645 6.52493C8.61216 6.51403 8.41064 6.51403 8.20912 6.51403C8.0076 6.51403 7.68081 6.59028 7.40304 6.88984C7.12527 7.19485 6.34641 7.92468 6.34641 9.41158C6.34641 10.8985 7.43027 12.3364 7.57733 12.5379C7.72983 12.7394 9.70691 15.7894 12.7406 17.1021C14.6578 17.9299 15.4094 18.0007 16.368 17.8591C16.9508 17.772 18.1545 17.1293 18.405 16.4212C18.6555 15.7132 18.6555 15.1086 18.5793 14.9834C18.5085 14.8472 18.307 14.771 18.0074 14.6239Z" />
                        </svg>
                    </a>
                </div>
            </div>
        </div>
    </div>
</div>