<?$display_map = (isset($box['display_map']) ? $box['display_map'] : true) ?>
<?$display_title = (isset($box['display_title']) ? $box['display_title'] : true) ?>

<?php if ($box['single']): ?>
    <div class="single abs">
        <?$filial = reset($box["filiais"]);?>
        <?$filial['display_title'] = $display_title?>
        <?set_query_var( 'filial', $filial );?>
        <?php get_template_part('template-parts/contato/session', 'box-contato', $filial); ?>
    </div>
    <?php if (!empty($box['filiais'][0]['script_mapa']) && $display_map): ?>
        <div class="content-maps">
            <?= html_entity_decode($box['filiais'][0]['script_mapa']); ?>
        </div>
    <?php endif; ?>
<?php else : ?>
    <?php foreach ($box['filiais'] as $key => $filial): ?>
        <?if ($display_map) :?>
            <div class="multiple">
                <h6 class="line-accordion mb-0 accordion-box dark:bg-white">
                    <button
                        class="relative flex items-center w-full p-4 font-semibold text-left transition-all ease-in border-b border-solid cursor-pointer border-slate-100 text-slate-700 rounded-t-1 group text-dark-500"
                        data-collapse-target="animated-collapse-<?=$key;?>"
                    >
                        <span><?= $filial['nome']; ?></span>
                        <svg class="absolute right-2 pt-1 text-base transition-transform group-open:rotate-180" width="22" height="12" viewBox="0 0 22 12" xmlns="http://www.w3.org/2000/svg">
                            <path d="M9.89055 11.5625C10.5042 12.1484 11.5007 12.1484 12.1144 11.5625L21.5398 2.5625C22.1534 1.97656 22.1534 1.025 21.5398 0.439063C20.9261 -0.146874 19.9296 -0.146874 19.316 0.439063L11 8.37969L2.68403 0.44375C2.0704 -0.142187 1.07386 -0.142187 0.460225 0.44375C-0.153408 1.02969 -0.153408 1.98125 0.460225 2.56719L9.88564 11.5672L9.89055 11.5625Z" fill="#1E1B1D" fill-opacity="0.6"/>
                        </svg>
                    </button>
                </h6>
                <div
                    data-collapse="animated-collapse-<?=$key;?>"
                    class="accordion-content h-0 overflow-hidden transition-all duration-300 ease-in-out"
                >
                    <div class="maps-contact accordion-box">
                        <div class="content-contacts">
                            <div>
                                <span class="contato-filial"><?= $filial['nome']; ?></span>
                                <h2 class="title-fale-conosco">Fale conosco</h2>
                            </div>
                            <?php if (!empty($filial['endereco_completo'])): ?>
                                <div>
                                    <div class="contact-item">
                                        <svg width="42" height="37" viewBox="0 0 42 37" xmlns="http://www.w3.org/2000/svg">
                                            <path id="Vector" d="M29.75 8.80187C29.75 12.8067 24.4198 19.9436 22.0792 22.8849C21.5177 23.589 20.475 23.589 19.9208 22.8849C17.5802 19.9436 12.25 12.8067 12.25 8.80187C12.25 3.93884 16.1656 0 21 0C25.8344 0 29.75 3.93884 29.75 8.80187ZM30.3333 14.6991C30.5885 14.193 30.8219 13.6869 31.0333 13.1881C31.0698 13.1001 31.1062 13.0048 31.1427 12.9167L39.601 9.51335C40.7531 9.05126 42 9.9021 42 11.149V31.0119C42 31.7307 41.5625 32.3762 40.899 32.6476L30.3333 36.8945V14.6991ZM10.0333 10.1442C10.2083 11.1784 10.5583 12.2199 10.9667 13.1881C11.1781 13.6869 11.4115 14.193 11.6667 14.6991V33.139L2.39896 36.8725C1.24688 37.3346 0 36.4837 0 35.2368V15.3739C0 14.6551 0.4375 14.0096 1.10104 13.7383L10.0406 10.1442H10.0333ZM23.9021 24.3518C24.9156 23.0756 26.5052 20.9998 28 18.704V36.9899L14 32.963V18.704C15.4948 20.9998 17.0844 23.0756 18.0979 24.3518C19.5927 26.2296 22.4073 26.2296 23.9021 24.3518ZM21 11.149C21.7735 11.149 22.5154 10.8399 23.0624 10.2897C23.6094 9.73947 23.9167 8.99321 23.9167 8.21508C23.9167 7.43694 23.6094 6.69068 23.0624 6.14046C22.5154 5.59023 21.7735 5.28112 21 5.28112C20.2265 5.28112 19.4846 5.59023 18.9376 6.14046C18.3906 6.69068 18.0833 7.43694 18.0833 8.21508C18.0833 8.99321 18.3906 9.73947 18.9376 10.2897C19.4846 10.8399 20.2265 11.149 21 11.149Z" fill="#1E1B1D" fill-opacity="0.6"/>
                                        </svg>
                                        <?= $filial['endereco_completo']; ?>
                                    </div>
                                </div>
                            <?php endif; ?>
                            <?php if (!empty($filial['telefone'])): ?>
                                <div>
                                    <!-- <div class="icon_wrap"><i class="fa fa-phone" aria-hidden="true"></i></div> -->
                                    <div class="contact-item">
                                        <svg width="37" height="37" viewBox="0 0 37 37" xmlns="http://www.w3.org/2000/svg">
                                            <path id="Vector" d="M11.9161 1.77929C11.3597 0.435204 9.89273 -0.280194 8.49084 0.102797L2.13174 1.8371C0.874376 2.18396 0 3.3257 0 4.62643C0 22.5042 14.4958 37 32.3736 37C33.6743 37 34.816 36.1256 35.1629 34.8683L36.8972 28.5092C37.2802 27.1073 36.5648 25.6403 35.2207 25.0839L28.2835 22.1934C27.1056 21.702 25.7399 22.0417 24.9378 23.0317L22.0184 26.5942C16.9311 24.1879 12.8121 20.0689 10.4058 14.9816L13.9683 12.0695C14.9583 11.2601 15.298 9.90158 14.8066 8.72371L11.9161 1.78651V1.77929Z" fill="#1E1B1D" fill-opacity="0.6"/>
                                        </svg>
                                        <a href="<?= $filial['url_telefone']; ?>">
                                            <?= alt_formatar_telefone($filial['telefone']); ?>
                                        </a>
                                    </div>
                                </div>
                            <?php endif; ?>
                            
                            <?php if (!empty($filial['email'])): ?>
                                <div>
                                    <div class="contact-item">
                                        <svg width="49" height="37" viewBox="0 0 49 37" xmlns="http://www.w3.org/2000/svg">
                                            <path id="Vector" d="M4.59375 0C2.05762 0 0 2.07161 0 4.625C0 6.07995 0.679492 7.44818 1.8375 8.325L22.6625 24.05C23.7535 24.869 25.2465 24.869 26.3375 24.05L47.1625 8.325C48.3205 7.44818 49 6.07995 49 4.625C49 2.07161 46.9424 0 44.4062 0H4.59375ZM0 10.7917V30.8333C0 34.2346 2.74668 37 6.125 37H42.875C46.2533 37 49 34.2346 49 30.8333V10.7917L28.175 26.5167C25.993 28.1643 23.007 28.1643 20.825 26.5167L0 10.7917Z" fill="#1E1B1D" fill-opacity="0.6"/>
                                        </svg>
                                        <a href="<?= $filial['url_email']; ?>">
                                            <?= $filial['email']; ?>
                                        </a>
                                    </div>
                                </div>
                            <?php endif; ?>

                            <?php if (!empty($filial['whatsapp'])): ?>
                                <div class="contact-item">
                                    <a class="whatsapp-btn btn" href="<?= $filial['url_whatsapp']; ?>">
                                        Whatsapp
                                        <svg width="25" height="25" viewBox="0 0 25 25" xmlns="http://www.w3.org/2000/svg">
                                            <path id="Vector" d="M21.0466 3.54568C18.7645 1.25814 15.7253 0 12.4955 0C5.82899 0 0.404265 5.42473 0.404265 12.0913C0.404265 14.2209 0.95981 16.3014 2.01643 18.1369L0.300781 24.4004L6.71133 22.7174C8.476 23.6814 10.464 24.188 12.4901 24.188H12.4955C19.1566 24.188 24.7012 18.7632 24.7012 12.0967C24.7012 8.86693 23.3286 5.83322 21.0466 3.54568ZM12.4955 22.151C10.6873 22.151 8.91717 21.6662 7.3758 20.7512L7.01089 20.5334L3.20922 21.5301L4.22227 17.821L3.98263 17.4397C2.97502 15.8385 2.44671 13.9921 2.44671 12.0913C2.44671 6.55216 6.95642 2.04244 12.501 2.04244C15.1861 2.04244 17.7078 3.08817 19.6032 4.98901C21.4986 6.88984 22.6642 9.41158 22.6587 12.0967C22.6587 17.6413 18.0346 22.151 12.4955 22.151ZM18.0074 14.6239C17.7078 14.4714 16.2209 13.7416 15.9432 13.6435C15.6654 13.54 15.4639 13.491 15.2624 13.796C15.0608 14.101 14.4835 14.7764 14.3038 14.9834C14.1295 15.1849 13.9497 15.2121 13.6502 15.0596C11.8746 14.1718 10.7091 13.4747 9.53807 11.4649C9.22762 10.9312 9.84852 10.9693 10.4259 9.81462C10.5239 9.6131 10.4749 9.43881 10.3986 9.28631C10.3224 9.13381 9.71781 7.64691 9.46727 7.04235C9.22217 6.45412 8.97163 6.53582 8.78645 6.52493C8.61216 6.51403 8.41064 6.51403 8.20912 6.51403C8.0076 6.51403 7.68081 6.59028 7.40304 6.88984C7.12527 7.19485 6.34641 7.92468 6.34641 9.41158C6.34641 10.8985 7.43027 12.3364 7.57733 12.5379C7.72983 12.7394 9.70691 15.7894 12.7406 17.1021C14.6578 17.9299 15.4094 18.0007 16.368 17.8591C16.9508 17.772 18.1545 17.1293 18.405 16.4212C18.6555 15.7132 18.6555 15.1086 18.5793 14.9834C18.5085 14.8472 18.307 14.771 18.0074 14.6239Z"/>
                                        </svg>
                                    </a>
                                </div>
                            <?php endif; ?>
                        </div>
                        <?php if (!empty($filial['script_mapa'])): ?>
                            <div class="content-maps">
                                <?= html_entity_decode($filial['script_mapa']); ?>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        <?else :?>
            <div class="contact-single">
                <?$filial['display_title'] = $display_title;?>
                <?set_query_var( 'filial', $filial );?>
                <?php get_template_part('template-parts/contato/session', 'box-contato', $filial); ?>
            </div>
        <?endif?>
    <?php endforeach;?>
<?php endif ?>

<!-- from cdn -->
<script src="https://unpkg.com/@material-tailwind/html@latest/scripts/collapse.js"></script>

<script>
    var lineAccordion = document.querySelectorAll(".line-accordion");
    var contentContact = document.querySelectorAll(".content-contacts");
    var contentAccondion = document.querySelectorAll(".accordion-content");
    lineAccordion.forEach(function(accordion, i) {
        accordion.addEventListener("click", function() {
            contentContact[i].classList.toggle('abs');
            contentAccondion[i].classList.toggle('height-acc');
        });
    });
    

</script>