const defaultTheme = require('tailwindcss/defaultTheme')

/** @type {import('tailwindcss').Config} */
module.exports = {
  darkMode: 'class',
  content: [
    "./*.{php,html,js}", 
    "./template-parts/*.{php,html,js}", 
    "./template-parts/estoque/*.{php,html,js}",
    "./template-parts/geral/*.{php,html,js}",
    "./template-parts/home/*.{php,html,js}",
    "./template-parts/contato/*.{php,html,js}",
    "./template-parts/veiculos/*.{php,html,js}",
    "./inc/widgets/alt_filtro/*.{php,html,js}"
  ],
  theme: {
    extend: {
      colors: {
        'black-opaque': '#000000bf', // Nome personalizado para a cor
      },
      fontFamily: { 
        Lato: ["Lato", "sans-serif"], 
        Unica: ["Unica One", "sans-serif"],
        Brush: ["Alex Brush", "sans-serif"],
      },
      backgroundImage: {
        'contact': "url('./../images/contact-img.png')",
        'agenda': "url('./../images/agenda-img.jpeg')",
        'galeria': "url('./../images/galeria.png')",
        'custom-gradient': 'linear-gradient(180deg, rgb(244 244 244) 0%, rgba(255, 255, 255, 1) 80%)',
      },
      keyframes: {
        'popup-slide-in': {
          '0%': { transform: 'translateY(20px)', opacity: '0' },
          '100%': { transform: 'translateY(0)', opacity: '1' },
        },
      },
      animation: {
        'popup-slide-in': 'popup-slide-in 0.6s ease-out',
      },
      boxShadow: {
        'popup': '0 10px 30px rgba(0, 0, 0, 0.3)',
        'sombra-header': '-10px -1px 7px #fff',  
      },
    },
    screens: {
      'mobile': '390px', //tamanho padronizado
      'tablet': '768px', //tamanho padronizado
      'desktop': '1366px', //tamanho padronizado
      'ultrawide': '1920px', //tamanho padronizado
    },
    
  },
  plugins: [],
}

