<?php

/**
 * Template Name: Politica de privacidade
 *
 * @package Altimus
 * @subpackage altimus
 * @since Altimus
 */

$titulo_site = get_bloginfo('name');
$filiais = alt_get_filiais();
get_header()
?>

<style>
.titulo_privacidade {
    margin: 20px;
}


.infos-privacidade {
    font-size: 23px !important;
    font-weight: 800 !important;
    margin-top: 3rem;
}

.content-privacidade p {
    font-size: 18px;
    font-weight: 500;
}

.lista_dados {
    list-style: none;
}

.lista_dados ul {
    font-size: 18px;
    font-weight: 600;
}

.lista_contatos {
    list-style: none;
}

.lista_contatos ul a {
    font-size: 18px;
    font-weight: 600;
}
</style>

<div class="container p-4">
    <div class="content-privacidade">

        <h1 class="titulo_privacidade text-center ">Política de Privacidade</h1>

        <p>
            Na <?= $titulo_site ?>, privacidade e segurança são prioridades e nos comprometemos com a
            transparência
            do
            tratamento de dados
            pessoais dos nossos usuários/clientes. Por isso, esta presente Política de Privacidade estabelece como é
            feita a
            coleta, uso e transferência de informações de clientes ou outras pessoas que acessam ou usam nosso site.
        </p>

        <p>
            Ao utilizar nossos serviços, você entende que coletaremos e usaremos suas informações pessoais nas formas
            descritas
            nesta Política, sob as normas da Constituição Federal de 1988 (art. 5º, LXXIX; e o art. 22º, XXX – incluídos
            pela EC
            115/2022), das normas de Proteção de Dados (LGPD, Lei Federal 13.709/2018), das disposições consumeristas da
            Lei
            Federal 8078/1990 e as demais normas do ordenamento jurídico brasileiro aplicáveis.
        </p>

        <p>
            Dessa forma, a <?= $titulo_site ?>, no papel de Controladora de Dados, obriga-se ao disposto na
            presente
            Política de Privacidade.
        </p>

        <p class="infos-privacidade">
            1. Quais dados coletamos sobre você e para qual finalidade?
        </p>
        <p>
            Nosso site coleta e utiliza alguns dados pessoais seus, de forma a viabilizar a prestação de serviços e
            aprimorar a
            experiência de uso.
        </p>

        <p class="infos-privacidade">
            1.1. Dados pessoais fornecidos pelo titular
        </p>
        <li class="lista_dados">

            <ul> Nome do cliente</ul>
            <ul> Telefone do cliente</ul>
            <ul> E-mail do cliente</ul>
        </li>
        <p class="infos-privacidade">
            1.2. Dados pessoais coletados automaticamente (Google Analytics e Facebook Ads)
        </p>

        <li class="lista_dados">

            <ul> Localização - Uso em campanhas de remarketing</ul>
            <ul> Tipo de dispositivo - Verificação de métricas</ul>
            <ul> Faixa etária - Uso em campanhas de remarketing</ul>
            <ul> Sexo - Uso em campanhas de remarketing </ul>
        </li>

        <p class="infos-privacidade">
            2. Como coletamos os seus dados?</p>
        <p>
            Nesse sentido, a coleta dos seus dados pessoais ocorre da seguinte forma:
        </p>
        <li class="lista_dados">
            <ul>Formulários de contato</ul>
            <ul>Google Analytics (<a href="https://policies.google.com/privacy?hl=pt-BR#infocollect"
                    target="blank">Política de
                    privacidade</a>)</ul>
            <ul> Facebook Ads (<a href="https://www.facebook.com/privacy/policy" target="blank">Política de
                    privacidade</a>) </ul>

        </li>

        <p class="infos-privacidade">
            2.1. Consentimento
        </p>

        <p>
            É a partir do seu consentimento que tratamos os seus dados pessoais. O consentimento é a manifestação livre,
            informada e inequívoca pela qual você autoriza a <?= $titulo_site ?> a tratar seus dados.
        </p>
        <p>
            Assim, em consonância com a Lei Geral de Proteção de Dados, seus dados só serão coletados, tratados e
            armazenados
            mediante prévio e expresso consentimento.
        </p>

        <p>
            Ao utilizar os serviços da <?= $titulo_site?> e fornecer seus dados pessoais, você está ciente
            e
            consentindo com as disposições desta Política de Privacidade, além de conhecer seus direitos e como
            exercê-los.
        </p>
        <p>
            A qualquer tempo e sem nenhum custo, você poderá revogar seu consentimento.
        </p>
        <p>
            É importante destacar que a revogação do consentimento para o tratamento dos dados pode implicar a
            impossibilidade
            da performance adequada de alguma funcionalidade do site que dependa da operação. Tais consequências serão
            informadas previamente.
        </p>

        <p class="infos-privacidade">
            3. Quais são os seus direitos?
        </p>
        <p>
            A <?=$titulo_site?> assegura a seus usuários/clientes seus direitos de titular previstos no
            artigo
            18
            da Lei Geral de Proteção de Dados. Dessa forma, você pode, de maneira gratuita e a qualquer tempo:
        </p>

        <p>
            Confirmar a existência de tratamento de dados, de maneira simplificada ou em formato claro e completo.
            Acessar seus dados, podendo solicitá-los em uma cópia legível sob forma impressa ou por meio eletrônico,
            seguro
            e
            idôneo.
            Corrigir seus dados, ao solicitar a edição, correção ou atualização destes.
            Limitar seus dados quando desnecessários, excessivos ou tratados em desconformidade com a legislação através
            da
            anonimização, bloqueio ou eliminação.
            Solicitar a portabilidade de seus dados, através de um relatório de dados cadastrais que a (nome empresarial
            simplificado) trata a seu respeito.
            Eliminar seus dados tratados a partir de seu consentimento, exceto nos casos previstos em lei.
            Revogar seu consentimento, desautorizando o tratamento de seus dados.
            Informar-se sobre a possibilidade de não fornecer seu consentimento e sobre as consequências da negativa.
        </p>
        <p class="infos-privacidade">
            4. Como você pode exercer seus direitos de titular?
        </p>

        <p>
            Para exercer seus direitos de titular, você deve entrar em contato com a <?= $titulo_site?>
            através
            dos
            seguintes meios disponíveis:</p>

        <li class="lista_contatos">

            <ul> <a href=<?= $filiais[0]['url_email'] ?> target="blank"> <?= $filiais[0]['email_principal'] ?></a> </ul>
            <ul> <a href=<?= $filiais[0]['url_whatsapp'] ?> target="blank"> <?= $filiais[0]['numero_whatsapp'] ?> </a>
            </ul>

        </li>

        <p>
            De forma a garantir a sua correta identificação como titular dos dados pessoais objeto da solicitação, é
            possível
            que solicitemos documentos ou demais comprovações que possam comprovar sua identidade. Nessa hipótese, você
            será
            informado previamente.
        </p>

        <p class="infos-privacidade">
            5. Como e por quanto tempo seus dados serão armazenados?
        </p>
        <p>
            Seus dados pessoais coletados pela  <?= $titulo_site ?>  serão utilizados e armazenados durante o
            tempo
            necessário para a prestação do serviço ou para que as finalidades elencadas na presente Política de
            Privacidade
            sejam atingidas, considerando os direitos dos titulares dos dados e dos controladores.
        </p>
        <p>
            De modo geral, seus dados não ficam armazenados no nosso site, eles são enviados para nós por e-mail ou
            através do sistema de CRM. Findado o período de armazenamento dos dados pessoais, estes serão excluídos de
            nossas
            bases
            de dados ou anonimizados, ressalvadas as hipóteses legalmente previstas no artigo 16 lei geral de proteção
            de
            dados,
            a saber:
        </p>

        <li class="lista_dados">
            <ul>
                I – cumprimento de obrigação legal ou regulatória pelo controlador;
            </ul>
            <ul>
                II – transferência a terceiro, desde que respeitados os requisitos de tratamento de dados dispostos
                nesta Lei;
            </ul>

            <ul>
                III – uso exclusivo do controlador, vedado seu acesso por terceiro, e desde que anonimizados os dados.
            </ul>
        </li>
        <p>
            Isto é, informações pessoais sobre você que sejam imprescindíveis para o cumprimento de determinações
            legais,
            judiciais e administrativas e/ou para o exercício do direito de defesa em processos judiciais e
            administrativos
            serão mantidas, a despeito da exclusão dos demais dados.
        </p>
        <p>
            O armazenamento de dados coletados pela <?= $titulo_site ?> reflete o nosso compromisso com a
            segurança
            e privacidade dos seus dados. Empregamos medidas e soluções técnicas de proteção aptas a garantir a
            confidencialidade, integridade e inviolabilidade dos seus dados. Além disso, também contamos com medidas de
            segurança apropriadas aos riscos e com controle de acesso às informações armazenadas.
        </p>

        <p class="infos-privacidade">
            6. O que fazemos para manter seus dados seguros?
        </p>
        <p>
            Para mantermos suas informações pessoais seguras, usamos ferramentas físicas, eletrônicas e gerenciais
            orientadas
            para a proteção da sua privacidade.
        </p>

        <p>
            Aplicamos essas ferramentas levando em consideração a natureza dos dados pessoais coletados, o contexto e a
            finalidade do tratamento e os riscos que eventuais violações gerariam para os direitos e liberdades do
            titular
            dos
            dados coletados e tratados.
        </p>
        <p>
            Entre as medidas que adotamos, destacamos as seguintes:
        </p>
        <p>
            Apenas pessoas autorizadas têm acesso a seus dados pessoais
            O acesso a seus dados pessoais é feito somente após o compromisso de confidencialidade
            Seus dados pessoais são armazenados em ambiente seguro e idôneo.
            A <?= $titulo_site ?> se compromete a adotar as melhores posturas para evitar incidentes de
            segurança.
            Contudo, é necessário destacar que nenhuma página virtual é inteiramente segura e livre de riscos. É
            possível
            que,
            apesar de todos os nossos protocolos de segurança, problemas de culpa exclusivamente de terceiros ocorram,
            como
            ataques cibernéticos de hackers, ou também em decorrência da negligência ou imprudência do próprio
            usuário/cliente.
        </p>

        <p>
            Em caso de incidentes de segurança que possa gerar risco ou dano relevante para você ou qualquer um de
            nossos
            usuários/clientes, comunicaremos aos afetados e a Autoridade Nacional de Proteção de Dados sobre o ocorrido,
            em
            consonância com as disposições da Lei Geral de Proteção de Dados.
        </p>
        <p class="infos-privacidade">
            7. Com quem seus dados podem ser compartilhados?
        </p>
        <p>
            Tendo em vista a preservação de sua privacidade, a <?= $titulo_site?> não compartilhará seus
            dados
            pessoais com nenhum terceiro não autorizado.
        </p>

        <p>
            Seus dados poderão ser compartilhados com nossos parceiros comerciais, estes recebem seus dados apenas na
            medida do necessário para a prestação dos serviços contratados e nossos
            contratos
            são orientados pelas normas de proteção de dados do ordenamento jurídico brasileiro.
        </p>
        <p>
            Além disso, também existem outras hipóteses em que seus dados poderão ser compartilhados, que são:
        </p>
        <li class="lista_dados">
            <ul>I – Determinação legal, requerimento, requisição ou ordem judicial, com autoridades judiciais,
                administrativas
                ou
                governamentais competentes.</ul>
            <ul>II – Caso de movimentações societárias, como fusão, aquisição e incorporação, de forma automática</ul>
            <ul>III – Proteção dos direitos da <?= $titulo_site ?> em qualquer tipo de conflito, inclusive
                os de
                teor
                judicial.</ul>

        </li>


        <p class="infos-privacidade">
            7.1. Transferência internacional de dados
        </p>
        <p>
            Alguns dos terceiros com quem compartilhamos seus dados podem ser localizados ou ou possuir instalações
            localizadas
            em países estrangeiros. Nessas condições, de toda forma, seus dados pessoais estarão sujeitos à Lei Geral de
            Proteção de Dados e às demais legislações brasileiras de proteção de dados
        </p>
        <p>
            Nesse sentido, a <?= $titulo_site?> se compromete a sempre adotar eficientes padrões de
            segurança
            cibernética e de proteção de dados, nos melhores esforços de garantir e cumprir as exigências legislativas.
        </p>
        <p>
            Ao concordar com essa Política de Privacidade, você concorda com esse compartilhamento, que se dará conforme
            as
            finalidades descritas no presente instrumento.
        </p>
        <p class="infos-privacidade">
            8. Cookies ou dados de navegação
        </p>

        <p>
            A <?= $titulo_site?> faz uso de Cookies, que são arquivos de texto enviados pela plataforma ao
            seu
            computador e que nele se armazenam, que contém informações relacionadas à navegação do site. Em suma, os
            Cookies
            são
            utilizados para aprimorar a experiência de uso.
        </p>
        <p>
            Ao acessar nosso site e consentir com o uso de Cookies, você manifesta conhecer e aceitar a utilização de um
            sistema
            de coleta de dados de navegação com o uso de Cookies em seu dispositivo.
        </p>

        <p>
            Para gerenciar os cookies do seu navegador, basta fazê-lo diretamente nas configurações do navegador, na
            área de
            gestão de Cookies. Você pode acessar tutoriais sobre o tema diretamente nos links abaixo:
        </p>

        <li class="lista_dados">
            <ul>Se você usa o <a
                    href="https://support.microsoft.com/pt-br/windows/excluir-e-gerenciar-cookies-168dab11-0753-043d-7c16-ede5947fc64d">
                    Internet Explorer.</a></ul>
            <ul>Se você usa o <a
                    href="https://support.mozilla.org/pt-BR/kb/limpe-cookies-e-dados-de-sites-no-firefox">Firefox.</a>
            </ul>
            <ul>Se você usa o <a href="https://support.apple.com/pt-br/HT201265"> Safari.</a></ul>
            <ul>Se você usa o <a
                    href="https://support.google.com/chrome/answer/95647?hl=pt-BR&co=GENIE.Platform%3DDesktop"> Google
                    Chrome.</a></ul>
            <ul>Se você usa o <a
                    href="https://support.microsoft.com/pt-br/microsoft-edge/excluir-cookies-no-microsoft-edge-63947406-40ac-c3b8-57b9-2a946a29ae09">
                    Microsoft Edge.</a></ul>
            <ul>Se você usa o <a
                    href="https://blogs.opera.com/brazil/2016/05/como-deletar-o-historico-de-navegacao-em-celulares-e-computadores/">
                    Opera.</a></ul>
        </li>


        <p class="infos-privacidade">
            9. Alteração desta Política de Privacidade
        </p>
        <p>
            A atual versão da Política de Privacidade foi formulada e atualizada pela última vez em: 25/05/2023.

            Reservamos o direito de modificar essa Política de Privacidade a qualquer tempo, principalmente em função da
            adequação a eventuais alterações feitas em nosso site ou em âmbito legislativo. Recomendamos que você a
            revise
            com
            frequência.
        </p>

        <p>
            Eventuais alterações entrarão em vigor a partir de sua publicação em nosso site e sempre lhe notificaremos
            acerca
            das mudanças ocorridas.

            Ao utilizar nossos serviços e fornecer seus dados pessoais após tais modificações, você as consente.
        </p>
        <p class="infos-privacidade">
            10. Responsabilidade
        </p>
        <p>
            A <?= $titulo_site?> prevê a responsabilidade dos agentes que atuam nos processos de tratamento
            de
            dados, em conformidade com os artigos 42 ao 45 da Lei Geral de Proteção de Dados.
        </p>
        <p>
            Nos comprometemos em manter esta Política de Privacidade atualizada, observando suas disposições e zelando
            por
            seu
            cumprimento.
        </p>
        <p>
            Além disso, também assumimos o compromisso de buscar condições técnicas e organizativas seguramente aptas a
            proteger
            todo o processo de tratamento de dados.
        </p>
        <p>
            Caso a Autoridade Nacional de Proteção de Dados exija a adoção de providências em relação ao tratamento de
            dados
            realizado pela <?= $titulo_site?>, comprometemo-nos a segui-las.
        </p>

        <p class="infos-privacidade">10.1 Isenção de responsabilidade </p>
        <p>
            Conforme mencionado no Tópico 6, embora adotemos elevados padrões de segurança a fim de evitar incidentes,
            não
            há
            nenhuma página virtual inteiramente livre de riscos. Nesse sentido, a <?= $titulo_site?> não se
            responsabiliza por:
        </p>

        <li class="lista_dados">
            <ul>
                I – Quaisquer consequências decorrentes da negligência, imprudência ou imperícia dos usuários em relação
                a seus
                dados individuais. Garantimos e nos responsabilizamos apenas pela segurança dos processos de tratamento
                de dados
                e
                do cumprimento das finalidades descritas no presente instrumento.

                Destacamos que a responsabilidade em relação à confidencialidade dos dados de acesso é do usuário.
            </ul>

            <ul>
                II – Ações maliciosas de terceiros, como ataques de hackers, exceto se comprovada conduta culposa ou
                deliberada
                da
                <?= $titulo_site?>.

                Destacamos que em caso de incidentes de segurança que possam gerar risco ou dano relevante para você ou
                qualquer
                um
                de nossos usuários/clientes, comunicaremos aos afetados e a Autoridade Nacional de Proteção de Dados
                sobre o
                ocorrido e cumpriremos as providências necessárias.
            </ul>

            <ul>
                III – Inveracidade das informações inseridas pelo usuário/cliente nos registros necessários para a
                utilização
                dos
                serviços da <?= $titulo_site?>; quaisquer consequências decorrentes de informações falsas
                ou
                inseridas
                de má-fé são de inteiramente responsabilidade do usuário/cliente.
            </ul>

        </li>

        <p class="infos-privacidade">11. Encarregado de Proteção de Dados</p>

        <p>
            A <?= $titulo_site?> disponibiliza os seguintes meios para que você possa entrar em contato
            conosco
            para exercer seus direitos de titular: <a href=<?= $filiais[0]['url_email'] ?> target="blank">
                <?= $filiais[0]['email_principal'] ?></a> .
        </p>
    </div>
</div>

<?= get_footer()?>