<?php

/**
 * Template Name: Parceria
 *
 * @package altimus
 * @subpackage altimus
 * @since Altimus
 */

wp_reset_postdata(); // Assegurar que a query principal está resetada
get_header();
$parcerias = alt_get_parcerias();
$page_url = 'http://altimus-portal.local/veiculos/chevrolet-zafira-collection-2-0-flexpower-8v-aut-azul-2019-2019/';
$post = alt_get_post_by_guid($page_url);
$user = get_userdata($post->post_author);
// Debug: Verifique se $parcerias está definido corretamente
if (empty($parcerias)) {
    echo '<p>Nenhuma parceria encontrada.</p>';
} else {
?>

<div class="page_parceria">
    <div class="parceria_titulo">
        <h1>Parcerias</h1>
    </div>
    <div class="parceria_conteudo">
        <?php foreach ($parcerias as $parceria) : ?>
            <div class="content-parceria">
                <div class="img-parceria">
                    <?php if ($parceria->imagem) : ?>
                        <?php 
                            $site_url = get_site_url();
                            $img = esc_url($parceria->imagem); 

                            $site_url = str_replace(['http://', 'https://'], '', $site_url);
                            $img = str_replace(['http://', 'https://'], '', $img);

                            $src_relativo = str_replace($site_url, '', $img);
                        ?>
                    <a href="<?= esc_url($parceria->link); ?>" target="_blank">
                        <img class="max-w-24 max-h-24 aspect-square object-contain" src="<?= $src_relativo; ?>" alt="<?= esc_attr($parceria->title); ?>" onerror="this.style.display='none'"/>
                    </a>
                    <?php endif; ?>
                </div>
                <div class="text-parceria ">
                    <?= esc_html($parceria->descricao); ?>
                </div>
            </div>
        <?php endforeach; ?>
    </div>
</div>

<?php 
} // Fechando o bloco do debug
get_footer(); 
?>
