<?php
/**
 * Template Name: Loja
 *
 * @package altimus
 * @subpackage altimus
 * @since Altimus
 */

wp_reset_postdata();
get_header();
$paged = (get_query_var('paged')) ? get_query_var('paged') : 1;
$lojas_inativas_ids = alt_get_usuarios_lojas_inativas() ?? [];
query_posts(array(
    'post_type' => 'lojas',
    'post_status' => array('publish'),
    'orderBy' => 'date',
    'order' => 'asc',
    'posts_per_page' => 15,
    'paged' => $paged,
    'author__not_in' => $lojas_inativas_ids,
));
?>

<div class="page_parceria">
    <?php
    if (have_posts()) {
        echo '<div class="lista_loja">';
            while (have_posts()) {
                the_post();
                alt_set_post_view();
                get_template_part('template-parts/geral/session-loja');
            }
        echo '</div><div class="pagination_loja">';
        // Exibe a paginação
        the_posts_pagination(array(
            'mid_size'  => 1,
            'prev_text' => __('« Anterior', 'textdomain'),
            'next_text' => __('Próximo »', 'textdomain'),
        ));
        echo '</div>';
        wp_reset_postdata(); // Reseta os dados do post global
    } else {
        echo 'Nenhuma loja encontrada.';
    }
    ?>
</div>

<?php get_footer(); ?>