<?

/**
 * Template Name: Home
 *
 * @package altimus
 * @subpackage altimus
 * @since Altimus
 */
global $post;

$box['filiais'] = alt_get_filiais();
$box['single'] = true;
$dados = get_option('alt_group_setup');
set_query_var('box', $box);

$tipoVeiculo = alt_get_tipo_veiculo();
if ($tipoVeiculo === 'altimuscarro' || isset($tipoVeiculo)) {
    $argFiltro['title'] = 'Encontre seu Novo Carro!';
}
if ($tipoVeiculo === 'altimusmoto') {
    $argFiltro['title'] = 'Encontre sua Nova Moto!';
}
if ($tipoVeiculo === 'altimuscaminhao') {
    $argFiltro['title'] = 'Encontre seu Novo Caminhão!';
}
if ($tipoVeiculo === 'altimusbarco') {
    $argFiltro['title'] = 'Encontre seu Novo Barco!';
}
if ($tipoVeiculo === 'altimusaviao') {
    $argFiltro['title'] = 'Encontre seu Novo Avião!';
}
if ($tipoVeiculo === 'altimustrator') {
    $argFiltro['title'] = 'Encontre sua Nova Máquina!';
}

get_header();
?>
<!--banner-->
<div id="banners" class="banner_home">
    <?php get_template_part('template-parts/home/session', 'slides'); ?>
</div>
<?php if (is_active_sidebar('alt_home_filtro')) : ?>
    <? dynamic_sidebar('alt_home_filtro'); ?>
<?php elseif (alt_get_portal_exibir_estoque()) : ?>
    <!--filtros-->
    <?php get_template_part('template-parts/home/session', 'filtro', $argFiltro['title']); ?>
<?php endif ?>
<?php if (alt_get_portal_exibir_estoque()) : ?>
    <div class="home-group-btn">
        <div class="home-group-content">
            <div class="w-full">
                <a href="/estoque" class="btn btn-color">Acessar estoque</a>
            </div>
            <div class="w-full">
                <a href="/venda" class="btn btn-border">Quero vender</a>
            </div>
        </div>
    </div>
    <!--categoria-veiculos-->
    <?php if (alt_get_mostrar_carroceria()) : ?>
        <div class="categoria_veiculos container">
            <?php get_template_part('template-parts/home/session', 'categorias'); ?>
        </div>
    <?php endif ?>
<?php endif ?>
<main class="dark:bg-black">
    <div class="medias-horizontal">
        <?php get_template_part('template-parts/home/session-medias', 'box'); ?>
    </div>
    <!--veiculos-destaque-->
    <?php get_template_part('template-parts/home/session', 'veiculos-destaque'); ?>

    <div class="w-full flex flex-col justify-center">
        <?php if (is_active_sidebar('alt_home1')) : ?>
            <? dynamic_sidebar('alt_home1'); ?>
        <?php else : ?>
            <div class="venda_simulacao container">
                <!--veiculos-venda-->
                <?php get_template_part('template-parts/home/session', 'veiculos-venda', $box); ?>
                <!--veiculos-simulacao-->
                <?php get_template_part('template-parts/home/session', 'veiculos-simulacao', $box); ?>
            </div>
        <?php endif; ?>
    </div>

    <?php if (is_active_sidebar('alt_home2')) : ?>
        <? dynamic_sidebar('alt_home2'); ?>
    <?php else : ?>
        <?php get_template_part('template-parts/contato/session', 'redes'); ?>
    <?php endif; ?>
    <?php if (is_active_sidebar('alt_divulgacao')) : ?>
        <? dynamic_sidebar('alt_divulgacao'); ?>
    <?php endif; ?>
    <?php the_content(); ?>
    <?php if (is_active_sidebar('alt_home3')) : ?>
        <? dynamic_sidebar('alt_home3'); ?>
    <?php else : ?>
        <?php get_template_part('template-parts/contato/session', 'box', $box); ?>
    <?php endif; ?>

</main>

<? get_footer(); ?>