<?
/**
 * Template Name: Estoque
 *
 * @package altimus
 * @subpackage altimus
 * @since Altimus
 */
global $post;

$limit = $_REQUEST['total'] ?? get_total_veiculo_no_estoque();
$arrResult = alt_lista_veiculos($limit);

$args['paginacao'] = $arrResult['paginacao'];
$args['veiculos'] = $arrResult['veiculos'] ?? [];

$marca = isset($_GET['marca']) ? $arrResult['veiculos'][0]['marca'] : '';
$modelo = isset($_GET['modelo']) ? $arrResult['veiculos'][0]['modelo'] : '';
$carroceria = isset($_GET['carroceria']) ? $arrResult['veiculos'][0]['carroceria'] : '';

$args['marca'] = $marca;
$args['modelo'] = $modelo;
$args['carroceria'] = $carroceria;

$argFiltro['title'] = 'Filtrar veículos';
set_query_var( 'argFiltro', $argFiltro);
?>

<? get_header(); ?>

<?php get_template_part('template-parts/home/session', 'filtro', $argFiltro); ?>
<?php get_template_part('template-parts/estoque/session', 'order', $args); ?>
<?php get_template_part('template-parts/estoque/session', 'paginacao', $args); ?>

<div class="<?= is_active_sidebar('alt_sitebar_estoque') ? "estoque-filtro-loja" : "" ?>">
<?php if (is_active_sidebar('alt_sitebar_estoque')) : ?>
    <?dynamic_sidebar('alt_sitebar_estoque');?>
<?php endif; ?>
<?if(alt_view_car() == 'lista' && !wp_is_mobile()) :?>
    <?php get_template_part('template-parts/estoque/session', 'list', $args); ?>    
<?else :?>
    <div class="estoque-box">
        <?php get_template_part('template-parts/estoque/session', 'box', $args); ?>
    </div>
<?endif?>
</div>

<?php get_template_part('template-parts/estoque/session', 'paginacao', $args); ?>

<script>
    jQuery("#filter-order").val("<?=$_GET['orderby'] ?? get_ordenacao_padrao();?>").change();    
</script>
    
<? get_footer();?>