<?

/**
 * Template Name: Empresa
 *
 * @package altimus
 * @subpackage altimus
 * @since Altimus
 */
global $post;

$filiais = alt_get_filiais_matriz();
$loja = reset($filiais);

$box['filiais'] = alt_get_filiais();
$box['single'] = false;
$box['display_map'] = false;
$box['display_title'] = false;
set_query_var('box', $box);
$content = count($box['filiais']) > 1 ? 'filiais' : 'filial';
?>

<? get_header(); ?>

<div class="content-empresa overflow-hidden">
    <div class="box-empresa">
        <div class="box-empresa-container container px-6">
            <div class="box-empresa-hero">                
                <div class="block max-w-[700px] m-auto w-full flex flex-col tablet:w-[85%] relative">
                    <?if (!empty($loja["youtube_empresa"])) :?>
                        <h2 class="titulo-personalizado-empresa titulo-video"><?=$loja["titulo_empresa"]?></h2>
                        <div class="aspect-video tablet:w-[100%] shadow-[0_0_10px_rgba(0,0,0,0.25)] relative bottom-[-40px] tablet:bottom-[-100px]">
                            <iframe width="100%" height="100%" src="<?=get_format_youtube($loja["youtube_empresa"])?>" title="YouTube video player" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share" allowfullscreen></iframe>
                        </div>
                    <?else :?>
                        <img id="logo-pagina-empresa" src="<?=alt_url_logo()?>" alt="logo da empresa">   
                        <h2 class="titulo-personalizado-empresa titulo-imagem"><?=$loja["titulo_empresa"]?></h2>                        
                    <?endif?>
                </div>
            </div>
            <div class="w-full m-auto pt-24 pb-6">
                <h2 class="block font-semibold text-3xl pb-4 dark:text-white">
                    Sobre a <?=$loja["nome"]?>
                </h2>
                <p class="font-normal text-base text-[--secundary_color]">
                <?=$loja["texto_empresa"]?>
                </p>
            </div>
        </div>
    </div>
    <div class="box-content">
        <div class="box-content-container container">
            <div class="container-cards">
                <div class="w-full flex justify-center tablet:justify-start pt-6">
                    <span class="text-3xl font-semibold text-[--secundary_color]">Fale conosco</span>
                </div>
                <div class="empresa-content-contacts <?=$content?>">
                    <?php get_template_part('template-parts/contato/session', 'box', $box); ?>
                </div>
            </div>
            <div class="container-img-veiculo">
                <div class="bg-[--primary_color] h-64 tablet:h-48 pt-0 w-full max-sm:h-32 tablet:h-38 desktop:h-48 max-xl-40 shadow shadow-black"></div>
                <img class="img-carro-empresa" src="<?=alt_get_img_car()?>" alt="imagem de carro na page empresa" >
            </div>
        </div>
    </div>
</div>

<? get_footer(); ?>