<?php get_header(); ?>
<div class="page-index">
    <section class="page-header listing_page">
        <div class="page_heading">
            <h1><?=str_replace('» ', '', wp_title('', false));?></h1>
        </div>
        <div class="dark-overlay"></div>    
    <section class="our_blog">
        <?php if (is_active_sidebar('alt_blog_left')) : ?>
            <div class="widget_index_left">
                <?php
                    dynamic_sidebar('alt_blog_left');
                ?>
            </div>
        <?php endif; ?>
        <div class="list_posts">
            <?php
            // Se houver algum post
            if (have_posts()): ?>
                <div class="list-articles">
                    <?php
                    // Enquanto houver posts, mostre-os pra gente
                    while (have_posts()): the_post();
                        ?>
                        <?php get_template_part('template-parts/posts/content', 'default'); ?>
                    <?php endwhile; ?>                
                </div>
                <!-- Slides Mobile -->
                <?php
                    $list_blog = $wp_query->posts;
                    $list_blog = array_column($list_blog, 'ID');
                ?>
                <div class="noticia-card-slide">
                    <div class="noticia-slide-prev" id="noticia-slide-prev">
                        <svg width="12" height="23" viewBox="0 0 12 23" xmlns="http://www.w3.org/2000/svg">
                            <path d="M0.439453 10.6601C-0.146484 11.2737 -0.146484 12.2703 0.439453 12.8839L9.43945 22.3093C10.0254 22.9229 10.977 22.9229 11.5629 22.3093C12.1488 21.6957 12.1488 20.6991 11.5629 20.0855L3.62227 11.7695L11.5582 3.45357C12.1441 2.83993 12.1441 1.84339 11.5582 1.22976C10.9723 0.616123 10.0207 0.616123 9.43476 1.22976L0.434766 10.6552L0.439453 10.6601Z"/>
                        </svg>
                    </div>
                    <div class="noticia-slide-itens">
                        <?foreach ($list_blog as $key => $id): ?>
                            <div class="noticia-slide-item <?= $key > 0 ? 'active' : '' ?>" id="box-noticia-<?=$id?>">
                                <p><?= $key+1 . ' / ' . count($list_blog) ?></p>
                                <input type="hidden" id="<?=$id?>-<?=$key?>" value="<?=$id?>">
                            </div>
                        <?endforeach ?>
                        <input type="hidden" id="list-car" value="<?var_dump(array_values($list_blog))?>">
                    </div>
                    <div class="noticia-slide-next" id="noticia-slide-next">
                        <svg width="13" height="23" viewBox="0 0 13 23" xmlns="http://www.w3.org/2000/svg">
                            <path d="M12.123 12.879C12.709 12.2653 12.709 11.2688 12.123 10.6552L3.12305 1.22976C2.53711 0.616123 1.58555 0.616123 0.99961 1.22976C0.413672 1.84339 0.413672 2.83993 0.99961 3.45357L8.94023 11.7695L1.0043 20.0855C0.41836 20.6991 0.41836 21.6957 1.0043 22.3093C1.59023 22.9229 2.5418 22.9229 3.12774 22.3093L12.1277 12.8839L12.123 12.879Z"/>
                        </svg>
                    </div>
                </div>  
                <!-- Paginação -->
                <div class="navigation_posts">
                    <div class="actions_pages_left">
                        <?php previous_posts_link('<< Mais novos') ?>
                    </div>
                    <div class="actions_pages_right">
                        <?php next_posts_link('Mais antigos >>') ?>
                    </div>
                </div>
            <?php else: ?>
                <p>There's nothing yet to be displayed...</p>
            <?php endif; 
            wp_reset_postdata();?>
        </div>
        <?php if (is_active_sidebar('alt_blog_right')) : ?>
                <div class="widget_index_right">
                    <?php
                        dynamic_sidebar('alt_blog_right');
                    ?>
                </div>
        <?php endif; ?>
    </section>
</div>
<?php get_footer(); ?>
