<?php

class alt_portal_gestores extends WP_Widget {

    function __construct() {
        parent::__construct(
            'alt_portal_gestores',  // Base ID do widget
            __('Altimus - Portal Gestores', 'text_domain'), // Nome do widget no painel
            array('description' => __('Conteúdo dos Gestores do Portal.', 'text_domain'))
        );
    }

    public function widget($args, $instance) {
        echo $args['before_widget'];
        if (!empty($instance['show_gestores'])) {
            $total = (!empty($instance['total'])) ? (int)$instance['total'] : 4;
            $formato = (!empty($instance['formato'])) ? $instance['formato'] : 'arredondado';
            $gestores = alt_get_gestores($total);
            include 'gestores-default.php';
        }
        echo $args['after_widget'];
    }

    public function form($instance) {
        $show_gestores = !empty($instance['show_gestores']) ? $instance['show_gestores'] : 'yes';
        $total = (!empty($instance['total'])) ? (int)$instance['total'] : 4;
        $formato = !empty($instance['formato']) ? $instance['formato'] : 'arredondado';
        ?>
        <p>
            <label for="<?php echo esc_attr($this->get_field_id('show_gestores')); ?>"><?php _e('Exibir Gestores?', 'text_domain'); ?></label><br>
            <input type="radio" id="<?php echo esc_attr($this->get_field_id('show_gestores_yes')); ?>" name="<?php echo esc_attr($this->get_field_name('show_gestores')); ?>" value="yes" <?php checked($show_gestores, 'yes'); ?>>
            <label for="<?php echo esc_attr($this->get_field_id('show_gestores_yes')); ?>"><?php _e('Sim', 'text_domain'); ?></label><br>
            <input type="radio" id="<?php echo esc_attr($this->get_field_id('show_gestores_no')); ?>" name="<?php echo esc_attr($this->get_field_name('show_gestores')); ?>" value="no" <?php checked($show_gestores, 'no'); ?>>
            <label for="<?php echo esc_attr($this->get_field_id('show_gestores_no')); ?>"><?php _e('Não', 'text_domain'); ?></label>
        </p>
        <p>
            <label for="<?php echo esc_attr($this->get_field_id('total')); ?>"><?php _e('Total de gestores:', 'text_domain'); ?></label>
            <input type="number" id="<?php echo esc_attr($this->get_field_id('total')); ?>" name="<?php echo esc_attr($this->get_field_name('total')); ?>" value="<?php echo esc_attr($total); ?>" />
        </p>
        <p>
            <label for="<?php echo esc_attr($this->get_field_id('formato')); ?>"><?php _e('Formato da imagem:', 'text_domain'); ?></label>
            <select id="<?php echo esc_attr($this->get_field_id('formato')); ?>" name="<?php echo esc_attr($this->get_field_name('formato')); ?>">
                <option value="normal" <?php selected($formato, 'normal'); ?>><?php _e('Normal', 'text_domain'); ?></option>
                <option value="arredondado" <?php selected($formato, 'arredondado'); ?>><?php _e('Arredondado', 'text_domain'); ?></option>
                <option value="circular" <?php selected($formato, 'circular'); ?>><?php _e('Circular', 'text_domain'); ?></option>
            </select>
        </p>
        <?php
    }

    public function update($new_instance, $old_instance) {
        $instance = array();
        $instance['show_gestores'] = (!empty($new_instance['show_gestores'])) ? sanitize_text_field($new_instance['show_gestores']) : 'no';
        $instance['total'] = (!empty($new_instance['total'])) ? (int)sanitize_text_field($new_instance['total']) : 4;
        $instance['formato'] = (!empty($new_instance['formato'])) ? sanitize_text_field($new_instance['formato']) : 'arredondado';
        return $instance;
    }
}

function register_alt_portal_gestores() {
    register_widget('alt_portal_gestores');
}
add_action('widgets_init', 'register_alt_portal_gestores');

function alt_get_gestores($total) {
    $args = wp_parse_args( array(
        'post_type' => 'gestor',
        'meta_key' => 'alt_gestor_ordem',
        'orderby' => 'meta_value_num',
        'order' => 'ASC',
        'posts_per_page' => $total,
    ));
    $query = new WP_Query($args);
    $gestores = array();
    foreach ($query->posts as $post) {

        $site_url = get_home_url();
        $url_img = get_post_meta($post->ID, 'alt_gestor_imagem', true);

        $site_url = str_replace(['http://', 'https://'], '', $site_url);
        $url_img = str_replace(['http://', 'https://'], '', $url_img);
        
        $url_relativa = str_replace($site_url, '', $url_img); 

        $gestores[] = array(
            'nome' => $post->post_title,
            'imagem' => $url_relativa,
            'cargo' => get_post_meta($post->ID, 'alt_gestor_cargo', true),
            'ordem' => get_post_meta($post->ID, 'alt_gestor_ordem', true),
        );
    }
    return $gestores;
}
