<?php

class alt_portal_foto_video extends WP_Widget {

    function __construct() {
        parent::__construct(
            'alt_portal_foto_video',  // Base ID do widget
            __('Altimus - Portal Foto e Vídeo', 'text_domain'), // Nome do widget no painel
            array('description' => __('Conteúdo do Portal de Fotos e Vídeos.', 'text_domain'))
        );
    }

    // Fun&ccedil;&atilde;o para exibir o widget no frontend
    public function widget($args, $instance) {

        echo $args['before_widget'];

        // Exibir a se&ccedil;&atilde;o "Sobre" se o campo estiver definido como 'yes'
        if (isset($instance['show_about']) && $instance['show_about'] == 'yes') {
            include 'foto_video-default.php';
        }

        echo $args['after_widget'];
    }

    // Fun&ccedil;&atilde;o para exibir o formul&aacute;rio de configura&ccedil;&atilde;o no painel de administra&ccedil;&atilde;o
    public function form($instance) {

        // Definir os campos do widget
        $show_about = isset($instance['show_about']) ? $instance['show_about'] : 'yes';

        // Exibir o formul&aacute;rio com os campos
        ?>
        <p>
        <label for="<?php echo esc_attr($this->get_field_id('show_about')); ?>"><?php _e('Exibir Sobre?', 'text_domain'); ?></label><br>
        <input type="radio" id="<?php echo esc_attr($this->get_field_id('show_about_yes')); ?>" name="<?php echo esc_attr($this->get_field_name('show_about')); ?>" value="yes" <?php checked($show_about, 'yes'); ?>>
        <label for="<?php echo esc_attr($this->get_field_id('show_about_yes')); ?>"><?php _e('Sim', 'text_domain'); ?></label><br>
        <input type="radio" id="<?php echo esc_attr($this->get_field_id('show_about_no')); ?>" name="<?php echo esc_attr($this->get_field_name('show_about')); ?>" value="no" <?php checked($show_about, 'no'); ?>>
        <label for="<?php echo esc_attr($this->get_field_id('show_about_no')); ?>"><?php _e('Não', 'text_domain'); ?></label>
        </p>
        <?php
    }

    // Fun&ccedil;&atilde;o para salvar os dados do widget
    public function update($new_instance, $old_instance) {
        $instance = array();
        $instance['show_about'] = (!empty($new_instance['show_about'])) ? sanitize_text_field($new_instance['show_about']) : 'no';

        return $instance;
    }
}

// Registra o widget
function register_alt_portal_foto_video() {
    register_widget('alt_portal_foto_video');
}
add_action('widgets_init', 'register_alt_portal_foto_video');
