<?php 
$listaLojas = alt_get_lojas();
$total_lojas = count($listaLojas) ?? 0;
?>
<div class="swiper-container-loja">
    <h1>Lojas associadas</h1>
    <span class="loading-loja">Carregando...</span>
    <div style="display: none;" class="swiper-wrapper lojas-slide <?=($total_lojas > 5 ? 'justify-start' : 'justify-center')?>" >
        <?php foreach ($listaLojas as $loja): ?>
            <div class="swiper-slide">
                <a href="/estoque/?loja=<?=alt_get_user_loja($loja->ID)->ID?>" 
                    data-toggle="tooltip" data-placement="top" title="<?= $loja->post_title ?>" >
                    <div class="loja">
                        <?
                        $imagem_loja = wp_get_attachment_image_src($loja->meta['alt_lojas_imagem_id'][0], 'medium'); 
                        $site_url = get_home_url();
                        $imagem_loja = str_replace(['http://', 'https://'], '', $imagem_loja);
                        $site_url = str_replace(['http://', 'https://'], '', $site_url);
                        $relative_url = str_replace($site_url, '', $imagem_loja);
                        ?>
                        <img src="<?= $relative_url[0]; ?>" alt="img_loja">
                    </div>
                </a>
            </div>

        <?php endforeach; ?>
    </div>
    <?if ($total_lojas == 0) :?>
        <div class="no-loja">
            <h1>Nenhuma loja encontrada</h1>
        </div>
    <?endif?>
</div>
