<?php
/**
 * Widget Alt Filtro Loja
 */
class alt_filtro_loja extends WP_Widget {

    public function __construct() {
        parent::__construct(
            'alt_filtro_loja',
            __('Altimus - Portal Filtro Loja', 'text_domain'),
            array('description' => __('Um widget para filtrar veículos por lojas', 'text_domain'))
        );
    }

    public function widget($args, $instance) {
        echo $args['before_widget'];
        
        // Exibir o widget "Filtro Loja" se o campo estiver definido como 'yes'
        if (isset($instance['show_about']) && $instance['show_about'] == 'yes') {
            $noticias = alt_portal_get_noticias($instance['quantidade']);
            
            if (isset($instance['tipo']) && $instance['tipo'] == 'slide') {
                include 'filtro-loja-slide.php';
            } else {
                include 'filtro-loja-default.php';
            }
        }

        echo $args['after_widget'];
    }

    public function form($instance) {
        $show_about = !empty($instance['show_about']) ? $instance['show_about'] : 'yes';
        $quantidade = !empty($instance['quantidade']) ? $instance['quantidade'] : 5;
        $tipo = !empty($instance['tipo']) ? $instance['tipo'] : 'default';
        ?>
        <p>
            <label for="<?php echo esc_attr($this->get_field_id('show_about')); ?>"><?php _e('Exibir Noticias?', 'text_domain'); ?></label><br>
            <input type="radio" id="<?php echo esc_attr($this->get_field_id('show_about_yes')); ?>" name="<?php echo esc_attr($this->get_field_name('show_about')); ?>" value="yes" <?php checked($show_about, 'yes'); ?>>
            <label for="<?php echo esc_attr($this->get_field_id('show_about_yes')); ?>"><?php _e('Sim', 'text_domain'); ?></label><br>
            <input type="radio" id="<?php echo esc_attr($this->get_field_id('show_about_no')); ?>" name="<?php echo esc_attr($this->get_field_name('show_about')); ?>" value="no" <?php checked($show_about, 'no'); ?>>
            <label for="<?php echo esc_attr($this->get_field_id('show_about_no')); ?>"><?php _e('Não', 'text_domain'); ?></label>
        </p>
        <p>
            <label for="<?php echo esc_attr($this->get_field_id('quantidade')); ?>"><?php _e('Quantidade de Exibição:', 'text_domain'); ?></label>
            <input class="number" id="<?php echo esc_attr($this->get_field_id('quantidade')); ?>" name="<?php echo esc_attr($this->get_field_name('quantidade')); ?>" type="number" value="<?php echo esc_attr($quantidade); ?>" min="1">
        </p>
        <p>
            <label for="<?php echo esc_attr($this->get_field_id('tipo')); ?>"><?php _e('Tipo:', 'text_domain'); ?></label>
            <select id="<?php echo esc_attr($this->get_field_id('tipo')); ?>" name="<?php echo esc_attr($this->get_field_name('tipo')); ?>">
                <option value="default" <?php selected($tipo, 'default'); ?>><?php _e('Padrão', 'text_domain'); ?></option>
                <option value="slide" <?php selected($tipo, 'slide'); ?>><?php _e('Slide', 'text_domain'); ?></option>
            </select>
        </p>
        <p style="color: #646970;"><?php _e('Obs: A quantidade não se aplica no tipo Slide.', 'text_domain'); ?></p>
        
        <?php
    }

    public function update($new_instance, $old_instance) {
        $instance = array();
        $instance['show_about'] = (!empty($new_instance['show_about'])) ? sanitize_text_field($new_instance['show_about']) : 'no';
        $instance['quantidade'] = (!empty($new_instance['quantidade'])) ? intval($new_instance['quantidade']) : 5;
        $instance['tipo'] = (!empty($new_instance['tipo'])) ? sanitize_text_field($new_instance['tipo']) : 'default';

        return $instance;
    }
}

// Registra o widget
function register_alt_filtro_loja() {
    register_widget('alt_filtro_loja');
}
add_action('widgets_init', 'register_alt_filtro_loja');

