<?php
// Verifique se a classe WP_Widget já existe para evitar redefinições.
if (!class_exists('alt_portal_contato')) {
    
    class alt_portal_contato extends WP_Widget {
        
        // Construtor do Widget
        public function __construct() {
            parent::__construct(
                'alt_portal_contato',  // Base ID do widget
                __('Altimus - Portal Contato', 'text_domain'), // Nome do widget no painel
                array('description' => __('Contéudo do Portal Contato.', 'text_domain'))
            );
        }

        // Função para exibir o widget no frontend
        public function widget($args, $instance) {
            

            echo $args['before_widget'];
            
            // Exibir a seção "Contato" se o campo estiver definido como 'yes'
            if (isset($instance['show_about']) && $instance['show_about'] == 'yes') {
                $matriz = get_info_principal(true);
                include 'contato-default.php';
            }

            echo $args['after_widget'];            
        }

        // Função para exibir o formulário de configuração no painel de administração
        public function form($instance) {
            $show_about = !empty($instance['show_about']) ? $instance['show_about'] : 'yes';
            ?>
            <p>
                <label for="<?php echo esc_attr($this->get_field_id('show_about')); ?>"><?php _e('Exibir Contato?', 'text_domain'); ?></label><br>
                <input type="radio" id="<?php echo esc_attr($this->get_field_id('show_about_yes')); ?>" name="<?php echo esc_attr($this->get_field_name('show_about')); ?>" value="yes" <?php checked($show_about, 'yes'); ?>>
                <label for="<?php echo esc_attr($this->get_field_id('show_about_yes')); ?>"><?php _e('Sim', 'text_domain'); ?></label><br>
                <input type="radio" id="<?php echo esc_attr($this->get_field_id('show_about_no')); ?>" name="<?php echo esc_attr($this->get_field_name('show_about')); ?>" value="no" <?php checked($show_about, 'no'); ?>>
                <label for="<?php echo esc_attr($this->get_field_id('show_about_no')); ?>"><?php _e('Não', 'text_domain'); ?></label>
            </p>
            <?php 
        }

        // Função para salvar os dados do widget
        public function update($new_instance, $old_instance) {
            $instance = array();
            $instance['show_about'] = (!empty($new_instance['show_about'])) ? sanitize_text_field($new_instance['show_about']) : 'no';

            return $instance;
        }
    }

    // Registra o widget
    function register_alt_portal_contato() {
        register_widget('alt_portal_contato');
    }
    add_action('widgets_init', 'register_alt_portal_contato');

}
?>
