<?php

class alt_portal_agenda extends WP_Widget {

    public function __construct() {
        parent::__construct(
            'alt_portal_agenda',  // Base ID do widget
            __('Altimus - Portal Agenda', 'text_domain'), // Nome do widget no painel
            array('description' => __('Conteúdo da Agenda do Portal.', 'text_domain'))
        );
    }

    public function widget($args, $instance) {
        echo $args['before_widget'];
        if (!empty($instance['show_agenda'])) {
            $total = (!empty($instance['total'])) ? (int)$instance['total'] : 3;
            $agenda = alt_get_agenda($total);
            include 'agenda-default.php';
        }
        echo $args['after_widget'];
    }

    public function form($instance) {
        $show_agenda = !empty($instance['show_agenda']) ? $instance['show_agenda'] : 'yes';
        $total = (!empty($instance['total'])) ? (int)$instance['total'] : 3;
        ?>
        <p>
            <label for="<?php echo esc_attr($this->get_field_id('show_agenda')); ?>"><?php _e('Exibir Agenda?', 'text_domain'); ?></label><br>
            <input type="radio" id="<?php echo esc_attr($this->get_field_id('show_agenda_yes')); ?>" name="<?php echo esc_attr($this->get_field_name('show_agenda')); ?>" value="yes" <?php checked($show_agenda, 'yes'); ?>>
            <label for="<?php echo esc_attr($this->get_field_id('show_agenda_yes')); ?>"><?php _e('Sim', 'text_domain'); ?></label><br>
            <input type="radio" id="<?php echo esc_attr($this->get_field_id('show_agenda_no')); ?>" name="<?php echo esc_attr($this->get_field_name('show_agenda')); ?>" value="no" <?php checked($show_agenda, 'no'); ?>>
            <label for="<?php echo esc_attr($this->get_field_id('show_agenda_no')); ?>"><?php _e('Não', 'text_domain'); ?></label>
        </p>
        <p>
            <label for="<?php echo esc_attr($this->get_field_id('total')); ?>"><?php _e('Total de eventos:', 'text_domain'); ?></label>
            <input type="number" id="<?php echo esc_attr($this->get_field_id('total')); ?>" name="<?php echo esc_attr($this->get_field_name('total')); ?>" value="<?php echo esc_attr($total); ?>" />
        </p>
        <?php
    }

    public function update($new_instance, $old_instance) {
        $instance = array();
        $instance['show_agenda'] = (!empty($new_instance['show_agenda'])) ? sanitize_text_field($new_instance['show_agenda']) : 'no';
        $instance['total'] = (!empty($new_instance['total'])) ? (int)sanitize_text_field($new_instance['total']) : 3;
        return $instance;
    }
}

function register_alt_portal_agenda() {
    register_widget('alt_portal_agenda');
}
add_action('widgets_init', 'register_alt_portal_agenda');


/**
 * Fun o para retornar todas as agendas do portal
 *
 * @return array
 */
function alt_get_agenda($length) {
    $args = array(
        'post_type'      => 'agenda',
        'meta_query'     => array(
            array(
                'key'     => 'alt_agenda_data', // O campo repetível
                'compare' => 'EXISTS', // Garante que o campo existe
            ),
        ),
        'posts_per_page' => -1, // Pegar todos os posts para o filtro posterior
    );

    $the_query = new WP_Query($args);
    
    $agendas = [];
    $today = date('Y-m-d'); // Data atual

    if ($the_query->have_posts()) {
        while ($the_query->have_posts()) {
            $the_query->the_post();
            
            // Recupera o array de datas
            $datas = get_post_meta(get_the_ID(), 'alt_agenda_data', true);

            if (is_array($datas)) {
                // Filtra as datas que são iguais ou posteriores à data de hoje
                $datas = array_filter($datas, function($date) use ($today) {
                    return strtotime($date) >= strtotime($today);
                });

                // Se houver datas após a filtragem, processa o restante
                if (!empty($datas)) {
                    // Ordena as datas dentro do array
                    usort($datas, function($a, $b) {
                        return strtotime($a) - strtotime($b); // Ordenação correta por timestamp completo (dia, mês, ano)
                    });

                    // Formatação das datas
                    $formatted_dates = alt_format_agenda_dates($datas);

                    $agendas[] = [
                        'id'         => get_the_ID(),
                        'title'      => get_the_title(),
                        'url'        => get_post_meta(get_the_ID(), 'alt_agenda_link', true),
                        'data'       => $formatted_dates, // Datas formatadas
                        'hora'       => get_post_meta(get_the_ID(), 'alt_agenda_hora', true),
                        'first_date' => $datas[0], // Primeira data para ordenação geral
                    ];
                }
            }
        }
    }

    wp_reset_postdata();

    // Ordena os posts pela primeira data de cada array (considerando a primeira data do campo repetível)
    usort($agendas, function($a, $b) {
        return strtotime($a['first_date']) - strtotime($b['first_date']);
    });
    // Limita os resultados a 3 eventos
    return array_slice($agendas, 0, $length);
}



function alt_format_agenda_dates($datas) {
    $months = [];
    $days = [];

    foreach ($datas as $date) {
        $timestamp = strtotime($date);
        $day = date('d', $timestamp);
        $month = date('m', $timestamp);
        
        if (!isset($months[$month])) {
            $months[$month] = [];
        }
        $months[$month][] = $day;
    }

    $formatted_dates = [];

    foreach ($months as $month => $days_array) {
        if (count($days_array) > 1) {
            // Formata múltiplos dias no mesmo mês
            $last_day = array_pop($days_array); // Último dia para 'e'
            $formatted_dates[] = implode(', ', $days_array) . ' e ' . $last_day . '/' . $month;
        } else {
            // Formata uma única data
            $formatted_dates[] = $days_array[0] . '/' . $month;
        }
    }

    return implode(', ', $formatted_dates);
}


