(function ($) {
  "use strict";
  $(function (e) {
    $("#preco_lista").slider({});
    $("#ano_lista").slider({});

    $("#price_range").change(function(){
      let number_price = $(this).val().split(",");
      let min_value_preco = number_price[0];
      let max_value_preco = number_price[1];

      $("#form_min_price").val(min_value_preco);
      $("#form_max_price").val(max_value_preco);

      $("#label_min_price_form").text(
        "R$ " + min_value_preco.split(/(?=(?:...)*$)/).join(".")
      );
      $("#label_max_price_form").text(
        "R$ " + max_value_preco.split(/(?=(?:...)*$)/).join(".")
      );
    });

    //Selecionar apenas modelos da marca
    $("#form_marca").on("change", function (v) {
      carregarModelos();
    });
    $("#form_modelo").on("change", function (v) {
      atualizarAno();
    });

    function atualizarAno() {
      let marca = $("#form_marca").val();
      let modelo = $("#form_modelo").val();

      let url_base = "/wp-admin/admin-ajax.php?action=get_modelos_rest";
      let url = url_base.concat("&marca=" + marca).concat("&modelo=" + modelo);

      //Atualizar anos
      $("#form_ano").empty();
      $("#form_ano").append(new Option("Carregando", ""));

      $.get(url, function (response) {
        $("#form_ano").append(new Option("Ano", ""));
        $.each(response.anos, function (v, t) {
          let value = v;
          let name = t;
          $("#form_ano").append(new Option(name, value));
        });
      }).done(function () {
        $("#form_ano option:contains('Carregando')").remove();
      });
    }

    /**
     * Carregar marcas
     */
    function carregarMarcas() {
      let marca = $("#form_marca").val();

      let url_base = "/wp-admin/admin-ajax.php?action=get_marcas_rest";

      $("#form_marca").empty();
      $("#form_marca").append(new Option("Carregando", ""));

      $.get(url_base, function (response) {
        $("#form_marca").append(new Option("Marca", ""));
        $.each(response.posts, function (v, t) {
          let value = t.slug;
          let name = t.name;
          $("#form_marca").append(new Option(name, value));
        });
      }).done(function () {
        $("#form_marca option:contains('Carregando')").remove();
        //$("#form_marca option[value='carregando']").remove();
      });
    }

    /**
     * Carregar modelos
     */
    function carregarModelos() {
      let marca = $("#form_marca").val();

      let url_base = "/wp-admin/admin-ajax.php?action=get_modelos_rest";
      let url = url_base.concat("&marca=" + marca);

      $("#form_modelo").empty();
      $("#form_modelo").append(new Option("Carregando", ""));

      $.get(url, function (response) {
        $("#form_modelo").append(new Option("Modelo", ""));
        $.each(response.posts, function (v, t) {
          let value = t.slug;
          let name = t.name;
          $("#form_modelo").append(new Option(name, value));
        });
      }).done(function () {
        $("#form_modelo option:contains('Carregando')").remove();
      });

      $("#form_ano").empty();
      $("#form_ano").append(new Option("Carregando", ""));

      $.get(url, function (response) {
        $("#form_ano").append(new Option("Ano", ""));
        $.each(response.anos, function (v, t) {
          let value = v;
          let name = t;
          $("#form_ano").append(new Option(name, value));
        });
      }).done(function () {
        $("#form_ano option:contains('Carregando')").remove();
      });
    }

    $("#form_busca").submit(function () {
      $("select").each(function () {
        if ($(this).val() == "") {
          $(this).attr("disabled", "disabled");
        }
      });
      $(this)
        .find("input[name]")
        .filter(function () {
          return !this.value;
        })
        .prop("name", "");
    });

    carregarMarcas();

    var btnFiltroMobile = $("#filtroMobileBtn");
    btnFiltroMobile.hide();
    $(window).scroll(function () {
      if ($(this).scrollTop() > 100) {
        btnFiltroMobile.fadeIn();
      } else {
        btnFiltroMobile.fadeOut();
      }
    });
  });
})(jQuery);

String.prototype.reverse = function () {
  return this.split("").reverse().join("");
};

function mascaraMoeda(campo, evento) {
  var tecla = !evento ? window.event.keyCode : evento.which;
  var valor = campo.value.replace(/[^\d]+/gi, "").reverse();
  var resultado = "";
  var mascara = "##.###.###".reverse();
  for (var x = 0, y = 0; x < mascara.length && y < valor.length; ) {
    if (mascara.charAt(x) != "#") {
      resultado += mascara.charAt(x);
      x++;
    } else {
      resultado += valor.charAt(y);
      y++;
      x++;
    }
  }
  campo.value = resultado.reverse();
}
