<?php
if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}

require 'ajax_query.php';

class alt_filtro extends WP_Widget
{


    function __construct()
    {
        parent::__construct(
            // Base ID of your widget
            'alt_filtro',
            // Widget name will appear in UI
            'Altimus - Filtros de veículos',
            // Widget description
            array(
                'description' => 'Filtro horizontal e vertical',
            )
        );
    }

    public function widget($args, $instance)
    {
        $url_widget = get_template_directory_uri() . '/inc/widgets/alt_filtro';
        $cdn_altimus = 'https://cdn-wordpress.altimus.com.br/wp-files/tema1';
        
        $versao = 'v1';
        wp_enqueue_style('boostrap-slider-css', $cdn_altimus . '/assets/css/bootstrap-slider.min.css', array('master-css'), $versao, 'all');
        wp_enqueue_script('bootstrap-slider-js', $cdn_altimus . '/assets/js/bootstrap-slider.min.js', array(), $versao, true);
        wp_enqueue_script('widget-filtro-horizontal', $url_widget . '/assets/js/altimus-filtro.js', '', $versao, true);
        wp_enqueue_style('widget-filtro-style', $url_widget . '/assets/css/style.css', null, $versao, 'all');

        $sn_mostrar_textual = get_show_textual_busca_home();
        $titulo = $instance['title'] ?? 'Pensando em comprar um carro novo?';
        $subtitulo = $instance['subtitle'] ?? 'Encontre aqui as melhores ofertas';

        $layout = $instance['layout'] ?? 'default';
        $sn_mostrar_textual = alt_validar_chave('busca_textual', $instance) == 'on' ? true : false;
        $sn_carroceria = alt_validar_chave('carroceria', $instance) == 'on' ? true : false;
        $sn_filial = alt_validar_chave('filial', $instance) == 'on' ? true : false;
        $sn_tipo  = alt_validar_chave('tipo', $instance) == 'on' ? true : false;
        $sn_cambio  = alt_validar_chave('cambio', $instance) == 'on' ? true : false;

        $arrVeiculos = $this->listarVeiculos();

        extract($arrVeiculos);

        if (isset($marcas)) {
            array_multisort(array_column($marcas, "name"), SORT_ASC, $marcas);
        }
        if (isset($modelos)) {
            array_multisort(array_column($modelos, "name"), SORT_ASC, $modelos);
        }

        $arrTipos = $tipos ?? [];
        $arrCarroceria = $carroceria ?? [];
        $arrFiliais = $locais ?? [];
        $arrAnoModelo = $ano ?? [];
        $arrMarcas = $marcas ?? [];
        $arrModelos = $modelos ?? [];
        $arrCambios = $cambios ?? [];
        $arrPrecos = $this->buscarPrecoMaximoEMinimo();
        
        ksort($arrCambios);
        ksort($arrAnoModelo);
        ksort($arrFiliais);

        $string = $_GET['s'] ?? null;
        $field_marca = $_GET['marca'] ?? null;
        $field_modelo = $_GET['modelo'] ?? null;
        $field_tipo = $_GET['tipo'] ?? null;
        $field_ano = $_GET['ano'] ?? null;
        $field_carroceria = $_GET['carroceria'] ?? null;
        $field_filial = $_GET['filial'] ?? null;
        $field_max_price = $_GET['max_price'] ?? $arrPrecos['maximo'];
        $field_min_price = $_GET['min_price'] ?? $arrPrecos['minimo'];

        if ($layout == 'default') {
            include 'template-default.php';
        }
    }

    public function form($instance)
    {
        $title = isset($instance['title']) ? esc_attr($instance['title']) : '';
        $subtitle = isset($instance['subtitle']) ? esc_attr($instance['subtitle']) : '';
        $busca_textual = $instance['busca_textual'] == 'on' ? true : false;
        $carroceria = $instance['carroceria'] == 'on' ? true : false;
        $filial = $instance['filial'] == 'on' ? true : false;
        $tipo = $instance['tipo'] == 'on' ? true : false;
        $cambio = $instance['cambio'] == 'on' ? true : false;
        $layout = isset($instance['layout']) ? esc_attr($instance['layout']) : 'horizontal-a';
?>

<p>
    <label for="<?php echo $this->get_field_id('layout'); ?>">Layout</label>
    <select class="widefat" id="<?php echo $this->get_field_id('layout'); ?>"
        name="<?php echo $this->get_field_name('layout'); ?>">
        <option value="default" <?= ($layout == 'default') ? 'selected' : ''; ?>>Default
        </option>
    </select>
</p>


<p>
    <label for="<?php echo $this->get_field_id('title'); ?>">Titulo principal</label>
    <input class="widefat" id="<?php echo $this->get_field_id('title'); ?>"
        name="<?php echo $this->get_field_name('title'); ?>" type="text" value="<?php echo esc_attr($title); ?>" />
</p>

<p>
    <label for="<?php echo $this->get_field_id('subtitle'); ?>">Subtitulo</label>
    <input class="widefat" id="<?php echo $this->get_field_id('subtitle'); ?>"
        name="<?php echo $this->get_field_name('subtitle'); ?>" type="text"
        value="<?php echo esc_attr($subtitle); ?>" />
</p>


<p>
    <input class="widefat" id="<?php echo $this->get_field_id('busca_textual'); ?>"
        name="<?php echo $this->get_field_name('busca_textual'); ?>" value="on" type="checkbox"
        <?= ($busca_textual == true) ? 'checked' : '' ?> />
    <label for="<?php echo $this->get_field_id('busca_textual'); ?>">Habilitar busca textual</label>
</p>


<p>
    <input class="widefat" id="<?php echo $this->get_field_id('carroceria'); ?>"
        name="<?php echo $this->get_field_name('carroceria'); ?>" value="on" type="checkbox"
        <?= ($carroceria == true) ? 'checked' : '' ?> />
    <label for="<?php echo $this->get_field_id('carroceria'); ?>">Habilitar por carroceria</label>
</p>

<p>
    <input class="widefat" id="<?php echo $this->get_field_id('filial'); ?>"
        name="<?php echo $this->get_field_name('filial'); ?>" value="on" type="checkbox"
        <?= ($filial == true) ? 'checked' : '' ?> />
    <label for="<?php echo $this->get_field_id('filial'); ?>">Habilitar filtro por filial</label>
</p>

<p>
    <input class="widefat" id="<?php echo $this->get_field_id('tipo'); ?>"
        name="<?php echo $this->get_field_name('tipo'); ?>" value="on" type="checkbox"
        <?= ($tipo == true) ? 'checked' : '' ?> />
    <label for="<?php echo $this->get_field_id('tipo'); ?>">Habilitar filtro por tipo</label>
</p>

<p>
    <input class="widefat" id="<?php echo $this->get_field_id('cambio'); ?>"
        name="<?php echo $this->get_field_name('cambio'); ?>" value="on" type="checkbox"
        <?= ($cambio == true) ? 'checked' : '' ?> />
    <label for="<?php echo $this->get_field_id('cambio'); ?>">Habilitar filtro por câmbio</label>
</p>

<?php
    }

    public function update($new_instance, $old_instance)
    {

        $instance = $old_instance;
        $instance['title'] = strip_tags($new_instance['title']);
        $instance['subtitle'] = strip_tags($new_instance['subtitle']);
        $instance['busca_textual'] = strip_tags($new_instance['busca_textual']);
        $instance['carroceria'] = strip_tags($new_instance['carroceria']);
        $instance['filial'] = strip_tags($new_instance['filial']);
        $instance['cambio'] = strip_tags($new_instance['cambio']);
        $instance['tipo'] = strip_tags($new_instance['tipo']);
        $instance['layout'] = strip_tags($new_instance['layout']);
        return $instance;
    }

    private function listarVeiculos()
    {
        $args = array(
            'post_type' => 'veiculos',
            'posts_per_page' => '-1',
            'post_status' => 'publish',

        );

        $query_filtro = new WP_Query($args);

        while ($query_filtro->have_posts()) : $query_filtro->the_post();
            $objTipos = wp_get_object_terms(get_the_ID(), 'tipo');
            foreach ($objTipos as $objTipo) {
                $tipos['id'] = $objTipo->term_id;
                $tipos['name'] = $objTipo->name;
                $tipos['slug'] = $objTipo->slug;
                $arrReturn['tipos'][] = $tipos;
            }

            $objMarcas = wp_get_object_terms(get_the_ID(), 'marca');
            foreach ($objMarcas as $objMarca) {
                $marca['id'] = $objMarca->term_id;
                $marca['name'] = $objMarca->name;
                $marca['slug'] = $objMarca->slug;
                $arrReturn['marcas'][] = $marca;
            }

            $objCarroceria = wp_get_object_terms(get_the_ID(), 'carroceria');
            foreach ($objCarroceria as $objCarroceria) {

                $carroceria['id'] = $objCarroceria->term_id;
                $carroceria['name'] = $objCarroceria->name;
                $carroceria['slug'] = $objCarroceria->slug;
                $arrReturn['carroceria'][] = $carroceria;
            }

            $objModelos = wp_get_object_terms(get_the_ID(), 'modelo');
            foreach ($objModelos as $objMarca) {
                $marca['id'] = $objMarca->term_id;
                $marca['name'] = $objMarca->name;
                $marca['slug'] = $objMarca->slug;
                $arrReturn['modelos'][] = $marca;
            }

            $local = get_post_meta(get_the_ID(), 'alt_localizacao', true) ?? null;
            $ano = get_post_meta(get_the_ID(), 'alt_ano_mod', true) ?? null;
            $cambio = get_post_meta(get_the_ID(), 'alt_cambio', true) ?? null;

            $arrReturn['locais'][$local] = $local;
            $arrReturn['ano'][$ano] = $ano;
            $arrReturn['cambios'][$cambio] = $cambio;

        endwhile;

        //Realizar a ordenação
        $arrReturn['marcas'] = $this->unique_multidim_array($arrReturn['marcas'], 'id');
        $arrReturn['tipos'] = $this->unique_multidim_array($arrReturn['tipos'], 'id');
        $arrReturn['modelos'] = $this->unique_multidim_array($arrReturn['modelos'], 'id');
        $arrReturn['carroceria'] = $this->unique_multidim_array($arrReturn['carroceria'], 'id');

        wp_reset_postdata();

        return $arrReturn;
    }

    private function buscarPrecoMaximoEMinimo()
    {
        $min_value = alt_get_min_price();
        $max_value = alt_get_max_price();

        return ['minimo' => $min_value, 'maximo' => $max_value];
    }

    private function unique_multidim_array($array, $key)
    {
        if (empty($array)) {
            return;
        }
        $temp_array = array();
        $i = 0;
        $key_array = array();

        foreach ($array as $val) {
            if (!in_array($val[$key], $key_array)) {
                $key_array[$i] = $val[$key];
                $temp_array[$i] = $val;
            }
            $i++;
        }
        return $temp_array;
    }
}