<?php
if (!function_exists('get_lista_cores_array')) {
    function get_lista_cores_array()
    {
        return [
            'altimus' => 'Altimus',
            'personalizado-altimus' => 'Altimus Personalizado',
            'orange' => 'Laranja',
            'dark' => 'Dark',
            'black' => 'Preto',
            'blue' => 'Azul',
            'red' => 'Vermelho',
            'green' => 'Verde',
            'pink' => 'Rosa',
            'purple' => 'Violeta',
            'yellow' => 'Amarelo',
            'personalizar' => 'Personalizar',
        ];
    }
}

if (!function_exists('alt_visibility_whatsapp')) {
    function alt_visibility_whatsapp($view = null)
    {
        global $wp;
        $current = home_url($wp->request);
        $page = str_replace(get_site_url(), "", $current);
        if ($page == '/estoque' || $view) {
            return "block";
        }
        return "none";
    }
}

if (!function_exists('alt_get_phone_whatsapp')) {
    function alt_get_phone_whatsapp()
    {
        $arrOptions = get_option('alt_group_setup');
        if (empty($arrOptions)) {
            return;
        }
        $nome_loja = $arrOptions['nome_seo'] ?? '';
        $text = "?text= Olá, estou no site " . $nome_loja  . " e gostaria de mais informações!";

        $filiais = alt_get_filiais();

        $phone_primary = [];
        $phone_secundary = [];
        $map_primary = [];
        $whats_primary = [];
        $whats_secundary = [];
        $phone_count = false;
        $map_count = false;
        $whats_count = false;

        foreach ($filiais as $filial) {

            if (!empty($filial["telefone"])) {
                $phone_count = true;
            }
            array_push($phone_primary, [
                $filial["nome"],
                $filial["telefone"],
                $filial["url_telefone"] ?? NULL,
            ]);

            if (!empty($filial["whatsapp"])) {
                $whats_count = true;
            }
            array_push($whats_primary, [
                $filial["nome"],
                $filial["whatsapp"],
                $filial["url_whatsapp"] ?? NULL . $text
            ]);

            if (!empty($filial["url_mapa"])) {
                $map_count = true;
            }
            array_push($map_primary, [
                $filial["nome"],
                $filial["url_mapa"]
            ]);
            if (count($filial['outros_contatos']) > 0) {
                foreach ($filial['outros_contatos'] as $outro_contato) {
                    if ($outro_contato["icone"] == "fa fa-phone") {
                        array_push($phone_secundary, [
                            $outro_contato["titulo"] ?? '',
                            alt_mascara('(##) ####-#####', $outro_contato["url_valor"]),
                            'tel:' . $outro_contato["url_valor"]
                        ]);
                    }
                    if ($outro_contato["icone"] == "fab fa-whatsapp" && strlen($outro_contato["url_valor"]) > 8) {
                        array_push($whats_secundary, [
                            $outro_contato["titulo"] ?? '',
                            alt_mascara('(##) ####-#####', $outro_contato["url_valor"]),
                            'https://wa.me/55' . $outro_contato["url_valor"] . $text
                        ]);
                    }
                }
            }
        }
        return [
            "phone" => array_merge($phone_primary, $phone_secundary),
            "whats" => array_merge($whats_primary, $whats_secundary),
            "maps" => $map_primary,
            "phone_count" => $phone_count,
            "map_count" => $map_count,
            "whats_count" => $whats_count
        ];
    }
}

if (!function_exists('alt_get_matriz_whatsapp')) {
    function alt_get_matriz_whatsapp($url = false)
    {
        if ($url) {
            $text = "?text= Olá, tenho interesse nesse veículo e gostaria de obter mais informações: " . $url;
        } else {
            $text = "?text=" . (empty($_SERVER['HTTPS']) ? 'http' : 'https') . "://$_SERVER[HTTP_HOST]$_SERVER[REQUEST_URI]";
        }
        $whatsapp = alt_get_filiais_matriz();

        $whatsapp_numero = isset($whatsapp[0]["url_whatsapp"]) ? $whatsapp[0]["url_whatsapp"] : '';
        
        $output = $whatsapp_numero . $text;

        return $output;
    }
}

if (!function_exists('alt_formatar_whatsapp')) {
    function alt_formatar_whatsapp($phone, $url = false)
    {
        $output = 'https://wa.me/55';
        $output .= preg_replace('/[^0-9]/', '', $phone);
        if ($url) {
            $output .= "?text= Olá, tenho interesse nesse veículo e gostaria de obter mais informações: " . $url;
        } else {
            $output .= "?text=" . (empty($_SERVER['HTTPS']) ? 'http' : 'https') . "://$_SERVER[HTTP_HOST]$_SERVER[REQUEST_URI]";
        }
        return $output;
    }
}

if (!function_exists('is_current_page')) {
    function is_current_page($paginas)
    {
        $existe = strpos($paginas, 'current');

        if (empty($existe)) {
            return 'page';
        }
        return 'current';
    }
}

if (!function_exists('get_format_youtube')) {
    function get_format_youtube($url)
    {
        $existe = strpos($url, 'embed');
        if (empty($existe)) {
            $url_array = explode('watch?v=', $url);
            return 'https://www.youtube.com/embed/' . end($url_array);
        }
        return $url;
    }
}

if (!function_exists('alt_get_matriz')) {
    function alt_get_matriz()
    {
        $filiais = alt_get_filiais_matriz();
        return reset($filiais);
    }
}

if (!function_exists('alt_get_img_car')) {
    function alt_get_img_car()
    {
        $filiais = alt_get_filiais_matriz();
        $loja = reset($filiais);
        $tipoVeiculo = alt_get_tipo_veiculo();
        
        if (!empty($loja["imagem_venda"])) {
            $url_img =  $loja["imagem_venda"];
            $site_url = get_site_url();
    
            $site_url = str_replace(['http://', 'https://'], '', $site_url);
            $url_img = str_replace(['http://', 'https://'], '', $url_img);
    
            $url_relativa = str_replace($site_url, '', $url_img);
            return $url_relativa; 
        }     
        elseif(!empty($loja["imagem_simulacao"])) {
            $url_img =  $loja["imagem_simulacao"];
            $site_url = get_site_url();
    
            $site_url = str_replace(['http://', 'https://'], '', $site_url);
            $url_img = str_replace(['http://', 'https://'], '', $url_img);
    
            $url_relativa = str_replace($site_url, '', $url_img);
            return $url_relativa; 
        }



        switch ($tipoVeiculo) {
            case 'altimuscarro':
                $imgTipoVeiculo = 'carro_2.png';
                break;
            case 'altimusmoto':
                $imgTipoVeiculo = 'moto_1.png';
                break;
            case 'altimuscaminhao':
                $imgTipoVeiculo = 'caminhao_1.png';
                break;
            case 'altimusbarco':
                $imgTipoVeiculo = 'barco_1.png';
                break;
            case 'altimusaviao':
                $imgTipoVeiculo = 'aviao_3.png';
                break;
            case 'altimustrator':
                $imgTipoVeiculo = 'trator_2.png';
                break;
            default:
                $imgTipoVeiculo = 'carro_2.png';
                break;
        };
        return get_template_directory_uri() . '\\assets\\images\\' . $imgTipoVeiculo;
    }
}

if (!function_exists('alt_get_img_venda')) {
    function alt_get_img_venda()
    {
        $filiais = alt_get_filiais_matriz();
        $loja = reset($filiais);
        $tipoVeiculo = alt_get_tipo_veiculo();
        
        if (!empty($loja["imagem_venda"])) {
            $url_img =  $loja["imagem_venda"];
            $site_url = get_site_url();
    
            $site_url = str_replace(['http://', 'https://'], '', $site_url);
            $url_img = str_replace(['http://', 'https://'], '', $url_img);
    
            $url_relativa = str_replace($site_url, '', $url_img);
            return $url_relativa; 
        }           

        switch ($tipoVeiculo) {
            case 'altimuscarro':
                $imgTipoVeiculo = 'carro_1.png';
                break;
            case 'altimusmoto':
                $imgTipoVeiculo = 'moto_3.png';
                break;
            case 'altimuscaminhao':
                $imgTipoVeiculo = 'caminhao_3.png';
                break;
            case 'altimusbarco':
                $imgTipoVeiculo = 'barco_3.png';
                break;
            case 'altimusaviao':
                $imgTipoVeiculo = 'aviao_2.png';
                break;
            case 'altimustrator':
                $imgTipoVeiculo = 'trator_1.png';
                break;
            default:
                $imgTipoVeiculo = 'carro_1.png';
                break;
        };
        
        return get_template_directory_uri() . '\\assets\\images\\' . $imgTipoVeiculo;
    }
}

if (!function_exists('alt_get_img_simulacao')) {
    function alt_get_img_simulacao()
    {
        $filiais = alt_get_filiais_matriz();
        $loja = reset($filiais);
        $tipoVeiculo = alt_get_tipo_veiculo();

        if (!empty($loja["imagem_simulacao"])) {
            $url_img =  $loja["imagem_simulacao"];
            $site_url = get_site_url();
    
            $site_url = str_replace(['http://', 'https://'], '', $site_url);
            $url_img = str_replace(['http://', 'https://'], '', $url_img);
    
            $url_relativa = str_replace($site_url, '', $url_img);
            return $url_relativa; 
        }

        switch ($tipoVeiculo) {
            case 'altimuscarro':
                $imgTipoVeiculo = 'carro_2.png';
                break;
            case 'altimusmoto':
                $imgTipoVeiculo = 'moto_1.png';
                break;
            case 'altimuscaminhao':
                $imgTipoVeiculo = 'caminhao_1.png';
                break;
            case 'altimusbarco':
                $imgTipoVeiculo = 'barco_1.png';
                break;
            case 'altimusaviao':
                $imgTipoVeiculo = 'aviao_3.png';
                break;
            case 'altimustrator':
                $imgTipoVeiculo = 'trator_2.png';
                break;
            default:
                $imgTipoVeiculo = 'carro_2.png';
                break;
        };
        return get_template_directory_uri() . '\\assets\\images\\' . $imgTipoVeiculo;
    }
}

if (!function_exists('alt_get_img_form_venda')) {
    function alt_get_img_form_venda()
    {
        $tipoVeiculo = alt_get_tipo_veiculo();

        switch ($tipoVeiculo) {
            case 'altimuscarro':
                $imgTipoVeiculo = [
                    get_template_directory_uri() . '/assets/images/venda_simulacao/img-venda.png',
                    get_template_directory_uri() . '/assets/images/venda_simulacao/img-venda-mobile.png',
                ];
                break;
            case 'altimusmoto':
                $imgTipoVeiculo = [
                    get_template_directory_uri() . '/assets/images/venda_simulacao/img-venda-moto.png',
                    get_template_directory_uri() . '/assets/images/venda_simulacao/img-venda-moto-mobile.png',
                ];
                break;
            case 'altimuscaminhao':
                $imgTipoVeiculo = [
                    get_template_directory_uri() . '/assets/images/venda_simulacao/img-venda-caminhao.png',
                    get_template_directory_uri() . '/assets/images/venda_simulacao/img-venda-caminhao-mobile.png',
                ];
                break;
            case 'altimusbarco':
                $imgTipoVeiculo = [
                    get_template_directory_uri() . '/assets/images/venda_simulacao/img-venda-barco.png',
                    get_template_directory_uri() . '/assets/images/venda_simulacao/img-venda-barco-mobile.png',
                ];
                break;
            case 'altimusaviao':
                $imgTipoVeiculo = [
                    get_template_directory_uri() . '/assets/images/venda_simulacao/img-venda-aviao.png',
                    get_template_directory_uri() . '/assets/images/venda_simulacao/img-venda-aviao-mobile.png',
                ];
                break;
            case 'altimustrator':
                $imgTipoVeiculo = [
                    get_template_directory_uri() . '/assets/images/venda_simulacao/img-venda-trator.png',
                    get_template_directory_uri() . '/assets/images/venda_simulacao/img-venda-trator-mobile.png',
                ];
                break;
            default:
                $imgTipoVeiculo = [
                    get_template_directory_uri() . '/assets/images/venda_simulacao/img-venda.svg',
                    get_template_directory_uri() . '/assets/images/venda_simulacao/img-venda-mobile.svg',
                ];
                break;
        };
        return $imgTipoVeiculo;
    }
}

if (!function_exists('alt_get_img_form_simulacao')) {
    function alt_get_img_form_simulacao()
    {
        $tipoVeiculo = alt_get_tipo_veiculo();

        switch ($tipoVeiculo) {
            case 'altimuscarro':
                $imgTipoVeiculo = [
                    get_template_directory_uri() . '/assets/images/venda_simulacao/img-simulacao.png',
                    get_template_directory_uri() . '/assets/images/venda_simulacao/img-simulacao-mobile.png',
                ];
                break;
            case 'altimusmoto':
                $imgTipoVeiculo = [
                    get_template_directory_uri() . '/assets/images/venda_simulacao/img-simulacao-moto.png',
                    get_template_directory_uri() . '/assets/images/venda_simulacao/img-simulacao-moto-mobile.png',
                ];
                break;
            case 'altimuscaminhao':
                $imgTipoVeiculo = [
                    get_template_directory_uri() . '/assets/images/venda_simulacao/img-simulacao-caminhao.png',
                    get_template_directory_uri() . '/assets/images/venda_simulacao/img-simulacao-caminhao-mobile.png',
                ];
                break;
            case 'altimusbarco':
                $imgTipoVeiculo = [
                    get_template_directory_uri() . '/assets/images/venda_simulacao/img-simulacao-barco.png',
                    get_template_directory_uri() . '/assets/images/venda_simulacao/img-simulacao-barco-mobile.png',
                ];
                break;
            case 'altimusaviao':
                $imgTipoVeiculo = [
                    get_template_directory_uri() . '/assets/images/venda_simulacao/img-simulacao-aviao.png',
                    get_template_directory_uri() . '/assets/images/venda_simulacao/img-simulacao-aviao-mobile.png',
                ];
                break;
            case 'altimustrator':
                $imgTipoVeiculo = [
                    get_template_directory_uri() . '/assets/images/venda_simulacao/img-simulacao-trator.png',
                    get_template_directory_uri() . '/assets/images/venda_simulacao/img-simulacao-trator-mobile.png',
                ];
                break;
            default:
                $imgTipoVeiculo = [
                    get_template_directory_uri() . '/assets/images/venda_simulacao/img-simulacao.png',
                    get_template_directory_uri() . '/assets/images/venda_simulacao/img-simulacao-mobile.png',
                ];
                break;
        };
        return $imgTipoVeiculo;
    }
}

if (!function_exists('alt_view_car')) {
    function alt_view_car()
    {
        if (alt_validar_chave('view', $_REQUEST, false)) {
            return $_REQUEST['view'];
        }
        return get_layout_estoque();
    }
}

if (!function_exists('alt_list_car')) {
    function alt_list_car($veiculos)
    {
        $output = [];
        foreach ($veiculos as $veiculo) {
            if (is_array($veiculo)) {
                array_push($output, $veiculo['objeto']->ID);
            } else {
                array_push($output, $veiculo->ID);
            }
        }
        return $output;
    }
}
if (!function_exists('alt_count_image')) {
    function alt_count_image($post_id)
    {
        $images = alt_get_caracteristicas($post_id, 'alt_imagens');
        $count = 0;
        foreach ($images as $attachment_id => $url_image) {
            $dirFile = explode('wp-content', $url_image);
            $path = 'wp-content' . $dirFile[1];
            if (file_exists($path)) {
                $count++;
            }
        }
        return $count++;
    }
}
if (!function_exists('alt_no_image')) {
    function alt_no_image()
    {
        $img_default = 'https://via.placeholder.com/350x265?text=Sem%20Foto';
        $dados = get_option('alt_group_setup');
        if (!isset($dados['foto_padrao_veiculo']) && $dados['foto_padrao_veiculo'] !== $img_default) {
            return $dados['foto_padrao_veiculo'];
        }
        return get_template_directory_uri() . '/assets/images/veiculo-sem-foto.png';
    }
}
//função que limita a quantidade de caracteres de uma string
if (!function_exists('alt_limitar_caracteres')) {
    function alt_limitar_caracteres($string, $limite)
    {
        if (strlen($string) > $limite) {
            return substr($string, 0, $limite) . '...';
        }
        return $string;
    }
}
