<?php 
  $paleta_cor = get_paleta_de_cores();
  
  $primaria = get_cor('cor_primaria');
  $secundaria = get_cor('cor_secundaria');
  $fundo = get_cor('cor_fundo');
  $cor_rodape = '#FFFFFF';
  $classe_dark = '';

  if($paleta_cor == 'personalizado-altimus'){
    $secundaria = "#FFFFFF";
    $cor_rodape = '#000000';
    $classe_dark = 'menu-dark';
  } 
  $args = array(
    'post_type' => 'banners',
    'post_status' => array('publish')
  );
  $query = new WP_Query($args);
  $arrSlides = $query->posts;
  while ($query->have_posts()) : $query->the_post(); 
  $image_url = get_post_meta(get_the_ID(), 'alt_banner_imagem', true) ?? null;
  endwhile;
  ?>

<!DOCTYPE html>
<html lang="pt-BR" class="" id='root-dark' style="margin-top: 0 !important;">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <?php echo '<link rel="preload" as="image" href="' . esc_url($image_url) . '" />';?>
  <?wp_head()?>

  <?php 
    $paleta_cor = get_paleta_de_cores();
    $corTextosPersonalizada = get_cor('cor_textos_header_footer');
    $corRodapeCabecalho =  get_cor('cor_cabecalho_rodape');
    $primaria = get_cor('cor_primaria');
    $secundaria = get_cor('cor_secundaria');
    $fundo = get_cor('cor_fundo');
    $corTopbar = get_cor('cor_topbar');
    $fundoLogoEmpresa = get_cor('cor_fundo_logo_empresa');
    if($fundoLogoEmpresa === ''){$fundoLogoEmpresa = $primaria;}
    if($corRodapeCabecalho != ''){$cabecalhoRodapeClass = 'bg-personalizado';}
    if($corTextosPersonalizada != ''){$textClass = 'text-color';}
    if($corTopbar != ''){$topbarClass = 'topbar-color';}
    $cor_rodape = '#FFFFFF';
    $classe_dark = '';

    if($paleta_cor == 'personalizado-altimus'){
      $secundaria = "#FFFFFF";
      $cor_rodape = '#000000';
      $classe_dark = 'menu-dark';
    }

    $menuFixo = alt_cabecalho_fixo();

  ?>
  
  <script>
    document.documentElement.style.setProperty('--primary_color', '<?php echo $primaria ?>');
    document.documentElement.style.setProperty('--secundary_color', '<?php echo $secundaria ?>');
    document.documentElement.style.setProperty('--background_color', '<?php echo $fundo ?>');
    document.documentElement.style.setProperty('--rodape_color', '<?php echo $cor_rodape ?>');
    document.documentElement.style.setProperty('--logo_empresa_color', '<?php echo $fundoLogoEmpresa ?>');
    document.documentElement.style.setProperty('--cor_personalizada', '<?php echo $corRodapeCabecalho ?>');
    document.documentElement.style.setProperty('--text_color', '<?php echo $corTextosPersonalizada ?>');
    document.documentElement.style.setProperty('--topbar_color', '<?php echo $corTopbar ?>');
  </script>
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/swiper@10/swiper-bundle.min.css" />
  <link rel="stylesheet" type="text/css" href="https://rawgit.com/kenwheeler/slick/master/slick/slick.css"/>
  <link rel="stylesheet" type="text/css" href="https://rawgit.com/kenwheeler/slick/master/slick/slick-theme.css"/>
</head>
<?$matriz = alt_get_matriz();?>
<body <? body_class();?> style="background:<?php echo $fundo ?>;"  class='<?php echo $classe_dark ?>'>
    <?php
      do_action('after_body_open_tag');
    ?>
  <!--Modal-->
  <div class="modal opacity-0 pointer-events-none fixed w-full h-full top-0 left-0 flex items-center justify-center z-50 overflow-hidden">
    <div class="modal-overlay absolute w-full h-full bg-gray-900 opacity-50"></div>
    
    <div class="modal-container bg-white w-[38rem] mx-auto rounded shadow-lg mt-8 z-50 overflow-y-auto">
      <!-- Add margin if you want to see some of the overlay behind the modal-->
      <div class="modal-content py-8 text-left">
        <!--Title-->
        <div class="flex justify-between items-center pb-3 px-6">
          <p class="text-lg font-bold">Tamanho do texto</p>
          <div class="modal-close cursor-pointer z-50">
            <svg class="fill-current text-black" xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 18 18">
              <path d="M14.53 4.53l-1.06-1.06L9 7.94 4.53 3.47 3.47 4.53 7.94 9l-4.47 4.47 1.06 1.06L9 10.06l4.47 4.47 1.06-1.06L10.06 9z"></path>
            </svg>
          </div>
        </div>

        <!--Body-->
        <div class="w-full bg-slate-100 p-6 border-y-2 border-gray-200">
          <p>Para aumentar ou diminuir a fonte em nosso site, utilize os atalhos Ctrl+ (para aumentar) e Ctrl- (para diminuir) no seu teclado.</p>
        </div>
        <!--Footer-->
        <div class="flex justify-end pt-2 px-6">
          <button class="modal-close btn-border p-2">Fechar</button>
        </div>
        
      </div>
    </div>
  </div>
  <!--End Modal-->

  <header class="border-b-2 border-gray-300">
    <div class="content_infos <?= $topbarClass; ?>">
      <div class="content_infos-container flex" >
        <div class="content_acessibilidade">
          <div class="relative flex gap-2 items-center z-[100]">
            <div class="w-5">
              <a href="javascript:void(0)" aria-label="Abrir o menu de acessibilidade" id="dropdownToggle">
                <svg xmlns="http://www.w3.org/2000/svg" class="fill-fill-black" viewBox="0 0 122.88 122.88">
                  <path d="M61.44,0A61.46,61.46,0,1,1,18,18,61.21,61.21,0,0,1,61.44,0Zm-.39,74.18L52.1,98.91a4.94,4.94,0,0,1-2.58,2.83A5,5,0,0,1,42.7,95.5l6.24-17.28a26.3,26.3,0,0,0,1.17-4,40.64,40.64,0,0,0,.54-4.18c.24-2.53.41-5.27.54-7.9s.22-5.18.29-7.29c.09-2.63-.62-2.8-2.73-3.3l-.44-.1-18-3.39A5,5,0,0,1,27.08,46a5,5,0,0,1,5.05-7.74l19.34,3.63c.77.07,1.52.16,2.31.25a57.64,57.64,0,0,0,7.18.53A81.13,81.13,0,0,0,69.9,42c.9-.1,1.75-.21,2.6-.29l18.25-3.42A5,5,0,0,1,94.5,39a5,5,0,0,1,1.3,7,5,5,0,0,1-3.21,2.09L75.15,51.37c-.58.13-1.1.22-1.56.29-1.82.31-2.72.47-2.61,3.06.08,1.89.31,4.15.61,6.51.35,2.77.81,5.71,1.29,8.4.31,1.77.6,3.19,1,4.55s.79,2.75,1.39,4.42l6.11,16.9a5,5,0,0,1-6.82,6.24,4.94,4.94,0,0,1-2.58-2.83L63,74.23,62,72.4l-1,1.78Zm.39-53.52a8.83,8.83,0,1,1-6.24,2.59,8.79,8.79,0,0,1,6.24-2.59Zm36.35,4.43a51.42,51.42,0,1,0,15,36.35,51.27,51.27,0,0,0-15-36.35Z"/>
                </svg>
              </a>
            </div>

            <!-- Dropdown -->
            <div id="dropdownMenu" class="dropdownMenu_acessibilidade hidden">
              <ul class="py-2 text-sm text-gray-700">
                <li>
                  <div class="size_text modal-open">
                    <span>
                      <span class="a-a-span">A +</span>
                      <span class="a-a-span2"> | </span>
                      <span class="a-a-span3">A -</span>
                    </span>
                  </div>
                </li>
                <li>
                  <div id="dark-mode" class="high_contrast">
                    <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 20 20">
                      <circle cx="10" cy="10" r="9.5" fill="white" stroke="#1E1B1D"/>
                      <path d="M10 20C7.34783 20 4.8043 18.9464 2.92893 17.0711C1.05357 15.1957 -7.37783e-08 12.6522 0 10C7.37783e-08 7.34784 1.05357 4.8043 2.92893 2.92893C4.8043 1.05357 7.34784 -3.16267e-08 10 0V10V20Z" fill="#1E1B1D"/>
                    </svg>
                    <span class="dark:underline desktop:block text-black text-nowrap">Alto contraste</span>
                  </div>
                </li>
                <li>
                  <a href="/acessibilidade" class="block px-4 py-2 hover:bg-gray-200 rounded-b-lg">Acessibilidade</a>
                </li>
              </ul>
            </div>
          </div>
        </div>
        <?php if (!empty($matriz["horarios"])): ?>
          <div class="content_horario_atendimento">
            <div class="box-pin-map">
              <svg class="bottom-[28.26%] top-[28.26%] overflow-visible fill-black" width="18" height="24" viewBox="0 0 14 20" xmlns="http://www.w3.org/2000/svg">
                <path d="M7 9.5C6.33696 9.5 5.70107 9.23661 5.23223 8.76777C4.76339 8.29893 4.5 7.66304 4.5 7C4.5 6.33696 4.76339 5.70107 5.23223 5.23223C5.70107 4.76339 6.33696 4.5 7 4.5C7.66304 4.5 8.29893 4.76339 8.76777 5.23223C9.23661 5.70107 9.5 6.33696 9.5 7C9.5 7.3283 9.43534 7.65339 9.3097 7.95671C9.18406 8.26002 8.99991 8.53562 8.76777 8.76777C8.53562 8.99991 8.26002 9.18406 7.95671 9.3097C7.65339 9.43534 7.3283 9.5 7 9.5ZM7 0C5.14348 0 3.36301 0.737498 2.05025 2.05025C0.737498 3.36301 0 5.14348 0 7C0 12.25 7 20 7 20C7 20 14 12.25 14 7C14 5.14348 13.2625 3.36301 11.9497 2.05025C10.637 0.737498 8.85652 0 7 0Z"/>
              </svg>
            </div>
            <p class="font-semibold">Venha nos visitar de <?=$matriz["horarios"]?></p>
          </div>
        <?php endif; ?>
      </div>
    </div>
    <div class="content_menu <? echo $classe_dark ?> <?= $menuFixo ?> <?= $cabecalhoRodapeClass ?>">
      <div class="content_menu-container">
        <div class="logo_header">
          <a href="/" class="navbar-brand">
            <img id="logo_cabecalho"
              class="logo__img img-fluid"
              src="<?= alt_url_logo() ?>"
              alt="Logo">         
          </a>          
        </div>
        <div class="box_menu <?= $textClass ;?>">
          <div class="menu_header hidden desktop:block  <?= $cabecalhoRodapeClass ?>">
            <? wp_nav_menu( 
              array(
                'theme_location' => 'alt_main_menu',
                'container_class' => '',
                'menu_class' => 'menu-horizontal',
              )
            ); ?>
          </div>
          <div class="btn_toggle_menu">
            <svg width="33" height="22" viewBox="0 0 33 22" xmlns="http://www.w3.org/2000/svg">
              <path d="M9.77778 20.1667C9.77778 21.1792 10.5986 22 11.6111 22H31.1667C32.1792 22 33 21.1792 33 20.1667C33 19.1541 32.1792 18.3333 31.1667 18.3333H11.6111C10.5986 18.3333 9.77778 19.1541 9.77778 20.1667ZM0 11C0 12.0125 0.820811 12.8333 1.83333 12.8333H31.1667C32.1792 12.8333 33 12.0125 33 11C33 9.98748 32.1792 9.16667 31.1667 9.16667H1.83333C0.82081 9.16667 0 9.98748 0 11ZM6.72222 0C5.7097 0 4.88889 0.820812 4.88889 1.83333C4.88889 2.84585 5.7097 3.66667 6.72222 3.66667H31.1667C32.1792 3.66667 33 2.84585 33 1.83333C33 0.820812 32.1792 0 31.1667 0H6.72222Z"/>
            </svg>
          </div>
        </div>
        <div class="medias_header">
          <?php get_template_part('template-parts/home/session-medias', 'box'); ?>
        </div>
      </div>
    </div>
  </header>
  <?
  if (empty($matriz["url_whatsapp"]) || empty($matriz["nome"])) {
    $url = '';
  } else {
    $url = $matriz["url_whatsapp"] . '?text=Olá, estou no site da ' . $matriz["nome"] . ' e gostaria de mais informações!';  
  }
  ?>
  <?if(!empty($matriz["btn_whats"]) && $matriz['btn_whats'] !== 'nao') :?>
    <div class="btn-whatsapp-float modal_whatsapp_veiculo-btn">    
        <a href="<?=$url?>" target="_blank" rel="nofollow">
          <svg width="26" height="26" viewBox="0 0 26 26" xmlns="http://www.w3.org/2000/svg">
            <path d="M22.2126 4.58887C19.8744 2.24512 16.7606 0.956055 13.4515 0.956055C6.62109 0.956055 1.06306 6.51409 1.06306 13.3444C1.06306 15.5264 1.63225 17.6581 2.71484 19.5386L0.957031 25.9561L7.52511 24.2317C9.33315 25.2194 11.37 25.7384 13.4459 25.7384H13.4515C20.2762 25.7384 25.957 20.1804 25.957 13.35C25.957 10.0409 24.5508 6.93262 22.2126 4.58887ZM13.4515 23.6514C11.5988 23.6514 9.78516 23.1547 8.20591 22.2172L7.83203 21.994L3.93694 23.0152L4.97489 19.215L4.72935 18.8244C3.69699 17.1837 3.15569 15.292 3.15569 13.3444C3.15569 7.66922 7.77623 3.04869 13.457 3.04869C16.2081 3.04869 18.7919 4.12012 20.7338 6.06766C22.6758 8.01521 23.87 10.5989 23.8644 13.35C23.8644 19.0308 19.1267 23.6514 13.4515 23.6514ZM19.0988 15.9393C18.7919 15.7831 17.2684 15.0353 16.9838 14.9348C16.6992 14.8288 16.4927 14.7786 16.2863 15.0911C16.0798 15.4036 15.4883 16.0956 15.3041 16.3076C15.1256 16.5141 14.9414 16.542 14.6345 16.3857C12.8153 15.4761 11.6211 14.7619 10.4213 12.7027C10.1032 12.1558 10.7394 12.1949 11.3309 11.0119C11.4314 10.8054 11.3811 10.6268 11.303 10.4706C11.2249 10.3143 10.6055 8.79088 10.3488 8.17146C10.0977 7.56878 9.84096 7.65248 9.65123 7.64132C9.47266 7.63016 9.26618 7.63016 9.05971 7.63016C8.85324 7.63016 8.51841 7.70829 8.23382 8.01521C7.94922 8.32771 7.15123 9.07547 7.15123 10.5989C7.15123 12.1223 8.26172 13.5956 8.41239 13.802C8.56864 14.0085 10.5943 17.1335 13.7026 18.4784C15.6669 19.3266 16.4369 19.3991 17.4191 19.254C18.0162 19.1648 19.2494 18.5063 19.5061 17.7808C19.7628 17.0554 19.7628 16.436 19.6847 16.3076C19.6122 16.1681 19.4057 16.09 19.0988 15.9393Z"/>
          </svg>
        </a>    
    </div>
  <?endif?>
  

