<?php
// sempre atualizar a versão com a data da atualização do arquivo
define('VERSION_FILES', '2024.11.29');

//Carregando nossos scripts e folhas de estilos
if (!function_exists('alt_load_scripts')) {
    function alt_load_scripts() {
        
        wp_enqueue_style("swiper-bundle", 'https://unpkg.com/swiper/swiper-bundle.min.css', array(), '11.1.15');
        
        wp_enqueue_style("tailwind_setup-style", get_stylesheet_uri(), array(), '3.4.0');
        wp_style_add_data('tailwind_setup-style','rtl','replace');
        wp_enqueue_style("tailwind_output", get_template_directory_uri().'/assets/css/output.css', array(), VERSION_FILES, 'all');
        wp_enqueue_style("altimus", get_template_directory_uri().'/assets/css/altimus.css', array(), VERSION_FILES, 'all');
        wp_enqueue_style("compatibility", get_template_directory_uri().'/assets/css/compatibility.css', array(), VERSION_FILES, 'all');

        wp_enqueue_script('altimus-personalizacao.js', get_template_directory_uri() . '/assets/js/altimus-personalizacao.js', array(), VERSION_PLUGIN_ALTIMUS, ['strategy' => 'async']);    
        wp_enqueue_script("Compartilhamento", 'https://cdn.jsdelivr.net/npm/share-api-polyfill/dist/share-min.js', array(),VERSION_FILES, true );        
        wp_enqueue_script("swiper-bundle", 'https://unpkg.com/swiper/swiper-bundle.min.js', array(),VERSION_FILES, false );
        wp_enqueue_script("altimus", get_template_directory_uri().'/assets/js/altimus.js', array('jquery'),VERSION_FILES, ['strategy' => 'async'] );
        wp_enqueue_script("altimus-filtro", get_template_directory_uri().'/assets/js/altimus-filtro.js', array('jquery'),VERSION_FILES, ['strategy' => 'async'] );
        wp_enqueue_script("altimus-dynamic", get_template_directory_uri().'/assets/js/altimus-dynamic.js', array('jquery'),VERSION_FILES, false );
        wp_enqueue_script("dynamic", get_template_directory_uri().'/assets/js/dynamic-fields.min.js', array('jquery', 'swiper-bundle'),VERSION_FILES, ['strategy' => 'async'] );
    }

    add_action('wp_enqueue_scripts','alt_load_scripts');
}

// Adicionar suporte ao Elementor
function my_theme_elementor_support() {
    add_theme_support( 'elementor' );
}
add_action( 'after_setup_theme', 'my_theme_elementor_support' );

// Adicionar suporte a thumbnails
function my_theme_setup() {
    add_theme_support( 'post-thumbnails' );
}
add_action( 'after_setup_theme', 'my_theme_setup' );

// Incluir scripts e estilos do tema
function my_theme_enqueue_styles() {
    wp_enqueue_style( 'my-theme-style', get_stylesheet_uri() );
}
add_action( 'wp_enqueue_scripts', 'my_theme_enqueue_styles' );

//Tornando URLS de uploads relativas EXP: /2025/03/logo.png
add_filter('wp_handle_upload', function ($upload) {
    $upload_dir = wp_upload_dir();
    $base_url = $upload_dir['baseurl']; 

    // Se a URL do arquivo começar com a base de uploads, converte para relativa
    if (strpos($upload['url'], $base_url) === 0) {
        $upload['url'] = str_replace($base_url, '', $upload['url']);
    }

    return $upload;
}, 10, 1);

//Garantir URLs relativas ao salvar Anexos
add_action('add_attachment', function ($post_ID) {
    $file_path = get_post_meta($post_ID, '_wp_attached_file', true);
    $upload_dir = wp_upload_dir();
    $base_url = $upload_dir['baseurl'];

    // Se o caminho estiver absoluto, converte para relativo
    if ($file_path && strpos($file_path, $base_url) === 0) {
        $relative_path = str_replace($base_url . '/', '', $file_path);
        update_post_meta($post_ID, '_wp_attached_file', $relative_path);
    }
});


require 'inc/setup.php';
require 'inc/util.php';
require 'inc/sidebar/sidebar.php';
require 'inc/widgets/widgets.php';