// VARIAVEIS
const body = document.querySelector("body");
const canva = document.querySelector(".canva-popup");
const sombra = document.querySelector(".sombra-popup");
const containerImg = document.querySelector(".container-img-popup");
const btNext = document.querySelector(".seta-popup-next");
const btPrev = document.querySelector(".seta-popup-prev");
const imagemDestaque = document.querySelector(".img-destaque");
const imagemAmpliada = document.querySelector(".img-popup");
const listaDeImagens = document.querySelectorAll(".loop-item");
const btFechar = document.querySelector(".bt-fechar");
const contadorImg = document.querySelector(".contador-popup");

// GUARDANDO LISTA DE URL DAS IMAGENS 
let listaDeUrl = []
listaDeImagens.forEach( item => {
    const urlDaImagem = item.src.includes('youtube') ? '' : item.getAttribute("src");
    if(urlDaImagem === ''){
        return;
    }
    listaDeUrl.push(urlDaImagem)
})

// ABRE POPUP 
function abrePopUp(){
    const body = document.querySelector('body');
    body.appendChild(canva);
    canva.style.display = "flex";
    body.style.overflow = "hidden";
}

// FECHANDO O POPUP
function fecharPopUp(){
    canva.style.display = "none";
    body.style.overflow = "auto";
}

// APLICANDO ZOOM AO CLICAR NA IMAGEM 
const zoom = [
 "scale(1)",
 "scale(1.1)",
 "scale(1.3)",
 "scale(1.5)",
];
let index = 0;
function zoomNaImagem(){
    containerImg.style.overflow = "scroll";
    index = index + 1;
    imagemAmpliada.style.transform = zoom[index];
    imagemAmpliada.style.heigth = "auto";
    imagemAmpliada.style.heigth = "auto";
}
imagemAmpliada.addEventListener("click", ()=> {
    index === 2 ? imagemAmpliada.style.cursor = "zoom-out" : imagemAmpliada.style.cursor = "zoom-in";
    // SE O ZOOM ESTIVER X3 NO PROXIMO CLIQUE RETIRA O ZOOM
    if(index === 3){
        index = -1;
    }
    zoomNaImagem();
});

// BUSCA URL CLICADA E EXIBE NO INDECE DO ARRAY CORRETO 
let indice = 0;
let urlClicada = '';
function montaImagem(){
    urlClicada = imagemDestaque.children[0].src;
    indice = listaDeUrl.indexOf(urlClicada);
    imagemAmpliada.setAttribute("src", listaDeUrl[indice]);
}

// FUNÇÕES DE NAVEGAÇÃO (PROXIMO/VOLTAR) 
function avancarImagem(){
    if(indice + 1 >= listaDeUrl.length){
        indice = -1;
    }
    indice = indice + 1;
    imagemAmpliada.setAttribute("src", listaDeUrl[indice]); 
    alteraContador()
}

function voltarImagem(){
    if(indice <= 0){
        indice = listaDeUrl.length;
    }
    indice = indice - 1;
    imagemAmpliada.setAttribute("src", listaDeUrl[indice]);
    alteraContador();
}


// NAVEGAÇÃO DAS IMAGENS POR SETA DO TECLADO 
window.addEventListener("keydown", (e)=> {
    if(e.code === "ArrowRight"){
        avancarImagem();
    }
    if(e.code === "ArrowLeft"){
        voltarImagem();
    }
})

// CHAMADA DAS FUNÇÕES
if (imagemDestaque) {
    imagemDestaque.addEventListener("click", ()=> { 
        const urlCompleta = imagemDestaque.children[0].src;
        const urlTratada = urlCompleta.split('/').pop();
        if(urlTratada === "load_altimus.png") {
            return;
        }
        abrePopUp(); 
        montaImagem();
        alteraContador();
    });
}




//NUMERO DO CONTADOR DINAMICO
function buscaUrlAtual(){
    const url = imagemAmpliada.getAttribute("src");
    return url;
}

function alteraContador(){
    const urlAtual = buscaUrlAtual();
    const i = listaDeUrl.indexOf(urlAtual);
    contadorImg.textContent = `${i + 1} / ${listaDeUrl.length}`;
}

btPrev.addEventListener('click', ()=>voltarImagem());
btNext.addEventListener('click', ()=> avancarImagem());
sombra.addEventListener("click", ()=> fecharPopUp());
btFechar.addEventListener('click', ()=> fecharPopUp());