window.addEventListener("load", function() {
    const swiper = new Swiper('.swiper-container-loja', {
        loop: true, // Carrossel infinito
        navigation: {
            nextEl: '.swiper-button-next-loja',
            prevEl: '.swiper-button-prev-loja',
        },
        pagination: {
            el: '.swiper-pagination-loja',
            clickable: true,
        },
        autoplay: {
            delay: 2000, // 2 segundos (2000 ms)
            disableOnInteraction: false, // Continua mesmo após interação do usuário
        },
        slidesPerView: 3, // Quantidade de slides visíveis
        spaceBetween: 20, // Espaço entre slides
        breakpoints: {
            320: { slidesPerView: 2, spaceBetween: 0 },
            640: { slidesPerView: 3, spaceBetween: 5 },
            768: { slidesPerView: 4, spaceBetween: 5 },
            1360: { slidesPerView: 6, spaceBetween: 5 },
            1920: { slidesPerView: 8, spaceBetween: 5 },
        },
    });

    const lojasSlide = document.querySelector('.lojas-slide');
    if (lojasSlide) {
        lojasSlide.style.display = 'flex';
    }

    const lojasLoad = document.querySelector('.loading-loja');
    if (lojasLoad) {
        lojasLoad.style.display = 'none';
    }
});
