jQuery(document).ready(function () {
    jQuery("iframe").each(function(){
        this.setAttribute("title", "Abrir no mapa");
    });
    
    target = jQuery(location).attr('pathname')
    
    if (target.includes('quem-somos')) {
        jQuery('.btn-portal').addClass('hidden');
        jQuery('.btn-associar').removeClass('hidden');
        jQuery('.associar').removeClass('hidden');
    }
    
    jQuery("form.wpcf7-form").submit(function(){
        // Salvar o valor no localStorage
        localStorage.setItem('isCached', 'true'); // Armazena o valor 'true' como string
    });

    // Obter o valor armazenado no localStorage
    const isCached = localStorage.getItem('isCached');
    
    // Verificar se o valor é 'true'
    if (isCached === 'true') {
        localStorage.removeItem('isCached');
        
        jQuery(".wpcf7-response-output").css("display", "block");
        setTimeout(function(){
            jQuery(".wpcf7-response-output").css("display", "none");
        }, 5000);
    }
});

const windowWidth = window.innerWidth;
if (windowWidth >= 768) {
    const listPhone = document.querySelectorAll("#telefone_card_loja");
    listPhone.forEach(item => {
        item.addEventListener("click", (e) => {
            e.preventDefault(); 
            const texto = item.textContent.trim();
            if (!texto) {
                alert("Erro: Nenhum número de telefone encontrado.");
                return;
            }
            navigator.clipboard.writeText(texto)
                .then(() => alert("Telefone copiado: " + texto))
                .catch(() => alert("Erro ao copiar o telefone"));
        });
    });
}

window.addEventListener('scroll', () => {
    const scrollY = window.scrollY;
    const maxHeight = scrollY/16;
    const alturaBarraInfo = document.querySelector(".content_infos").clientHeight;
    const menu = document.querySelector('.content_menu');
    let  alturaCorrigida = 0;

    if (maxHeight > 0) {
        translateY = alturaBarraInfo;
        const windowWidth = window.innerWidth;
        if (windowWidth < 768) {
            translateYvehicle = -3.6;
        } else {
            translateYvehicle = -2.3;
        }
        alturaCorrigida = translateY + 1;        
    } else {
        translateY = 0;
        translateYvehicle = 0;
    }
    
    menu.style.transform = `translateY(-${alturaCorrigida}px)`;

    const singleVehicle = document.querySelector('.single-vehicle .card-content-bar');
    if (singleVehicle) {
        singleVehicle.style.transform = `translateY(${translateYvehicle}rem)`;
    }
});

// Botao de compartilhamento 
const btnShare = document.querySelector("#share-btn");
if(btnShare){
    btnShare.addEventListener("click", (e)=> {
        e.preventDefault();
        const link = window.location.href;
        if (navigator.share) {
            compartilhar(link);
        } else {
            alert("Seu navegador não suporta o compartilhamento nativo.");
        }
    })
}

const listBtnShare = document.querySelectorAll("#share-card");
listBtnShare.forEach( btn => {
    btn.setAttribute("href", `${btn.parentNode.childNodes[1].href}`);
    btn.addEventListener("click", (e)=> {
        e.preventDefault();
        const link = btn.parentNode.childNodes[1].href;
        if (navigator.share) {
            compartilhar(link);
        } else {
            alert("Seu navegador não suporta o compartilhamento nativo.");
        }
    })
})

function compartilhar(link){
    navigator.share({
        title: 'Compartilhe com alguém',
        text: 'Confira esse veículo:',
        url: link,
      },
      {
        copy: true,
        email: true,
        print: true,
        sms: true,
        messenger: true,
        facebook: true,
        whatsapp: true,
        twitter: true,
        linkedin: true,
        telegram: true,
        skype: true,
        pinterest: true,
        language: 'pt-br',
      }
    )
      .then( _ => console.log('deu certo.'))
      .catch( error => console.log(`Parece que tivemos um erro: ${error}`));
}

function mascara(o,f){
    v_obj=o
    v_fun=f
    setTimeout("execmascara()",1)
}

function execmascara(){
    v_obj.value=v_fun(v_obj.value)
}

function mtel(v){
    v=v.replace(/\D/g,""); //Remove tudo o que não é dígito
    v=v.replace(/^(\d{2})(\d)/g,"($1) $2"); //Coloca parênteses em volta dos dois primeiros dígitos
    v=v.replace(/(\d)(\d{4})$/,"$1-$2"); //Coloca hífen entre o quarto e o quinto dígitos
    return v;
}

function retornaId( id ){
	return document.getElementById( id );
}

window.onload = function(){
    const telefone = retornaId('telefone');
    const whatsapp = retornaId('whatsapp');

    if(telefone){
        telefone.onkeyup = function(){
            mascara( this, mtel );
        }
    }
    if(whatsapp){
        whatsapp.onkeyup = function(){
            mascara( this, mtel ); 
        }
    }
}

// Exibindo titulo da seção de redes sociais na home
document.addEventListener('DOMContentLoaded', function() {
    const listaRedesSociais = document.querySelectorAll('.box-list div');
    const tituloRedesSociais = document.querySelector(".social_media_titulo");
    if(listaRedesSociais){
        listaRedesSociais.length > 0 ? tituloRedesSociais.style.display = 'block': '';
    }
});

function aplicaMargemMenu(){
    const menuTop = document.querySelector(".content_menu");
    const alturaMenu = menuTop.clientHeight;
    const header = document.querySelector("header");
    if(menuTop.classList.contains('fixed')){
        menuTop.style.position = "fixed";
        const navBarVeiculo = document.querySelector(".card-content-bar");
        if(navBarVeiculo){
            navBarVeiculo.style.position = 'fixed';
        }
        header.style.marginBottom = `${alturaMenu}px`;
    }    
}

aplicaMargemMenu();

const topbarVeiculo = document.querySelector(".card-content-bar");
if(topbarVeiculo && topbarVeiculo.style.position === 'fixed'){
    const detalhesVeiculo = document.querySelector(".vehicle-details");
    const larguraTela = window.innerWidth;  
    larguraTela > 767 ? detalhesVeiculo.style.marginTop = '4rem' : detalhesVeiculo.style.marginTop = '7rem';
}

