jQuery(document).ready(function ($) {
    // Obtenha a cor primária do tema
    const rootStyles = getComputedStyle(document.documentElement);
    const primaryColor = rootStyles.getPropertyValue("--primary_color").trim();
    is_dark = isHexColorDark(primaryColor); // Exemplo de saída: "#fa2837"

    // Carrega a logo
    const logoUrl = document.getElementById('log-colorida').textContent;
    const logo = document.getElementById('assinatura-autos-360');
    
    // Altera a logo e cor do texto se a cor for clara
    if(!is_dark){
        logo.src = logoUrl;
        $('.item-cor-dinamico').css('color', '#111');
    }

    /**
     * Verifica se a cor representada por seus componentes RGB é considerada escura.
     *
     * A fórmula utilizada é a da luminância relativa (percepção humana), que
     * considera a sensibilidade do olho humano às cores.
     *
     * @param {number} r - Componente vermelho (0-255)
     * @param {number} g - Componente verde (0-255)
     * @param {number} b - Componente azul (0-255)
     * @returns {boolean} true se a cor for considerada escura, false caso contrário
     */
    function isColorDark(r, g, b) {
        // Fórmula da luminância relativa (percepção humana)
        const yiq = (r * 299 + g * 587 + b * 114) / 1000;
        return yiq < 128; // abaixo de 128 é considerado escuro
    }

    /**
     * Converte um código de cor hexadecimal para seus componentes RGB.
     *
     * @param {string} hex - O código de cor hexadecimal, começando com '#' ou sem ele.
     * @returns {Object} Um objeto com os componentes RGB: { r: number, g: number, b: number }.
     */
    function hexToRgb(hex) {
        hex = hex.replace("#", "");
        const bigint = parseInt(hex, 16);
        const r = (bigint >> 16) & 255;
        const g = (bigint >> 8) & 255;
        const b = bigint & 255;
        return { r, g, b };
    }

    /**
     * Determina se um código de cor hexadecimal representa uma cor escura.
     *
     * Esta função converte o código de cor hexadecimal para seus componentes RGB
     * e usa a fórmula de luminância relativa para avaliar se a cor é
     * escura, com base na percepção humana.
     *
     * @param {string} hex - O código de cor hexadecimal, com ou sem o símbolo '#'.
     * @returns {boolean} true se a cor for considerada escura, false caso contrário.
     */
    function isHexColorDark(hex) {
        const { r, g, b } = hexToRgb(hex);
        return isColorDark(r, g, b);
    }
});
