jQuery( document ).ready(function() {
  loadExtends();

  const url_full = window.location.href;
  const url_array = url_full.split('&');
  
  // Converte o array em um objeto de parâmetros
  const paramsObj = convertUrlArrayToObject(url_array);
  
  // Se existirem os parâmetros form_categoria e form_estado, setar os selects correspondentes
  if (paramsObj['categoria']) {
    jQuery("#form_categoria").val(paramsObj['categoria']);
  }
  if (paramsObj['estado']) {
    jQuery("#form_estado").val(paramsObj['estado']);
  }
  
  if (Array.isArray(url_array)) {
    url_array.forEach(setFields)
    function setFields(item) {
      field = item.split('=')
      if (field[0] == 'marca') {
        jQuery("#form_marca").val(field[1]);
      }
      if (field[0] == 'modelo') {
        jQuery("#form_modelo").val(field[1]);
      }
      if (field[0] == 'ano') {
        jQuery("#form_ano").val(field[1]);
      }
      if (field[0] == 'cambio') {
        jQuery("#form_cambio").val(decodeURIComponent(field[1]));
      }
      if (field[0] == 'max_price') {
        setValue(field[1]);
        jQuery('#labels-range-input').val(field[1]);
      }
    }  
  }
  
  
  jQuery(".filter-max").on( "click", function() {
    displayFilter();
  });

  jQuery(".filter-min").on( "click", function() {
    displayFilter();
  });

  jQuery( "#labels-range-input" ).on( "change", function() {
    var price = jQuery(this).val();
    setValue(price);
  } );

  function setValue(price) {
    var amount = "R$ " + price.split(/(?=(?:...)*$)/).join('.')
    jQuery('#text-max').text(amount);
    jQuery('#form_max_price').val(price);
  }

  //Ação alterar a seleção
  jQuery("#form_marca").on("change", function (v) {
    carregarModelos();
  });

  jQuery("#form_modelo").on("change", function (v) {
    atualizarAno();
    atualizarCambio();
  });

  jQuery("#form_ano").on("change", function (v) {
    atualizarCambio();
  });

  //Funções de ação
  function carregarModelos() {
    let marca = jQuery("#form_marca").val();

    let url_base = "/wp-admin/admin-ajax.php?action=get_modelos_rest";
    let url = url_base.concat("&marca=" + marca);
    setModelo(url)
    setAno(url)
    setCambio(url)
  }

  function atualizarAno() {
    let marca = jQuery("#form_marca").val();
    let modelo = jQuery("#form_modelo").val();

    let url_base = "/wp-admin/admin-ajax.php?action=get_modelos_rest";
    let url = url_base.concat("&marca=" + marca).concat("&modelo=" + modelo);
    setAno(url)
  }
  
  function atualizarCambio() {
    let marca = jQuery("#form_marca").val();
    let modelo = jQuery("#form_modelo").val();
    let ano = jQuery("#form_ano").val();

    let url_base = "/wp-admin/admin-ajax.php?action=get_modelos_rest";
    let url = url_base.concat("&marca=" + marca).concat("&modelo=" + modelo).concat("&ano=" + ano);
    setCambio(url);
  }

  function setModelo(url) {
    jQuery("#form_modelo").empty();
    jQuery("#form_modelo").append(new Option("Carregando", ""));

    jQuery.get(url, function (response) {
      jQuery("#form_modelo").append(new Option("Modelo", ""));
      jQuery.each(response.posts, function (v, t) {
        let value = t.slug;
        let name = t.name;
        jQuery("#form_modelo").append(new Option(name, value));
      });
    }).done(function () {
      jQuery("#form_modelo option:contains('Carregando')").remove();
    });
  }

  function setAno(url) {
    //Atualizar anos
    jQuery("#form_ano").empty();
    jQuery("#form_ano").append(new Option("Carregando", ""));

    jQuery.get(url, function (response) {
      jQuery("#form_ano").append(new Option("Ano", ""));
      jQuery.each(response.anos, function (v, t) {
        let value = v;
        let name = t;
        jQuery("#form_ano").append(new Option(name, value));
      });
    }).done(function () {
      jQuery("#form_ano option:contains('Carregando')").remove();
    });
  }

  function setCambio(url) {
    jQuery("#form_cambio").empty();
    jQuery("#form_cambio").append(new Option("Carregando", ""));

    jQuery.get(url, function (response) {
      jQuery("#form_cambio").append(new Option("Tipo de câmbio", ""));
      jQuery.each(response.cambios, function (v, t) {
        let value = v;
        let name = t;
        jQuery("#form_cambio").append(new Option(name, value));
      });
    }).done(function () {
      jQuery("#form_cambio option:contains('Carregando')").remove();
    });
  }

  //verifica se no storage existe a definição de filtro aberto
  function displayFilter() {
    if (!localStorage.getItem("filter")) {
        extendsFilter(true);
        localStorage.setItem("filter", true);
    } else {
        extendsFilter();
        localStorage.removeItem('filter');
    }
  }

  //carrega o modo dark, caso tenha sido selecionado antes
  function loadExtends() {
    if (localStorage.getItem("filter")) {
        extendsFilter(true);
    } else {
        extendsFilter();
    }
  }

  //extender ou retrair o box do filtro
  function extendsFilter(display = false) {
      if (display) {
        jQuery( ".filter-max" ).hide();
        jQuery( ".medias-horizontal" ).hide();
        jQuery( ".filter-min").show();
        jQuery( ".group-filter-max").show();
        jQuery( "#veiculo").prop( "disabled", true );
      } else {
        jQuery( ".filter-min" ).hide();
        jQuery( ".group-filter-max").hide();
        jQuery( ".filter-max" ).show();
        if (jQuery('.destaque_semana .title').css('display') === 'none') {
          jQuery( ".medias-horizontal" ).show();
        }
        jQuery( "#veiculo").prop( "disabled", false );
      }
  }

  let view = '';
  window.location.href.includes('&view=lista') ? view = 'lista' : view = 'bloco';

  jQuery("#filter-order").on( "change", function() {
    orderView();
  });
  jQuery(".icon-list").on( "click", function() {
    view = 'lista';
    jQuery(".icon-list").addClass("active");
    jQuery(".icon-block").removeClass("active");
    orderView();

  });
  jQuery(".icon-block").on( "click", function() {
    view = 'bloco';
    jQuery(".icon-block").addClass("active");
    jQuery(".icon-list").removeClass("active");
    orderView();
  });

  // Pegar get da URL para carregar os filtros de ordenação, 
  // caso exista mais parametros para continuar filtran após a ordenação

  //Array de parametros 'chave=valor'
  var params = window.location.search.substring(1).split('&');
  var paramsURL;
  params.forEach((item) => {
    var orderParam = item.includes('orderby');
    var viewParam = item.includes('view');    
    if (orderParam == false && viewParam == false) {
      paramsURL = paramsURL ? paramsURL  + item + '&' : item + '&';
    }
  })


  function orderView() {  
    order = jQuery("#filter-order").find(":selected").val();
    window.location.href = `/estoque/?${paramsURL}orderby=${order}&view=${view}`;
  }
} );

// Função para converter o array de strings (formato key=value) em um objeto
function convertUrlArrayToObject(url_array) {
  const params = {};
  url_array.forEach(function(item, index) {
      // Se for o primeiro item e contiver um '?', remove tudo antes do '?'
      if (index === 0 && item.indexOf('?') !== -1) {
          item = item.substring(item.indexOf('?') + 1);
      }
      
      if (!item) return; // ignora itens vazios
      
      const parts = item.split('=');
      
      if (parts.length >= 2) {
          const key = decodeURIComponent(parts[0].trim());
          const value = decodeURIComponent(parts[1].trim());
          params[key] = value;
      }
  });
  return params;
}