//js para itens dinâmicos
jQuery( document ).ready(function() {
    target = jQuery(location).attr('pathname')
    if (target.includes('veiculos')) {
        validacaoImagem(jQuery('.loop-item').first());
    }
    if (target.includes('acessibilidade')) {
        jQuery('#label-accessibility').css("text-decoration", "underline");   
    }
    if (jQuery('.destaque_semana .title').css('display') === 'none' || (target.includes('veiculos') && window.innerWidth <= 992)) {
        jQuery('.card-box-veiculo').first().attr('style', 'display:block');
        if (jQuery('.card-box-veiculo').first().attr("id")) {
            var first_card = jQuery('.card-box-veiculo').first().attr("id").replace(/[^0-9]/g,'');
            var target_card = first_card;
            var list_card = [first_card];
            activeCard(first_card);    
        }        
    }
    if (jQuery('.list_posts .noticia-card-slide').css('display') !== 'none' && window.innerWidth <= 768) {
        jQuery('.noticia-box').first().attr('style', 'display:block');
        if (jQuery('.noticia-box').first().attr("id")) {
            var first_card_noticia = jQuery('.noticia-box').first().attr("id").replace(/[^0-9]/g,'');
            var target_card_noticia = first_card_noticia;
            var list_card_noticia = [first_card_noticia];
            activeCardNoticia(first_card_noticia);    
        }
    }

    
    var target_img = [];
    loadModel();
    jQuery(".close-box").on( "click", function() {
        displayBoxInfo();
    });
    jQuery("#option-simular").on( "click", function() {
        displayBoxInfo(true);
        jQuery("#option-pesquisar").removeClass('active');
        jQuery(".close-box").removeClass('active');
        jQuery(this).addClass('active');
        jQuery(".close-box").addClass('active');
        jQuery( ".form-filter" ).hide();
        jQuery( "group-filter-max" ).hide();
        jQuery( "#form-simulacao").show();
      });
      jQuery("#option-pesquisar").on( "click", function() {
        displayBoxInfo(true);
        jQuery("#option-simular").removeClass('active');
        jQuery(".close-box").removeClass('active');
        jQuery(this).addClass('active');
        jQuery(".close-box").addClass('active');
        jQuery( "#form-simulacao" ).hide();
        jQuery( ".form-filter").show();
        jQuery( ".group-filter-max").show();
    });
    jQuery("#dark-mode").on( "click", function() {
        darkModel();
      });  
    //start slider in card
    jQuery(".slide-item").on( "click", function() {
        var post_id = jQuery(this).attr("id").replace(/[^0-9]/g,'');
        var img_default = "#img-targe-" + post_id;
        var img_toggle = jQuery(this).children("input");
        var img_url = img_toggle.attr("value");
        var img_id = img_toggle.attr("id");
        target_img[post_id] = img_id;
        activeIcon(img_id);
        caroselToggleImg(img_default, img_url);
    });
    jQuery(".slide-prev").on( "click", function() {
        var post_id = jQuery(this).attr("id").replace(/[^0-9]/g,'')
        var target = "#img-targe-" + post_id; //img a ser alterada
        var id = target_img[post_id]; //id da imagem a ser modificada
        var moved = caroselMoveTo(post_id, target, id, 'prev');
        if (moved) {
            target_img[post_id] = moved;
            activeIcon(moved);
        }
    });
    jQuery(".slide-next").on( "click", function() {
        var post_id = jQuery(this).attr("id").replace(/[^0-9]/g,'')
        var target = "#img-targe-" + post_id; //img a ser alterada
        var id = target_img[post_id]; //id da imagem a ser modificada
        var moved = caroselMoveTo(post_id, target, id, 'next');
        if (moved) {
            target_img[post_id] = moved;
            activeIcon(moved);
        }
    });    
    //end slider in card
    //start slider out card
    jQuery(".card-slide-item").on( "click", function() {
        activeCard(jQuery(this).attr("id").replace(/[^0-9]/g,''));
    });
    jQuery(".card-slide-prev").on( "click", function() {
        runPrevNext();
    });
    jQuery(".card-slide-next").on( "click", function() {
        runPrevNext(true); 
    });  
    //end slider out card
    //start slider out card vehicle
    jQuery(".similar-slide-item").on( "click", function() {
        activeCard(jQuery(this).attr("id").replace(/[^0-9]/g,''));
    });
    jQuery(".similar-slide-prev").on( "click", function() {
        runPrevNext();
    });
    jQuery(".similar-slide-next").on( "click", function() {
        runPrevNext(true); 
    });  
    //end slider out card vehicle
    //start slider out noticia
    jQuery(".noticia-slide-item").on( "click", function() {
        activeCardNoticia(jQuery(this).attr("id").replace(/[^0-9]/g,''));
    });
    jQuery(".noticia-slide-prev").on( "click", function() {
        runPrevNextNoticia();
    });
    jQuery(".noticia-slide-next").on( "click", function() {
        runPrevNextNoticia(true); 
    });  
    //end slider out noticia
    if (jQuery('input[name="page_url"]')) {
        jQuery('input[name="page_url"]').val(window.location.href);
    }
    /*
    action: true (next) / false (prev)
    */
    var footer = document.querySelector('.footer');
    var marcas = document.querySelector('.footer-marcas-mais-buscadas');

    if (footer && !marcas) {
        footer.classList.add('no-marcas');
    }

    function runPrevNext(action=null) {
        index = list_card.indexOf(target_card);
        if (action) {
            key = index + 1;    
        } else {
            key = index - 1;    
        }
        if (list_card[key]) {
            activeCard(list_card[key]);
        }
    }
    function caroselMoveTo(post_id, target, id, action) {
        new_id = undefined;
        new_img = undefined;
        if (id != undefined && action == 'prev') {
            split_id = id.split('-', 2)

            if (split_id[1] > 0) {
                prev = parseInt(split_id[1]) - 1;
                new_id = split_id[0] + '-' + prev;
                new_img = jQuery("#"+new_id).attr("value");
            }     
        } 
        if (id == undefined && action == 'next') {
            new_id = post_id + '-' + 1;
            new_img = jQuery("#"+new_id).attr("value");
        } else if (action == 'next') {
            split_id = id.split('-', 2)
            next = parseInt(split_id[1]) + 1;
            new_id = split_id[0] + '-' + next;
            new_img = jQuery("#"+new_id).attr("value");
        }
        if (new_id != undefined && new_img != undefined) {
            jQuery("#line-"+new_id).addClass("active");
            // Verifica se a imagem existe antes de usar
            imagemExiste(new_img).then(existe => {
                const imgFinal = existe ? new_img : imagemPadraoVeiculoUrl;
                caroselToggleImg(target, imgFinal);
            });            
            return new_id;
        }   
    }

    function activeIcon(img_id) {
        var ids = img_id.split("-");
        item = '#box-veiculo-'+ids[0];
        const elements = document.querySelectorAll(item); 
        elements.forEach(element => { 
            element.classList.remove('active'); 
        }); 
        jQuery('#'+img_id).parent().addClass('active');
    }

    function activeCard(card_id) {
        const elements = document.querySelectorAll('.card-box-veiculo'); 
        elements.forEach(element => { 
            current_id = element.getAttribute('id').replace(/[^0-9]/g,'');
            if (Array.isArray(list_card) && list_card.indexOf(current_id) == -1) {
                list_card.push(current_id);
            }
            element.style.display = 'none';
            jQuery( "#box-veiculo-"+current_id ).removeClass('active');
        }); 
        jQuery( "#card-"+card_id ).css('display', 'block');
        jQuery( "#box-veiculo-"+card_id ).addClass('active');
        target_card = card_id;
    }

    //noticias
    function runPrevNextNoticia(action=null) {
        index = list_card_noticia.indexOf(target_card_noticia);
        if (action) {
            key = index + 1;    
        } else {
            key = index - 1;    
        }
        if (list_card_noticia[key]) {
            activeCardNoticia(list_card_noticia[key]);
        }
    }
    function activeCardNoticia(card_id) {
        const elements = document.querySelectorAll('.noticia-box'); 
        elements.forEach(element => { 
            current_id = element.getAttribute('id').replace(/[^0-9]/g,'');
            if (Array.isArray(list_card_noticia) && list_card_noticia.indexOf(current_id) == -1) {
                list_card_noticia.push(current_id);
            }
            element.style.display = 'none';
            jQuery( "#box-noticia-"+current_id ).removeClass('active');
        }); 
        jQuery( "#card-"+card_id ).css('display', 'block');
        jQuery( "#box-noticia-"+card_id ).addClass('active');
        target_card_noticia = card_id;
    }
} );

//start - conteudo dinamico na pagina de detalhes do veículo
document.addEventListener('DOMContentLoaded', () => {
    const showOptions = document.querySelector('.show-options');
    const groupSeparator = document.querySelector('.group-separator');

    if (window.matchMedia("(min-width: 1365px)").matches) {
        if (document.querySelector('.content-options ul li:nth-child(1)')) {
            showOptions.style.display = 'flex';
            groupSeparator.style.display = 'none';
        }
    }
});
//and - conteudo dinamico na pagina de detalhes do veículo

//verifica se no storage se o modo foi setado
function darkModel() {
    if (!localStorage.getItem("theme") || localStorage.getItem("theme") != 'dark') {
        toggleModel(true);
        localStorage.setItem("theme", 'dark');
    } else {
        toggleModel();
        localStorage.removeItem('theme');
    }
}
//carrega o modo dark, caso tenha sido selecionado antes
function loadModel() {
    if (localStorage.getItem("theme") == 'dark') {
        toggleModel(true);
    } else {
        toggleModel();
    }
}
//adiciona/remove a class dark no html
function toggleModel(display = false) {
    const rootDark = document.getElementById("root-dark");
    if (rootDark) {
        if (display) {
            rootDark.classList.add('dark');
        } else {
            rootDark.classList.remove('dark');
        }
    }
}
//função responsavel por executar o carosel slide
function caroselToggleImg(target, img, color=null) {
    jQuery(target).prop("src", img);
    if (color) {
        changeColor(color)
    }
}
function caroselToggleImgCar(target, img) {

    validacaoImagem(jQuery('#imagem_detalhe_' + target + ' > img'));		
    const elements = document.querySelectorAll('.vehicle-details .group-img .img-loop .box-item'); 
    elements.forEach(element => { 
        if (!element.classList.contains('color')) {
            element.classList.add('color');
        }        
    }); 
    jQuery('#'+target).removeClass('color');
}
function changeColor(color) {
    const elements = document.querySelectorAll('.vehicle-details .group-img .img-loop .box-item'); 
    elements.forEach(element => { 
        element.classList.remove('hidden');
    }); 
    jQuery('#'+color).addClass('hidden');
}
function validacaoImagem(imagem) {
    caminhoImagem = imagem.attr('src');
    if (imagem && caminhoImagem && imagem.attr('alt').toLowerCase().includes('youtube')) {
        montaVideoYoutube();
        return;
    }
    loadImage(caminhoImagem);
}

function loadImage(caminhoImagem) {
    if(!caminhoImagem) {
        return;
    }
    // Criar um elemento de imagem com a versão de baixa qualidade
    var imagem = new Image();
    imagem.src = jQuery(location).attr("origin")+'/wp-content/themes/altimus5/assets/images/load_altimus.png';
    imagem.setAttribute('class', 'animate-pulse');

    // Adicionar a imagem ao contêiner
    var imagemContainer = document.getElementById('img-destaque');
    if (imagemContainer) {        
        imagemContainer.querySelectorAll('*').forEach(n => n.remove());
        imagemContainer.appendChild(imagem);
        // Adicionar um evento para carregar a imagem de alta qualidade após o carregamento da página
        imagem.onload = function() {
            // Criar uma nova imagem com a versão de alta qualidade
            var imagemAltaQualidade = new Image();
            
            // Adicionar tratamento de erro para a imagem de alta qualidade
            imagemAltaQualidade.onerror = function() {
                this.onerror = null;
                this.src = "https://cdn-wp-altimus.s3-sa-east-1.amazonaws.com/imagens/veiculo-sem-foto.jpg";
                this.alt = "Imagem padrão do veículo";
            };
            
            // Substituir a imagem de baixa qualidade pela de alta qualidade após o carregamento completo
            imagemAltaQualidade.onload = function() {
                // Substituir a imagem de baixa qualidade pela de alta qualidade
                imagemContainer.replaceChild(imagemAltaQualidade, imagem);
            };
            
            imagemAltaQualidade.src = caminhoImagem; // Define o src após configurar os handlers
        };
    }
}

function montaVideoYoutube() {
    const containerDestaque = document.getElementById('img-destaque');
    const containerYoutube = document.querySelector(".caixa-youtube");

    if (!containerYoutube) {
        return;
    }
    containerDestaque.innerHTML = containerYoutube.innerHTML;
}

function displayBoxInfo(option){
    if (option) {
        jQuery('.dynamic-content-box').removeClass('hidden');    
    } else {
        jQuery('.dynamic-content-box').addClass('hidden');    
    }
    
}

/**
 * Verifica se uma imagem existe em uma URL
 * @param {string} url - URL da imagem a ser verificada
 * @returns {Promise<boolean>} - Promise que resolve para true se a imagem existir, false caso contrário
 */
function imagemExiste(url) {
    return new Promise((resolve) => {
        if (!url) {
            resolve(false);
            return;
        }
        
        const img = new Image();
        
        img.onload = function() {
            resolve(true);
        };
        
        img.onerror = function() {
            resolve(false);
        };
        
        img.src = url;
    });
}