(function ($) {
    function SliderModule(config) {
        // Configurações padrão
        var settings = $.extend({
            cardContainer: '.card-box',
            slideItemClass: '.slide-item',
            slidePrevClass: '.slide-prev',
            slideNextClass: '.slide-next',
            activeClass: 'active',
            imageTargetPrefix: '#img-target-',
            itemsVisible: [1, 2, 3, 4]  // Padrão: 1 item para mobile, 2 para tablet, 3 para desktop, 4 para widescreen
        }, config);

        // Variáveis de estado
        var target_img = [];
        var target_card;
        var list_card = [];
        var currentIndex = 0;  // Índice inicial do slide
        var items = $(settings.cardContainer).find(settings.slideItemClass);  // Itens do slide
        var totalItems = items.length;  // Total de itens do slide

        // Inicializa o slider
        function init() {
            setupSlider();
            setupEvents();
            updateVisibleItems();  // Atualiza os itens visíveis inicialmente
            $(window).resize(onResize);  // Atualiza a quantidade de itens visíveis ao redimensionar a janela
        }

        function setupSlider() {
            $(settings.cardContainer).first().attr('style', 'display:block');
            if ($(settings.cardContainer).first().attr("id")) {
                var first_card = $(settings.cardContainer).first().attr("id").replace(/[^0-9]/g, '');
                target_card = first_card;
                list_card = [first_card];
                activeCard(first_card);
            }
        }

        function setupEvents() {
            $(settings.slideItemClass).on("click", handleSlideItemClick);
            $(settings.slidePrevClass).on("click", handleSlidePrevClick);
            $(settings.slideNextClass).on("click", handleSlideNextClick);
        }

        function handleSlideItemClick() {
            var post_id = $(this).attr("id").replace(/[^0-9]/g, '');
            var img_default = settings.imageTargetPrefix + post_id;
            var img_toggle = $(this).children("input");
            var img_url = img_toggle.attr("value");
            var img_id = img_toggle.attr("id");
            target_img[post_id] = img_id;
            activeIcon(img_id);
            caroselToggleImg(img_default, img_url);
        }

        function handleSlidePrevClick() {
            var post_id = $(this).attr("id").replace(/[^0-9]/g, '');
            navigateCarousel(post_id, 'prev');
        }

        function handleSlideNextClick() {
            var post_id = $(this).attr("id").replace(/[^0-9]/g, '');
            navigateCarousel(post_id, 'next');
        }

        function navigateCarousel(post_id, direction) {
            var target = settings.imageTargetPrefix + post_id;
            var id = target_img[post_id];
            var moved = caroselMoveTo(post_id, target, id, direction);
            if (moved) {
                target_img[post_id] = moved;
                activeIcon(moved);
            }
        }

        function activeIcon(img_id) {
            var ids = img_id.split("-");
            var itemSelector = settings.cardContainer + '-' + ids[0];
            const elements = document.querySelectorAll(itemSelector);
            elements.forEach(element => {
                element.classList.remove(settings.activeClass);
            });
            $('#' + img_id).parent().addClass(settings.activeClass);
        }

        function activeCard(card_id) {
            const elements = document.querySelectorAll(settings.cardContainer);
            elements.forEach(element => {
                var current_id = element.getAttribute('id').replace(/[^0-9]/g, '');
                if (Array.isArray(list_card) && list_card.indexOf(current_id) == -1) {
                    list_card.push(current_id);
                }
                element.style.display = 'none';
                $("#box-" + current_id).removeClass(settings.activeClass);
            });
            $("#card-" + card_id).css('display', 'block');
            $("#box-" + card_id).addClass(settings.activeClass);
            target_card = card_id;
        }

        function caroselMoveTo(post_id, target, id, action) {
            var new_id = undefined;
            var new_img = undefined;
            if (id != undefined && action == 'prev') {
                var split_id = id.split('-', 2);

                if (split_id[1] > 0) {
                    var prev = parseInt(split_id[1]) - 1;
                    new_id = split_id[0] + '-' + prev;
                    new_img = $("#" + new_id).attr("value");
                }
            }
            if (id == undefined && action == 'next') {
                new_id = post_id + '-' + 1;
                new_img = $("#" + new_id).attr("value");
            } else if (action == 'next') {
                var split_id = id.split('-', 2);
                var next = parseInt(split_id[1]) + 1;
                new_id = split_id[0] + '-' + next;
                new_img = $("#" + new_id).attr("value");
            }
            if (new_id != undefined && new_img != undefined) {
                $("#line-" + new_id).addClass(settings.activeClass);
                caroselToggleImg(target, new_img);
                return new_id;
            }
        }

        function caroselToggleImg(target, img) {
            $(target).prop("src", img);
        }

        // Função para obter o número de itens visíveis com base na largura da tela
        function getVisibleItemsCount() {
            var screenWidth = $(window).width();
            var visibleItems = settings.itemsVisible;

            if (Array.isArray(settings.itemsVisible)) {
                switch (settings.itemsVisible.length) {
                    case 1:
                        visibleItems = [settings.itemsVisible[0], settings.itemsVisible[0], settings.itemsVisible[0], settings.itemsVisible[0]];
                        break;
                    case 2:
                        visibleItems = [settings.itemsVisible[0], settings.itemsVisible[0], settings.itemsVisible[1], settings.itemsVisible[1]];
                        break;
                    case 3:
                        visibleItems = [settings.itemsVisible[0], settings.itemsVisible[1], settings.itemsVisible[2], settings.itemsVisible[2]];
                        break;
                    case 4:
                        visibleItems = settings.itemsVisible;
                        break;
                    default:
                        visibleItems = [1, 2, 3, 4];  // Configuração padrão se não definido corretamente
                }
            }

            if (screenWidth <= 390) {
                return visibleItems[0];  // Mobile
            } else if (screenWidth <= 768) {
                return visibleItems[1];  // Tablet
            } else if (screenWidth <= 1366) {
                return visibleItems[2];  // Desktop
            } else {
                return visibleItems[3];  // Widescreen
            }
        }

        // Função para atualizar os itens visíveis com base no índice atual e na quantidade de itens visíveis
        function updateVisibleItems() {
            var itemsVisibleCount = getVisibleItemsCount();  // Calcula a quantidade de itens visíveis
            items.removeClass(settings.activeClass);  // Remove a classe ativa de todos os itens

            for (var i = currentIndex; i < currentIndex + itemsVisibleCount; i++) {
                $(items[i % totalItems]).addClass(settings.activeClass);  // Adiciona a classe ativa aos itens visíveis
            }
        }

        // Função para ajustar a quantidade de itens visíveis ao redimensionar a janela
        function onResize() {
            updateVisibleItems();
        }

        // Expor a função init para ser chamada na inicialização
        return {
            init: init
        };
    }

    // Expor o módulo para o escopo global
    window.SliderModule = SliderModule;

})(jQuery);
