<?php
if (!function_exists('alt_get_theme')) {

    function alt_get_theme()
    {
        $theme_selected = 1;
        $theme = wp_get_theme();
        if ($theme->get('TextDomain') == 'altimus-2') {
            $theme_selected = 2;
        };


        return $theme_selected;
    }
}

if (!function_exists('alt_get_total_visualizacoes_numero')) {
    function alt_get_total_visualizacoes_numero($veiculo_id)
    {

        $str_data = get_post_meta($veiculo_id, 'post_views_count', true);
        return $str_data;
    }
}


if (!function_exists('alt_get_total_visualizacoes')) {
    function alt_get_total_visualizacoes($veiculo_id)
    {

        $str_data = alt_get_total_visualizacoes_numero($veiculo_id);
        if ($str_data > 10) {
            return "Esse veículo já recebeu <strong>{$str_data} visualizações </strong>de pessoas interessadas<br/>Aproveite agora mesmo! ";
        }
    }
}


if (!function_exists('alt_get_depoimentos')) {
    function alt_get_depoimentos()
    {
        $args = array(
            'post_type' => 'depoimentos',
            'post_status' => array('publish')
        );
        $query = new WP_Query($args);

        $arrDepoimentos = $query->posts;
        $arrReturn = [];

        foreach ($arrDepoimentos as $objDepoimento) {


            $data['nome'] = $objDepoimento->post_title;
            $url = get_the_post_thumbnail_url($objDepoimento->ID, 'alt-depoimentos');
            if (empty($url)) {
                $url = 'http://via.placeholder.com/70x70';
            }

            $data['cargo'] = get_post_meta($objDepoimento->ID, 'cargo', true) ?? null;
            $data['foto'] = $url;
            $data['content'] = mb_strimwidth($objDepoimento->post_content, 0, 270, '...');
            $arrReturn[] = $data;
        }


        return $arrReturn;
    }
}

if (!function_exists('alt_lista_marcas_padrao')) {
    function alt_lista_marcas_padrao($string = null)
    {


        $arrReturn[0]['nome'] = 'Volkswagen';
        $arrReturn[0]['slug'] = 'volkswagen';
        $arrReturn[0]['url_destino'] = '/estoque/?marca=volkswagen';
        $arrReturn[0]['imagem'] = 'https://cdn-wp-altimus.s3-sa-east-1.amazonaws.com/imagens/marcas/volkswagen-140x90.png';


        $arrReturn[1]['nome'] = 'Chevrolet';
        $arrReturn[1]['slug'] = 'chevrolet';
        $arrReturn[1]['url_destino'] = '/estoque/?marca=chevrolet';
        $arrReturn[1]['imagem'] = 'https://cdn-wp-altimus.s3-sa-east-1.amazonaws.com/imagens/marcas/chevrolet-140x90.png';

        $arrReturn[2]['nome'] = 'Fiat';
        $arrReturn[2]['slug'] = 'fiat';
        $arrReturn[2]['url_destino'] = '/estoque/?marca=fiat';
        $arrReturn[2]['imagem'] = 'https://cdn-wp-altimus.s3-sa-east-1.amazonaws.com/imagens/marcas/fiat-140x90.png';

        $arrReturn[3]['nome'] = 'Ford';
        $arrReturn[3]['slug'] = 'ford';
        $arrReturn[3]['url_destino'] = '/estoque/?marca=ford';
        $arrReturn[3]['imagem'] = 'https://cdn-wp-altimus.s3-sa-east-1.amazonaws.com/imagens/marcas/ford-140x90.png';

        $arrReturn[4]['nome'] = 'Renault';
        $arrReturn[4]['slug'] = 'renault';
        $arrReturn[4]['url_destino'] = '/estoque/?marca=renault';
        $arrReturn[4]['imagem'] = 'https://cdn-wp-altimus.s3-sa-east-1.amazonaws.com/imagens/marcas/renault-140x90.png';

        $arrReturn[5]['nome'] = 'Honda';
        $arrReturn[5]['slug'] = 'honda';
        $arrReturn[5]['url_destino'] = '/estoque/?marca=honda';
        $arrReturn[5]['imagem'] = 'https://cdn-wp-altimus.s3-sa-east-1.amazonaws.com/imagens/marcas/honda-140x90.png';

        $arrReturn[6]['nome'] = 'Hyundai';
        $arrReturn[6]['slug'] = 'hyundai';
        $arrReturn[6]['url_destino'] = '/estoque/?marca=hyundai';
        $arrReturn[6]['imagem'] = 'https://cdn-wp-altimus.s3-sa-east-1.amazonaws.com/imagens/marcas/hyundai-140x90.png';

        $arrReturn[7]['nome'] = 'Ducati';
        $arrReturn[7]['slug'] = 'ducati';
        $arrReturn[7]['url_destino'] = '/estoque/?marca=ducati';
        $arrReturn[7]['imagem'] = 'https://cdn-wp-altimus.s3-sa-east-1.amazonaws.com/imagens/marcas/ducati-140x90.png';

        $arrReturn[8]['nome'] = 'Ferrari';
        $arrReturn[8]['slug'] = 'ferrari';
        $arrReturn[8]['url_destino'] = '/estoque/?marca=ferrari';
        $arrReturn[8]['imagem'] = 'https://cdn-wp-altimus.s3-sa-east-1.amazonaws.com/imagens/marcas/ferrari-140x90.png';

        $arrReturn[9]['nome'] = 'Haojue';
        $arrReturn[9]['slug'] = 'haojue';
        $arrReturn[9]['url_destino'] = '/estoque/?marca=haojue';
        $arrReturn[9]['imagem'] = 'https://cdn-wp-altimus.s3-sa-east-1.amazonaws.com/imagens/marcas/haojue-140x90.png';

        $arrReturn[10]['nome'] = 'Harley Davidson';
        $arrReturn[10]['slug'] = 'harley davidson';
        $arrReturn[10]['url_destino'] = '/estoque/?marca=harleydavidson';
        $arrReturn[10]['imagem'] = 'https://cdn-wp-altimus.s3-sa-east-1.amazonaws.com/imagens/marcas/harleydavidson-140x90.png';

        $arrReturn[11]['nome'] = 'JAC';
        $arrReturn[11]['slug'] = 'jac';
        $arrReturn[11]['url_destino'] = '/estoque/?marca=jac';
        $arrReturn[11]['imagem'] = 'https://cdn-wp-altimus.s3-sa-east-1.amazonaws.com/imagens/marcas/jac-140x90.png';

        $arrReturn[12]['nome'] = 'Jaguar';
        $arrReturn[12]['slug'] = 'jaguar';
        $arrReturn[12]['url_destino'] = '/estoque/?marca=jaguar';
        $arrReturn[12]['imagem'] = 'https://cdn-wp-altimus.s3-sa-east-1.amazonaws.com/imagens/marcas/jaguar-140x90.png';

        $arrReturn[13]['nome'] = 'Jeep';
        $arrReturn[13]['slug'] = 'jeep';
        $arrReturn[13]['url_destino'] = '/estoque/?marca=jeep';
        $arrReturn[13]['imagem'] = 'https://cdn-wp-altimus.s3-sa-east-1.amazonaws.com/imagens/marcas/jeep-140x90.png';

        $arrReturn[14]['nome'] = 'Kasinski';
        $arrReturn[14]['slug'] = 'kasinski';
        $arrReturn[14]['url_destino'] = '/estoque/?marca=kasinski';
        $arrReturn[14]['imagem'] = 'https://cdn-wp-altimus.s3-sa-east-1.amazonaws.com/imagens/marcas/kasinski-140x90.png';

        $arrReturn[15]['nome'] = 'Kia';
        $arrReturn[15]['slug'] = 'kia';
        $arrReturn[15]['url_destino'] = '/estoque/?marca=kia';
        $arrReturn[15]['imagem'] = 'https://cdn-wp-altimus.s3-sa-east-1.amazonaws.com/imagens/marcas/kia-140x90.png';

        $arrReturn[16]['nome'] = 'Ktm';
        $arrReturn[16]['slug'] = 'ktm';
        $arrReturn[16]['url_destino'] = '/estoque/?marca=ktm';
        $arrReturn[16]['imagem'] = 'https://cdn-wp-altimus.s3-sa-east-1.amazonaws.com/imagens/marcas/ktm-140x90.png';

        $arrReturn[17]['nome'] = 'Kymco';
        $arrReturn[17]['slug'] = 'kymco';
        $arrReturn[17]['url_destino'] = '/estoque/?marca=kymco';
        $arrReturn[17]['imagem'] = 'https://cdn-wp-altimus.s3-sa-east-1.amazonaws.com/imagens/marcas/kymco-140x90.png';

        $arrReturn[18]['nome'] = 'Lamborghini';
        $arrReturn[18]['slug'] = 'lamborghini';
        $arrReturn[18]['url_destino'] = '/estoque/?marca=lamborghini';
        $arrReturn[18]['imagem'] = 'https://cdn-wp-altimus.s3-sa-east-1.amazonaws.com/imagens/marcas/lamborghini-140x90.png';

        $arrReturn[19]['nome'] = 'Landrover';
        $arrReturn[19]['slug'] = 'landrover';
        $arrReturn[19]['url_destino'] = '/estoque/?marca=landrover';
        $arrReturn[19]['imagem'] = 'https://cdn-wp-altimus.s3-sa-east-1.amazonaws.com/imagens/marcas/landrover-140x90.png';

        $arrReturn[20]['nome'] = 'Lexus';
        $arrReturn[20]['slug'] = 'lexus';
        $arrReturn[20]['url_destino'] = '/estoque/?marca=lexus';
        $arrReturn[20]['imagem'] = 'https://cdn-wp-altimus.s3-sa-east-1.amazonaws.com/imagens/marcas/lexus-140x90.png';

        $arrReturn[21]['nome'] = 'Mclaren';
        $arrReturn[21]['slug'] = 'mclaren';
        $arrReturn[21]['url_destino'] = '/estoque/?marca=mclaren';
        $arrReturn[21]['imagem'] = 'https://cdn-wp-altimus.s3-sa-east-1.amazonaws.com/imagens/marcas/mclaren-140x90.png';

        $arrReturn[22]['nome'] = 'Mercedes Benz';
        $arrReturn[22]['slug'] = 'mercedes benz';
        $arrReturn[22]['url_destino'] = '/estoque/?marca=mercedesbenz';
        $arrReturn[22]['imagem'] = 'https://cdn-wp-altimus.s3-sa-east-1.amazonaws.com/imagens/marcas/mercedesbenz-140x90.png';

        $arrReturn[23]['nome'] = 'Mini';
        $arrReturn[23]['slug'] = 'mini';
        $arrReturn[23]['url_destino'] = '/estoque/?marca=mini';
        $arrReturn[23]['imagem'] = 'https://cdn-wp-altimus.s3-sa-east-1.amazonaws.com/imagens/marcas/mini-140x90.png';

        $arrReturn[24]['nome'] = 'Mitsubishi';
        $arrReturn[24]['slug'] = 'mitsubishi';
        $arrReturn[24]['url_destino'] = '/estoque/?marca=mitsubishi';
        $arrReturn[24]['imagem'] = 'https://cdn-wp-altimus.s3-sa-east-1.amazonaws.com/imagens/marcas/mitsubishi-140x90.png';

        $arrReturn[25]['nome'] = 'Nissan';
        $arrReturn[25]['slug'] = 'nissan';
        $arrReturn[25]['url_destino'] = '/estoque/?marca=nissan';
        $arrReturn[25]['imagem'] = 'https://cdn-wp-altimus.s3-sa-east-1.amazonaws.com/imagens/marcas/nissan-140x90.png';

        $arrReturn[26]['nome'] = 'Peugeot';
        $arrReturn[26]['slug'] = 'peugeot';
        $arrReturn[26]['url_destino'] = '/estoque/?marca=peugeot';
        $arrReturn[26]['imagem'] = 'https://cdn-wp-altimus.s3-sa-east-1.amazonaws.com/imagens/marcas/peugeot-140x90.png';

        $arrReturn[27]['nome'] = 'Porsche';
        $arrReturn[27]['slug'] = 'porsche';
        $arrReturn[27]['url_destino'] = '/estoque/?marca=porsche';
        $arrReturn[27]['imagem'] = 'https://cdn-wp-altimus.s3-sa-east-1.amazonaws.com/imagens/marcas/porsche-140x90.png';

        $arrReturn[28]['nome'] = 'Rollsroyce';
        $arrReturn[28]['slug'] = 'rollsroyce';
        $arrReturn[28]['url_destino'] = '/estoque/?marca=rollsroyce';
        $arrReturn[28]['imagem'] = 'https://cdn-wp-altimus.s3-sa-east-1.amazonaws.com/imagens/marcas/rollsroyce-140x90.png';

        $arrReturn[29]['nome'] = 'Shineray';
        $arrReturn[29]['slug'] = 'shineray';
        $arrReturn[29]['url_destino'] = '/estoque/?marca=shineray';
        $arrReturn[29]['imagem'] = 'https://cdn-wp-altimus.s3-sa-east-1.amazonaws.com/imagens/marcas/shineray-140x90.png';

        $arrReturn[30]['nome'] = 'Ssangyong';
        $arrReturn[30]['slug'] = 'ssangyong';
        $arrReturn[30]['url_destino'] = '/estoque/?marca=ssangyong';
        $arrReturn[30]['imagem'] = 'https://cdn-wp-altimus.s3-sa-east-1.amazonaws.com/imagens/marcas/ssangyong-140x90.png';

        $arrReturn[31]['nome'] = 'Subaru';
        $arrReturn[31]['slug'] = 'subaru';
        $arrReturn[31]['url_destino'] = '/estoque/?marca=subaru';
        $arrReturn[31]['imagem'] = 'https://cdn-wp-altimus.s3-sa-east-1.amazonaws.com/imagens/marcas/subaru-140x90.png';

        $arrReturn[32]['nome'] = 'Suzuki';
        $arrReturn[32]['slug'] = 'suzuki';
        $arrReturn[32]['url_destino'] = '/estoque/?marca=suzuki';
        $arrReturn[32]['imagem'] = 'https://cdn-wp-altimus.s3-sa-east-1.amazonaws.com/imagens/marcas/suzuki-140x90.png';

        $arrReturn[33]['nome'] = 'Toyota';
        $arrReturn[33]['slug'] = 'toyota';
        $arrReturn[33]['url_destino'] = '/estoque/?marca=toyota';
        $arrReturn[33]['imagem'] = 'https://cdn-wp-altimus.s3-sa-east-1.amazonaws.com/imagens/marcas/toyota-140x90.png';

        $arrReturn[34]['nome'] = 'Triumph';
        $arrReturn[34]['slug'] = 'triumph';
        $arrReturn[34]['url_destino'] = '/estoque/?marca=triumph';
        $arrReturn[34]['imagem'] = 'https://cdn-wp-altimus.s3-sa-east-1.amazonaws.com/imagens/marcas/triumph-140x90.png';

        $arrReturn[35]['nome'] = 'Troller';
        $arrReturn[35]['slug'] = 'troller';
        $arrReturn[35]['url_destino'] = '/estoque/?marca=troller';
        $arrReturn[35]['imagem'] = 'https://cdn-wp-altimus.s3-sa-east-1.amazonaws.com/imagens/marcas/troller-140x90.png';

        $arrReturn[36]['nome'] = 'Volvo';
        $arrReturn[36]['slug'] = 'volvo';
        $arrReturn[36]['url_destino'] = '/estoque/?marca=volvo';
        $arrReturn[36]['imagem'] = 'https://cdn-wp-altimus.s3-sa-east-1.amazonaws.com/imagens/marcas/volvo-140x90.png';

        $arrReturn[37]['nome'] = 'Yamaha';
        $arrReturn[37]['slug'] = 'yamaha';
        $arrReturn[37]['url_destino'] = '/estoque/?marca=yamaha';
        $arrReturn[37]['imagem'] = 'https://cdn-wp-altimus.s3-sa-east-1.amazonaws.com/imagens/marcas/yamaha-140x90.png';


        $arrReturn[38]['nome'] = 'BMW';
        $arrReturn[38]['slug'] = 'bmw';
        $arrReturn[38]['url_destino'] = '/estoque/?marca=bmw';
        $arrReturn[38]['imagem'] = 'https://cdn-wp-altimus.s3-sa-east-1.amazonaws.com/imagens/marcas/bmw-140x90.png';

        $arrReturn[39]['nome'] = 'Citroëm';
        $arrReturn[39]['slug'] = 'citroen';
        $arrReturn[39]['url_destino'] = '/estoque/?marca=citroem';
        $arrReturn[39]['imagem'] = 'https://cdn-wp-altimus.s3-sa-east-1.amazonaws.com/imagens/marcas/citroen-140x90.png';


        $arrReturn[40]['nome'] = 'Mercedes-Benz';
        $arrReturn[40]['slug'] = 'mercedes-benz';
        $arrReturn[40]['url_destino'] = '/estoque/?marca=mercedes-benz';
        $arrReturn[40]['imagem'] = 'https://cdn-wp-altimus.s3-sa-east-1.amazonaws.com/imagens/marcas/mercedesbenz-140x90.png';

        $arrReturn[41]['nome'] = 'Honda';
        $arrReturn[41]['slug'] = 'honda-motos';
        $arrReturn[41]['url_destino'] = '/estoque/?marca=honda';
        $arrReturn[41]['imagem'] = 'https://cdn-wp-altimus.s3-sa-east-1.amazonaws.com/imagens/marcas/honda-motos-140x90.png';
        $arrReturn[41]['prefix'] = 'Honda Motos';

        if (empty($string)) {
            return $arrReturn;
        }

        $index = array_search($string, array_column($arrReturn, 'slug'));

        if (empty($index)) {
            return null;
        }


        return $arrReturn[$index];
    }

    //add_action('alt_lista_marcas_padrao','alt_lista_marcas_padrao');
}


if (!function_exists('alt_salvar_imagem_url')) {
    function alt_salvar_imagem_url($url)
    {


        $tmp = download_url($url);

        $file_array = array(
            'name' => basename($url),
            'tmp_name' => $tmp
        );

        /**
         * Check for download errors
         * if there are error unlink the temp file name
         */
        if (is_wp_error($tmp)) {
            @unlink($file_array['tmp_name']);
            return $tmp;
        }

        /**
         * now we can actually use media_handle_sideload
         * we pass it the file array of the file to handle
         * and the post id of the post to attach it to
         * $post_id can be set to '0' to not attach it to any particular post
         */
        $post_id = '0';

        $id = media_handle_sideload($file_array, $post_id);

        /**
         * We don't want to pass something to $id
         * if there were upload errors.
         * So this checks for errors
         */
        if (is_wp_error($id)) {
            @unlink($file_array['tmp_name']);
            return $id;
        }

        /**
         * No we can get the url of the sideloaded file
         * $value now contains the file url in WordPress
         * $id is the attachment id
         */
        $value = wp_get_attachment_url($id);

        //Now you can do something with $value (or $id)

        return $id;
    }
}


if (!function_exists('pr')) {
    function pr($data)
    {
        echo "<pre>";
        print_r($data);
        echo "</pre>";
    }
}

if (!function_exists('alt_mascara')) {
    function alt_mascara($mask, $str)
    {
        $str = str_replace(" ", "", $str);
        for ($i = 0; $i < strlen($str); $i++) {
            $mask[strpos($mask, "#")] = $str[$i];
        }

        $mask = str_replace('#', '', $mask);
        return $mask;
    }
}

if (!function_exists('alt_mascara_fone')) {
    function alt_mascara_fone($fone)
    {
        $fone = preg_replace('/[^0-9]/', '', $fone);
        $number = str_replace(" ", "", $fone);

        if (strlen($number) < 11) {
            $number = alt_mascara("(##) ####-####", $number);
        } else {
            $number = alt_mascara("(##) #####-####", $number);
        }
        return $number;
    }
}

if (!function_exists('alt_insert_attachment_from_url')) {
    function alt_insert_attachment_from_url($url, $parent_post_id = null)
    {

        if (!class_exists('WP_Http'))
            include_once(ABSPATH . WPINC . '/class-http.php');

        $http = new WP_Http();
        $response = $http->request($url);
        if ($response['response']['code'] != 200) {
            return false;
        }

        $upload = wp_upload_bits(basename($url), null, $response['body']);
        if (!empty($upload['error'])) {
            return false;
        }

        $file_path = $upload['file'];
        $file_name = basename($file_path);
        $file_type = wp_check_filetype($file_name, null);
        $attachment_title = sanitize_file_name(pathinfo($file_name, PATHINFO_FILENAME));
        $wp_upload_dir = wp_upload_dir();

        $post_info = array(
            'guid' => $wp_upload_dir['url'] . '/' . $file_name,
            'post_mime_type' => $file_type['type'],
            'post_title' => $attachment_title,
            'post_content' => '',
            'post_status' => 'inherit',
        );

        // Create the attachment
        $attach_id = wp_insert_attachment($post_info, $file_path, $parent_post_id);

        // Include image.php
        require_once(ABSPATH . 'wp-admin/includes/image.php');

        // Define attachment metadata
        $attach_data = wp_generate_attachment_metadata($attach_id, $file_path);

        // Assign metadata to attachment
        wp_update_attachment_metadata($attach_id, $attach_data);

        return $attach_id;
    }
}

if (!function_exists('alt_get_dados_matriz')) {
    function alt_get_dados_matriz()
    {
        $filiais = alt_get_filiais_matriz();
        return reset($filiais);
    }
}

if (!function_exists('alt_get_info_endereco')) {
    function alt_get_info_endereco()
    {
        $info = alt_get_filiais_matriz();
        if (empty($info)) {
            return '';
        }

        $dados = $info[0];
        $retorno['endereco'] = $dados['endereco_principal'] ?? null;
        $retorno['cidade'] = $dados['cidade_principal'] ?? null;
        $retorno['estado'] = $dados['estado_principal'] ?? null;

        $retorno['endereco_completo'] = $retorno['endereco'] . ' - ' . $retorno['cidade'] . ' - ' . $retorno['estado'];

        return $retorno;
    }
};

if (!function_exists('alt_get_info_telefone')) {
    function alt_get_info_telefone()
    {
        $info = alt_get_filiais_matriz();
        if (empty($info)) {
            return '';
        }

        $dados = $info[0];

        $telefone_principal = $dados['telefone_principal'];
        $telefone_principal = str_replace(['(', ')', '-'], '', $telefone_principal);
        $retorno['telefone'] = $telefone_principal;
        $url_telefone = 'tel:' . $retorno['telefone'];
        $retorno['url_telefone'] = $url_telefone ?? null;

        return $retorno;
    }
};

if (!function_exists('alt_is_current_page')) {
    function alt_is_current_page($paginas)
    {

        $existe = strpos($paginas, 'current');

        if (empty($existe)) {
            return 'page';
        }
        return 'current';
    }
}

/**
 * Função para obter um valor de um array, por uma chave informada.
 * Se não for um array, se não for vazio e a chave não existir no array, retorna o valor informado ou uma string vazia.
 *
 * @param string $chave A chave a ser procurada no array.
 * @param array $array O array a ser pesquisado.
 * @param mixed|null $output O valor a ser retornado se a chave não existir no array.
 *
 * @return mixed O valor encontrado no array, ou o valor informado em $output, ou uma string vazia.
 */
if (!function_exists('alt_validar_chave')) {
    function alt_validar_chave($chave, $array, $output = null)
    {
        if (is_array($array) && !empty($array) && array_key_exists($chave, $array)) {
            return $array[$chave];
        }
        if ($output) {
            return $output;
        }
        return '';
    }
}

/**
 * Função que retorna a página pelo título
 *
 * @param string $title Título da página
 *
 * @return WP_Post|null Página encontrada ou null
 */
if (!function_exists('alt_get_page')) {
    function alt_get_page($title)
    {
        global $wpdb;

        $sql = $wpdb->prepare(
            "SELECT ID
			FROM $wpdb->posts
			WHERE post_title = %s
			AND post_type = 'page'",
            $title
        );

        $page = $wpdb->get_var($sql);

        if ($page) {
            return get_post($page);
        }

        return null;
    }
}


/**
 * Formata o valor passado com o padr o brasileiro.
 *
 * @param mixed $valor Valor a ser formatado.
 * @return string Valor formatado.
 */
if (!function_exists('alt_formatar_valor')) {
    function alt_formatar_valor($valor)
    {
        if (is_numeric($valor)) {
            return number_format($valor, '0', ',', '.');
        }
        return 0;
    }
}


/**
 * Retorna o nome do site inserido na configuração do tema
 *
 * @return string
 */
if (!function_exists('alt_get_title_site')) {
    function alt_get_title_site()
    {
        $data = get_option('alt_group_setup');
        return $data['nome_seo'] ?? get_bloginfo('name');
    }
}



if (!function_exists('alt_get_site_cliente')) {
    function alt_get_site_cliente($id_veiculo)
    {
        if (alt_is_portal() && alt_get_portal_destinatario() == 'lojas') {
            $veiculo = get_post($id_veiculo);

            $loja = alt_get_loja_veiculo($veiculo->post_author);
            $site_cliente = set_url_scheme($loja['url']);
        } else {
            $site_cliente =  get_home_url();
        }
        return $site_cliente;
    }
}

if (!function_exists('alt_formatar_url')) {
    function alt_formatar_url($url)
    {
        if (! preg_match('/^https?:\/\//', $url)) {
            if (is_ssl()) {
                $url = 'https://' . ltrim($url, '/');
            } else {
                $url = 'http://' . ltrim($url, '/');
            }
        }
        return apply_filters('alt_formatar_url', $url);
    }
}

function alt_get_post_by_guid($guid)
{
    global $wpdb;

    $post = $wpdb->get_row(
        $wpdb->prepare(
            "SELECT * FROM {$wpdb->posts} WHERE guid = %s LIMIT 1",
            $guid
        )
    );

    return $post ? get_post($post) : null; // Retorna o objeto WP_Post ou null se não encontrar
}

if (!function_exists('alt_get_motor_potencia_meta')) {
    function alt_get_motor_potencia_meta($post_id)
    {
        global $wpdb;

        $meta_key_prefix = 'motor_potencia_';
        $results = $wpdb->get_results(
            $wpdb->prepare(
                "SELECT meta_value FROM {$wpdb->postmeta} WHERE post_id = %d AND meta_key LIKE %s",
                $post_id,
                $wpdb->esc_like($meta_key_prefix) . '%'
            )
        );

        $values = array();
        if (!empty($results)) {
            foreach ($results as $result) {
                $values[] = $result->meta_value;
            }
        }

        return $values;
    }
}

/**
 * Validação personalizada para campos de telefone no Contact Form 7
 */
function alt_validar_telefone_cf7($result, $tag)
{
    // Verifica se é um campo de telefone
    $tag_name = $tag['name'];
    $type = $tag['type'];

    // Aplica validação apenas em campos com nome telefone, fone, celular, tel, ou tags com tipo tel
    if (preg_match('/telefone|fone|celular|tel/i', $tag_name) || $type == 'tel' || $type == 'tel*') {
        $value = isset($_POST[$tag_name]) ? trim($_POST[$tag_name]) : '';
        // Verifica se o campo está vazio e é obrigatório
        if ($type == 'tel*' && empty($value)) {
            $result->invalidate($tag, "O telefone é obrigatório.");
            return $result;
        }
        // Se tiver valor, valida o formato
        if (!empty($value)) {
            // Remove caracteres não numéricos para contagem
            $numeros = preg_replace('/[^0-9]/', '', $value);

            // Verifica se tem entre 10 e 11 dígitos (inclui DDD)
            if (strlen($numeros) < 10 || strlen($numeros) > 11) {
                $result->invalidate($tag, "Por favor, informe um telefone válido com DDD.");
                return $result;
            }

            // Verifica se o formato está correto
            if (!preg_match('/^\(?([0-9]{2})\)?[-. ]?([0-9]{4,5})[-. ]?([0-9]{4})$/', $value)) {
                $result->invalidate($tag, "O formato do telefone deve ser (XX) XXXX-XXXX ou (XX) XXXXX-XXXX.");
                return $result;
            }
        }
    }

    return $result;
}
add_filter('wpcf7_validate_tel', 'alt_validar_telefone_cf7', 10, 2);
add_filter('wpcf7_validate_tel*', 'alt_validar_telefone_cf7', 10, 2);
add_filter('wpcf7_validate_text', 'alt_validar_telefone_cf7', 10, 2);
add_filter('wpcf7_validate_text*', 'alt_validar_telefone_cf7', 10, 2);
