<?php

// Criação do papel de usuário user_associacao
function create_user_associacao_role()
{
    // Adiciona o papel associacao com permissões limitadas
    add_role('associacao', 'Associação/Shopping', array(
        'read' => true,                   // Permissão básica para acessar o painel
        'edit_posts' => true,             // Editar posts
        'delete_posts' => true,           // Deletar posts
        'edit_others_posts' => true,      // Editar posts de outros
        'edit_published_posts' => true,   // Editar posts publicados
        'publish_posts' => true,          // Publicar posts
        'read_private_posts' => true,     // Ler posts privados
        'alt_banner' => true,             // Acesso ao menu Banner
        'alt_matriz' => true,             // Acesso ao menu Matriz
    ));
}
add_action('init', 'create_user_associacao_role');

// Criação do papel de usuário user_lojista
function create_user_lojista_role()
{
    // Adiciona o papel lojista com permissões limitadas
    add_role('lojista', 'Lojista', array(
        'read' => true,                   // Permissão básica para acessar o painel        
    ));
}
add_action('init', 'create_user_lojista_role');

// Adiciona capacidades específicas ao papel `associacao`
function add_user_associacao_capabilities()
{
    $role = get_role('associacao');

    if (!$role) {
        $role = add_role('associacao', 'Associação/Shopping', array('read' => true));
    }

    if ($role) {
        $role->add_cap('read');                 // Capacidade básica
        $role->add_cap('edit_posts');           // Editar posts
        $role->add_cap('publish_posts');        // Publicar posts
        $role->add_cap('edit_others_posts');    // Editar posts de outros
        $role->add_cap('edit_published_posts'); // Editar posts publicados
        $role->add_cap('read_private_posts');   // Ler posts privados
        $role->add_cap('alt_portal');           // Acesso ao menu Portal
        $role->add_cap('edit_users');           // Editar usuários
        $role->add_cap('delete_users');         // Deletar usuários
        $role->add_cap('create_users');         // Criar usuários
        $role->add_cap('list_users');           // Listar usuários
        $role->add_cap('remove_users');         // Remover usuários
        $role->add_cap('promote_users');        // Promover usuários
        $role->add_cap('upload_files');         // Permissão para upload
        $role->add_cap('edit_files');           // Permissão para editar mídias
        $role->add_cap('manage_media');         // Permissão para gerenciar mídias
        $role->add_cap('alt_banner');           // Acesso ao menu Banner
        $role->add_cap('alt_matriz');           // Acesso ao menu Matriz
        $role->add_cap('access_usuario_loja'); // Acesso ao menu de usuários da loja
    }
}
add_action('init', 'add_user_associacao_capabilities');

// Adiciona capacidades específicas ao papel `lojista`
function add_user_lojista_capabilities()
{
    $role = get_role('lojista');

    if (!$role) {
        $role = add_role('lojista', 'Lojista', array('read' => true));
    }

    if ($role) {
        $role->add_cap('read');
        $role->add_cap('alt_portal');
        $role->add_cap('edit_users');

        // Adiciona a capacidade para editar posts
        $role->add_cap('edit_posts');
        $role->add_cap('edit_others_posts');
        $role->add_cap('edit_published_posts'); // se necessário

        $role->add_cap('upload_files');
        $role->add_cap('edit_files');
        $role->add_cap('manage_media');
        
        $role->add_cap('access_usuario_loja');
    }
}
add_action('init', 'add_user_lojista_capabilities');

/**
 * Função que remove os menus padrão do WordPress e adiciona menus customizados
 * para usuários com o papel 'associacao'.
 *
 * Essa função remove todos os menus padrão do WordPress e adiciona
 * o menu principal "Portal" com submenus para gerenciar "Agenda", "Gestor",
 * "Lojas" e "Parcerias". Além disso, essa função remove o menu de
 * novo conteúdo e o menu de comentários da barra superior de
 * administra o para usuários com o papel 'associacao', pois essas opções
 * não são necessárias para eles.
 */
function custom_menu_for_user_associacao()
{
    if (current_user_can('associacao')) {
        // Remove todos os menus padrão do WordPress
        // remove_menu_page('index.php');                // Painel
        remove_menu_page('upload.php');               // Mídia
        remove_menu_page('edit-comments.php');        // Comentários
        remove_menu_page('tools.php');                // Ferramentas
        remove_menu_page('edit.php?post_type=page');  // Páginas
        remove_menu_page('edit.php?post_type=depoimentos'); // Páginas de depoimentos
        remove_menu_page('edit.php?post_type=popups'); // Páginas de popups
        remove_menu_page('edit.php?post_type=time'); // Páginas de time
        remove_menu_page('edit.php?post_type=galeria'); // Páginas de galeria
        remove_menu_page('edit.php?post_type=veiculos'); // Páginas de veículos
        remove_menu_page('edit.php?post_type=elementor_library'); // Biblioteca do Elementor
        remove_menu_page('options-general.php');      // Configurações
        remove_menu_page('themes.php');               // Aparência
        remove_menu_page('plugins.php');              // Plugins
        remove_menu_page('templates');              // Plugins
        remove_menu_page('wpcf7');              // Plugins
        remove_menu_page('users.php');                  // Usuarios

        // Cria o menu principal "Portal"
        add_menu_page(
            'Portal', // Título da página
            'Configurações do Portal de Associações', // Título do menu
            'alt_portal', // Capacidade necessária
            'alt_portal', // Slug do menu
            'alt_exibir_pagina_portal', // Função de callback para a página de "Portal"
            'dashicons-admin-site', // Ícone do menu
            998 // Posição no menu
        );

        // Adiciona "Agenda" como submenu de "Portal"
        add_submenu_page(
            'alt_portal', // Slug do menu pai
            'Agenda', // Título da página
            'Agenda', // Título do submenu
            'alt_portal', // Capacidade necessária
            'edit.php?post_type=agenda' // URL para gerenciar parcerias
        );

        // Adiciona "Gestor" como submenu de "Portal"
        add_submenu_page(
            'alt_portal', // Slug do menu pai
            'Gestor', // Título da página
            'Gestor', // Título do submenu
            'alt_portal', // Capacidade necessária
            'edit.php?post_type=gestor' // URL para gerenciar parcerias
        );

        // Adiciona "Parcerias" como submenu de "Portal"
        add_submenu_page(
            'alt_portal', // Slug do menu pai
            'Parcerias', // Título da página
            'Parcerias', // Título do submenu
            'alt_portal', // Capacidade necessária
            'edit.php?post_type=parcerias' // URL para gerenciar parcerias
        );
    }
}
add_action('admin_menu', 'custom_menu_for_user_associacao');

/**
 * Função que remove os menus padrão do WordPress e adiciona menus customizados
 * para usuários com o papel 'lojista'.
 *
 * Essa função remove todos os menus padrão do WordPress e adiciona
 * o menu principal "Portal" com submenus para gerenciar "Agenda", "Gestor",
 * "Lojas" e "Parcerias". Além disso, essa função remove o menu de
 * novo conteúdo e o menu de comentários da barra superior de
 * administra o para usuários com o papel 'lojista', pois essas opções
 * não são necessárias para eles.
 */
function custom_menu_for_user_lojista()
{
    if (current_user_can('lojista')) {
        // Remove todos os menus padrão do WordPress
        remove_menu_page('edit.php');                 // Posts
        remove_menu_page('upload.php');               // Mídia
        remove_menu_page('edit-comments.php');        // Comentários
        remove_menu_page('tools.php');                // Ferramentas
        remove_menu_page('edit.php?post_type=page');  // Páginas
        remove_menu_page('edit.php?post_type=banners'); // Páginas de banners
        remove_menu_page('edit.php?post_type=depoimentos'); // Páginas de depoimentos
        remove_menu_page('edit.php?post_type=popups'); // Páginas de popups
        remove_menu_page('edit.php?post_type=time'); // Páginas de time
        remove_menu_page('edit.php?post_type=filiais'); // Páginas de filiais
        remove_menu_page('edit.php?post_type=galeria'); // Páginas de galeria
        remove_menu_page('edit.php?post_type=veiculos'); // Páginas de veículos
        remove_menu_page('edit.php?post_type=elementor_library'); // Biblioteca do Elementor
        remove_menu_page('users.php');                  // Usuarios
        remove_menu_page('options-general.php');      // Configurações
        remove_menu_page('themes.php');               // Aparência
        remove_menu_page('plugins.php');              // Plugins
        remove_menu_page('templates');              // Plugins
        remove_menu_page('wpcf7');              // Plugins

    }
}
add_action('admin_menu', 'custom_menu_for_user_lojista');

// Remover os mesmos itens da barra superior
/**
 * Função que remove os menus da barra superior de administração
 * para usuários com o papel 'associacao'.
 *
 * Essa função remove o menu de novo conteúdo e o menu de
 * comentários da barra superior de administração para usuários
 * com o papel 'associacao', pois essas op es n o s o necess rias
 * para a associa o.
 */
function custom_admin_bar_for_user_associacao($wp_admin_bar)
{
    if (current_user_can('associacao')) {
        $wp_admin_bar->remove_node('new-content');            // Remove o menu de novo conteúdo
        $wp_admin_bar->remove_node('comments');               // Remove o menu de coment rios
        $wp_admin_bar->remove_node('alt_menu_altimus');               // Remove o menu de configura es do Altimus
        $wp_admin_bar->remove_node('alt_setup_lp');               // Remove o menu de configura es do Altimus
    }
}

add_action('admin_bar_menu', 'custom_admin_bar_for_user_associacao', 999);

// Remover os mesmos itens da barra superior
/**
 * Função que remove os menus da barra superior de administração
 * para usuários com o papel 'lojista'.
 *
 * Essa função remove o menu de novo conteúdo e o menu de
 * comentários da barra superior de administração para usuários
 * com o papel 'lojista', pois essas op es n o s o necess rias
 * para a associa o.
 */
function custom_admin_bar_for_user_lojista($wp_admin_bar)
{
    if (current_user_can('lojista')) {
        $wp_admin_bar->remove_node('new-content');            // Remove o menu de novo conteúdo
        $wp_admin_bar->remove_node('comments');               // Remove o menu de coment rios
        $wp_admin_bar->remove_node('alt_menu_altimus');               // Remove o menu de configura es do Altimus
        $wp_admin_bar->remove_node('alt_setup_lp');               // Remove o menu de configura es do Altimus
    }
}

add_action('admin_bar_menu', 'custom_admin_bar_for_user_lojista', 999);

/**
 * Função que restringe os papéis de usuários que podem ser gerenciados
 * por um usuário com o papel 'associacao'.
 *
 * Essa função é utilizada como um filtro para a função 'editable_roles'
 * e remove todos os papéis de usuários, exceto o 'lojista', da lista de
 * papéis de usuários que podem ser gerenciados por um usuário com o
 * papel 'associacao'.
 *
 * @param array $roles Todas as opções de papéis de usuários.
 *
 * @return array Todas as opções de papéis de usuários, exceto o 'lojista'.
 */
function restrict_user_roles_for_associacao($roles)
{
    if (current_user_can('associacao')) {
        // Permitir apenas o papel 'lojista'
        $allowed_roles = array('lojista');

        // Filtrar os papéis de usuário, mantendo apenas o 'lojista'
        foreach ($roles as $role => $details) {
            if (! in_array($role, $allowed_roles)) {
                unset($roles[$role]);
            }
        }
    }

    return $roles;
}

add_filter('editable_roles', 'restrict_user_roles_for_associacao');

/**
 * Forçar o papel de um novo usuário para 'lojista'
 * quando um usuário com o papel 'associacao' cadastra um novo usuário.
 *
 * @param array $allcaps Todas as capacidades do usuário.
 * @param string $cap A capacidade em questão.
 * @param array $args Argumentos adicionais.
 * @param object $user O objeto do usuário.
 *
 * @return array Todas as capacidades do usuário.
 */
function force_lojista_role_for_associacao($allcaps, $cap, $args, $user)
{
    if ('create_users' === $args[0] && current_user_can('associacao')) {
        $allcaps['create_users'] = true;
        $allcaps['edit_users'] = true;
    }

    return $allcaps;
}
add_filter('user_has_cap', 'force_lojista_role_for_associacao', 10, 4);

/**
 * Função que altera o papel de um novo usuário para 'lojista'
 * quando um usuário com o papel 'associacao' cadastra um novo usuário.
 *
 * @param int $user_id O ID do novo usuário.
 */
function set_new_user_role_to_lojista($user_id)
{
    if (current_user_can('associacao')) {
        $user = new WP_User($user_id);
        $user->set_role('lojista');
    }
}
add_action('user_register', 'set_new_user_role_to_lojista');

/**
 * Oculta o dropdown de papéis na tela de edição de usuários
 * para usuários com o papel 'associacao', pois eles não podem
 * alterar o papel de outros usuários.
 */
function hide_role_dropdown_for_associacao()
{
    if (current_user_can('associacao')) {
?>
        <style>
            .user-role-wrap {
                display: none;
            }
        </style>
    <?php
    }
}
add_action('admin_head', 'hide_role_dropdown_for_associacao');

/**
 * Filtra a lista de usuários para mostrar apenas os usuários do tipo
 * 'lojista' e 'associacao' para o papel 'associacao'.
 *
 * @param WP_User_Query $query A consulta de usuários.
 */
function filter_user_list_for_associacao($query)
{
    // Verifique se o usuário atual tem o papel 'associacao'
    if (get_current_screen()->id === 'users' && current_user_can('associacao')) {
        // Filtrar a consulta para listar apenas usuários do tipo 'lojista' e 'associacao'
        $query->set('role__in', array('lojista', 'associacao'));
        show_lojista_only_notice();
    }
}
add_action('pre_get_users', 'filter_user_list_for_associacao');

/**
 * Mostra uma notificação na tela de listagem de usuários, informando
 * que apenas usuários do tipo Lojista estão sendo exibidos.
 */
function show_lojista_only_notice()
{
    if (current_user_can('associacao') && get_current_screen()->id === 'users') {
        echo '<div class="notice notice-info"><p>Você está vendo apenas usuários do tipo Lojista.</p></div>';
    }
}

/**
 * Filtra a listagem de lojas para mostrar apenas as que pertencem ao lojista logado
 * 
 * @param WP_Query $query A consulta atual
 * @return void
 */
function filter_lojas_for_lojista($query)
{
    // Verifica se é usuário lojista e se está na área administrativa
    if (!is_admin() || !current_user_can('lojista')) {
        return;
    }

    // Verifica se é do post type 'lojas'
    if (isset($query->query['post_type']) && $query->query['post_type'] === 'lojas') {
        $current_user = wp_get_current_user();
        $query->set('author', $current_user->ID);
    }
}
add_action('pre_get_posts', 'filter_lojas_for_lojista');

/**
 * Oculta elementos desnecessários na listagem de lojas para lojistas
 */
function hide_elements_for_lojista()
{
    if (current_user_can('lojista') && isset($_GET['post_type']) && $_GET['post_type'] === 'lojas') {
    ?>
        <style>
            /* Oculta quantidade total de lojas */
            .subsubsub,
            /* Oculta campo de pesquisa */
            .search-box,
            /* Oculta filtros */
            .tablenav.top,
            .tablenav.bottom {
                display: none !important;
            }
        </style>
<?php
    }
}
add_action('admin_head', 'hide_elements_for_lojista');
