<?php

/**
 * Fun o que atualiza o tema e o plugin Altimus
 * Essa fun o   executada automaticamente pelo WordPress
 * a cada 12 horas, verificando se h  uma nova vers o
 * do tema e do plugin Altimus. Se houver, essa fun o
 * ir  atualizar o tema e o plugin.
 */
if (!function_exists('alt_update_full')) {
    add_action('alt_update_full', 'alt_update_full', 10, 2);
    function alt_update_full(){
        $itemDir = get_theme_root();
        $itemLocal = get_template().'/style.css';
        $itemInfo['ThemeURI'] = wp_get_theme()->get('ThemeURI');
        $itemInfo['Version'] = wp_get_theme()->get('Version');
        $tempZipFile = $itemDir . '/' . get_template(). '.zip';                
        alt_update_plugin_theme($itemDir, $itemLocal, $itemInfo, $tempZipFile);  

        $itemDir = WP_PLUGIN_DIR;
        $itemLocal = 'altimus/altimus.php';
        $itemInfo = get_plugin_data($itemDir . '/altimus/altimus.php');
        $tempZipFile = $itemDir . '/altimus.zip';
        alt_update_plugin_theme($itemDir, $itemLocal, $itemInfo, $tempZipFile);  
    }
}

/**
 * Verifica se já está agendado o evento para atualizar o tema e o plugin
 * Altimus. Se não estiver, agendar  o evento para atualizar a cada 12 horas.
 */
add_action('init', 'alt_process_update');
function alt_process_update(){
    if (!wp_next_scheduled('alt_update_full')) {
        wp_schedule_event(time() +1, 'twicedaily', 'alt_update_full');
    }
}

