<?php
/**
 * Função para obter o texto relativo ao tipo de veículo selecionado e retornar o texto correspondente.
 *
 * Esta função percorre uma lista de itens e retorna o item que corresponde a posicão especificada.
 * Se a posição estiver fora do intervalo da lista, a função retornará null.
 *
 * @param string $posicao Nome do elemento ou componente alvo que deve ser exibido.
 * @return string Retorna o texto que deve ser exibido em tela.
 */
if (!function_exists('alt_textos_dinamicos')) {
    function alt_textos_dinamicos($posicao)
    {
        $tipoVeiculo = alt_get_tipo_veiculo() ?? 'altimuscarro';

        $textos = [
            'altimuscarro' => [
                'componente_venda_titulo' => 'Venda seu veículo',
                'componente_venda_btn_texto' => 'Quero vender',
                'componente_simulacao_titulo' => 'Faça uma simulação',
                'componente_simulacao_btn_texto' => 'Simular compra',
                'widget_filtro_busca_titulo' => 'Encontre seu Novo Veículo!',
                'pagina_estoque_filtro_busca_titulo' => 'Filtrar Veículos',
                'pagina_estoque_resultado_bucas' => 'veículos encontrados',
                'pagina_venda_titulo' => 'Quer vender, trocar ou consignar seu veículo?',
                'pagina_simulacao_titulo' => 'Simulação de compra',
            ],
            'altimusmoto' => [
                'componente_venda_titulo' => 'Venda sua moto',
                'componente_venda_btn_texto' => 'Quero vender',
                'componente_simulacao_titulo' => 'Faça uma simulação',
                'componente_simulacao_btn_texto' => 'Simular compra',
                'widget_filtro_busca_titulo' => 'Encontre sua Nova Moto!',
                'pagina_estoque_filtro_busca_titulo' => 'Filtrar Motos',
                'pagina_estoque_resultado_bucas' => 'motos encontradas',
                'pagina_venda_titulo' => 'Quer vender, trocar ou consignar sua moto?',
                'pagina_simulacao_titulo' => 'Simulação de compra',
            ],
            'altimuscaminhao' => [
                'componente_venda_titulo' => 'Venda seu caminhão',
                'componente_venda_btn_texto' => 'Quero vender',
                'componente_simulacao_titulo' => 'Faça uma simulação',
                'componente_simulacao_btn_texto' => 'Simular compra',
                'widget_filtro_busca_titulo' => 'Encontre seu Novo Caminhão!',
                'pagina_estoque_filtro_busca_titulo' => 'Filtrar Caminhões',
                'pagina_estoque_resultado_bucas' => 'caminhões encontrados',
                'pagina_venda_titulo' => 'Quer vender, trocar ou consignar seu caminhão?',
                'pagina_simulacao_titulo' => 'Simulação de compra',
            ],
            'altimusbarco' => [
                'componente_venda_titulo' => 'Venda sua embarcação',
                'componente_venda_btn_texto' => 'Quero vender',
                'componente_simulacao_titulo' => 'Faça uma simulação',
                'componente_simulacao_btn_texto' => 'Simular compra',
                'widget_filtro_busca_titulo' => 'Encontre sua Nova Embarcação!',
                'pagina_estoque_filtro_busca_titulo' => 'Filtrar Embarcações',
                'pagina_estoque_resultado_bucas' => 'embarcações encontradas',
                'pagina_venda_titulo' => 'Quer vender, trocar ou consignar sua embarcação?',
                'pagina_simulacao_titulo' => 'Simulação de compra',
            ],
            'altimusaviao' => [
                'componente_venda_titulo' => 'Venda sua aeronave',
                'componente_venda_btn_texto' => 'Quero vender',
                'componente_simulacao_titulo' => 'Faça uma simulação',
                'componente_simulacao_btn_texto' => 'Simular compra',
                'widget_filtro_busca_titulo' => 'Encontre sua Nova Aeronave!',
                'pagina_estoque_filtro_busca_titulo' => 'Filtrar Aeronaves',
                'pagina_estoque_resultado_bucas' => 'aeronaves encontradas',
                'pagina_venda_titulo' => 'Quer vender, trocar ou consignar sua aeronave?',
                'pagina_simulacao_titulo' => 'Simulação de compra',
            ],
            'altimustrator' => [
                'componente_venda_titulo' => 'Venda seu trator',
                'componente_venda_btn_texto' => 'Quero vender',
                'componente_simulacao_titulo' => 'Faça uma simulação',
                'componente_simulacao_btn_texto' => 'Simular compra',
                'widget_filtro_busca_titulo' => 'Encontre seu Novo Trator!',
                'pagina_estoque_filtro_busca_titulo' => 'Filtrar Tratores',
                'pagina_estoque_resultado_bucas' => 'tratores encontrados',
                'pagina_venda_titulo' => 'Quer vender, trocar ou consignar seu trator?',
                'pagina_simulacao_titulo' => 'Simulação de compra',
            ],
            'altimusdrone' => [
                'componente_venda_titulo' => 'Venda seu drone',
                'componente_venda_btn_texto' => 'Quero vender',
                'componente_simulacao_titulo' => 'Faça uma simulação',
                'componente_simulacao_btn_texto' => 'Simular compra',
                'widget_filtro_busca_titulo' => 'Encontre seu Novo Drone!',
                'pagina_estoque_filtro_busca_titulo' => 'Filtrar Drones',
                'pagina_estoque_resultado_bucas' => 'drones encontrados',
                'pagina_venda_titulo' => 'Quer vender, trocar ou consignar seu drone?',
                'pagina_simulacao_titulo' => 'Simulação de compra',
            ],
        ];


        return $textos[$tipoVeiculo][$posicao] ?? '';
    }
}