<?php

class AltWhatsAppSc
{
    public function __construct()
    {
        $versao = '1';
        $dir = plugins_url('altimus') . '/inc/shortcodes/AltWhatsApp/';


        add_shortcode('alt_whatsapp_sc', array($this, 'alt_whatsapp_sc'));

        $sn_popup = get_show_popup_whatsapp();
        // if ($sn_popup) {
        //     add_action('after_body_open_tag', array($this, 'custom_modal'));
        // }
    }

    public function custom_modal()
    {
        include('modal-template.php');
    }

    public function alt_whatsapp_sc($param)
    {
        $url = $param['url'] ?? null;
        $titulo = $param['title'] ?? null;
        $id = $param['id'] ?? null;
        $modelo = $param['modelo'] ?? 1;
        $local = $param['local'] ?? 'lista';


        $arrDados = get_button_whatsapp_detalhes();


        $telefone = $arrDados['telefone'];
        $mensagem = $arrDados['mensagem'] . ' *' . $titulo . '* ' . $url;
        $texto = $arrDados['texto_botao'] ?? 'Whatsapp';

        //$link = 'https://wa.me/' . $telefone . '?text=' . $mensagem;
        $link = '/wp-json/altimus/v1/whatsapp' . '?text=' . $mensagem;
        $sn_popup = get_show_popup_whatsapp();
    }
}


if (!function_exists('alt_click_whatsapp')) {
    function alt_click_whatsapp()
    {

        do_action('set_click_whatsapp');
        $arrDados = get_button_whatsapp_detalhes();

        $titulo = isset($titulo) ? $titulo : '';
        $url = isset($url) ? $url : '';

        $telefone = $arrDados['telefone'];
        $mensagem = $arrDados['mensagem'] . ' *' . $titulo . '* ' . $url;
        $text = $_GET['text'] ?? $mensagem;


        $veiculo_id = $_GET['veiculo_id'] ?? null;
        if (!empty($veiculo_id)) {
            /**FAZER - Contabilizar click no veiculo especifico**/
        }

        $link = 'https://wa.me/' . $telefone . '?text=' . $text;


        wp_redirect($link, 301);

        wp_send_json(['status' => 'ok']);
    }

    add_action('alt_click_whatsapp', 'alt_click_whatsapp');
}


function alt_whatsapp_float()
{
    $sn_show_whatsapp = get_show_button_whatsapp();

    if ($sn_show_whatsapp) {


        $arrDados = get_button_whatsapp_detalhes();
        $sn_popup = get_show_popup_whatsapp();
        $url = get_permalink();
        $id = url_to_postid($url);
        $titulo = get_the_title($id);
        $mensagem = $arrDados['mensagem'] . ' *' . $titulo . '* ' . $url;
        $url = '/wp-json/altimus/v1/whatsapp' . '?text=' . $mensagem;
        if ($sn_popup) {
            include 'modal-template.php';
        }

        include 'template-botao.php';
    };
}


add_action('after_body_open_tag', 'alt_whatsapp_float');
add_action(
    'rest_api_init',
    function () {
        register_rest_route(
            'altimus/v1',
            'whatsapp',
            array(
                'methods' => 'GET',
                'callback' => 'alt_click_whatsapp',
            )
        );
    }
);
