<?php

add_action('cmb2_admin_init', 'midias_sociais');

function midias_sociais()
{
    $cmb_options = new_cmb2_box(array(
        'id' => 'alt_setup_midias_sociais',
        'title' => 'Midias sociais',
        'object_types' => array('options-page'),
        'option_key' => 'alt_group_midias_sociais', // The option key and admin menu page slug.
        //'icon_url'        => 'dashicons-palmtree', // Menu icon. Only applicable if 'parent_slug' is left empty.
        // 'menu_title'      => esc_html__( 'Options', 'cmb2' ), // Falls back to 'title' (above).
        'parent_slug' => 'alt_group_setup', // Make options page a submenu item of the themes menu.
        // 'capability'      => 'manage_options', // Cap required to view options-page.
        // 'position'        => 1, // Menu position. Only applicable if 'parent_slug' is left empty.
        // 'admin_menu_hook' => 'network_admin_menu', // 'network_admin_menu' to add network-level options page.
        // 'display_cb'      => false, // Override the options-page form output (CMB2_Hookup::options_page_output()).
        // 'save_button'     => esc_html__( 'Save Theme Options', 'cmb2' ), // The text for the options-page save button. Defaults to 'Save'.
        // 'disable_settings_errors' => true, // On settings pages (not options-general.php sub-pages), allows disabling.
        // 'message_cb'      => 'yourprefix_options_page_message_callback',
    ));

    $cmb_options->add_field(array(

        'name' => 'Exibir redes sociais no cabeçalho?',
        'desc' => '',
        'id' => 'exibir_social_cabecalho',
        'type' => 'select',
        'default' => 'sim',
        'options' => array(
            'sim' => 'Sim',
            'nao' => 'Não',
        ),
    ));


    $cmb_options->add_field(array(
        'after_row' => '<br/>',
        'name' => 'Exibir redes sociais no rodape?',
        'desc' => '',
        'id' => 'exibir_social_rodape',
        'type' => 'select',
        'default' => 'sim',
        'options' => array(
            'sim' => 'Sim',
            'nao' => 'Não',
        ),
    ));

    $cmb_options->add_field(array(
        'name' => 'Instagram',
        'desc' => '',
        'id' => 'instagram',
        'type' => 'text_url',
    ));
    $cmb_options->add_field(array(
        'name' => 'Facebook',
        'desc' => '',
        'id' => 'facebook',
        'type' => 'text_url',
    ));
    $cmb_options->add_field(array(
        'name' => 'TikTok',
        'desc' => '',
        'id' => 'tiktok',
        'type' => 'text_url',
    ));
    $cmb_options->add_field(array(
        'name' => 'Twitter',
        'desc' => '',
        'id' => 'twitter',
        'type' => 'text_url',
    ));
    $cmb_options->add_field(array(
        'name' => 'Youtube',
        'desc' => '',
        'id' => 'youtube',
        'type' => 'text_url',
    ));
    $cmb_options->add_field(array(
        'name' => 'Linkedin',
        'desc' => '',
        'id' => 'linkedin',
        'type' => 'text_url',
    ));
}

function get_social_links($tipo)
{
    $arrOptions = get_option('alt_group_midias_sociais');
    if (!empty($arrOptions[$tipo])) {
        return $arrOptions[$tipo];
    }
}

//nova função para buscar as redes sociais
function alt_get_social_links($tipo)
{
    $matriz = alt_get_matriz();
    $arrOptions = get_option('alt_group_midias_sociais');

    if (!empty($matriz[$tipo])) {
        return $matriz[$tipo];
    } elseif (!empty($arrOptions[$tipo])) {
        add_post_meta(
            $matriz['id'],
            'alt_filial_' . $tipo,
            $arrOptions[$tipo],
            true
        );
        return $arrOptions[$tipo];
    }

    return '';
}
