<?php

add_action('cmb2_admin_init', 'setup_listagem');

function setup_listagem()
{
    $theme_selected = 1;
    $theme = wp_get_theme();
    if ($theme->get('TextDomain') == 'altimus-2') {
        $theme_selected = 2;
    };

    $cmb_options = new_cmb2_box(array(
        'id' => 'alt_setup_listagem',
        'title' => 'Configurações Listagem (Estoque)',
        'object_types' => array('options-page'),
        'option_key' => 'alt_group_listagem', // The option key and admin menu page slug.
        'parent_slug' => 'alt_group_setup', // Make options page a submenu item of the themes menu.
    ));

    if ($theme_selected == 2) {

        $menu_layout = array(
            'bloco' => 'Blocos',
            'lista' => 'Lista',
        );
    } else {

        $menu_layout = array(
            'lista' => 'Lista',
            'bloco' => 'Blocos',
            'superior' => 'Filtro superior',
        );
    }

    $cmb_options->add_field(array(
        'before_row' => '<br/><h2>Página Estoque</h2>',
        'name' => 'Layout de exibição <br/>dos veículos',
        'desc' => '',
        'id' => 'layout_estoque',
        'type' => 'select',
        'default' => 'bloco',
        'options' => $menu_layout,
    ));

    $cmb_options->add_field(array(
        'name' => 'Total de veículos a serem exibidos',
        'desc' => '',
        'default' => '15',
        'id' => 'total_lista_estoque',
        'type' => 'text_small',
    ));

    $cmb_options->add_field(array(
        'name' => 'Ordenação <br/>padrão',
        'desc' => '',
        'id' => 'ordenaca_padrao',
        'type' => 'select',
        'default' => 'mais_recentes',
        'options' => array(
            'order_destaque_desc' => 'Ordenar por popularidade',
            'order_preco_desc' => 'Ordenar por preço: Maior para o menor',
            'order_preco_asc' => 'Ordenar por preço: Menor para o maior',
            'order_ano_desc' => 'Ordenar por ano: Maior para o menor',
            'order_ano_asc' => 'Ordenar por ano: Menor para o maior',
            'mais_recentes' => 'Ordenar por: Mais recentes',
        ),
    ));

    $cmb_options->add_field(array(
        'name' => 'Exibir tarjeta de veículos em <strong>Destaque</strong>',
        'desc' => '',
        'id' => 'tarjeta_destaque',
        'type' => 'select',
        'default' => 'sim',
        'options' => array(
            'sim' => 'Sim',
            'nao' => 'Não',
        ),
    ));

    $cmb_options->add_field(array(
        'name' => 'Exibir tarjeta de veículos <strong>Repasse</strong>',
        'desc' => '',
        'id' => 'tarjeta_repasse',
        'type' => 'select',
        'default' => 'sim',
        'options' => array(
            'sim' => 'Sim',
            'nao' => 'Não',
        ),
    ));

    $cmb_options->add_field(array(
        'name' => 'Exibir casas decimais?',
        'desc' => '',
        'id' => 'casas_decimais',
        'type' => 'select',
        'default' => 'nao',
        'options' => array(
            'nao' => 'Não',
            'sim' => 'Sim',
        ),
    ));

    $cmb_options->add_field(array(
        'before_row' => '<br/><h2>Configurações de Busca</h2>',
        'name' => 'Habilitar busca por similaridade',
        'desc' => 'Permite encontrar resultados similares mesmo com pequenos erros de digitação',
        'id' => 'busca_similaridade',
        'type' => 'select',
        'default' => 'nao',
        'options' => array(
            'sim' => 'Sim',
            'nao' => 'Não',
        ),
    ));

    $cmb_options->add_field(array(
        'name' => 'Indexação Manual',
        'desc' => 'Use este botão para reindexar todos os veículos manualmente.',
        'id' => 'indexacao_manual',
        'type' => 'text',
        'attributes' => array(
            'type' => 'hidden',
        ),
        'before_field' => function() {
            $dados = get_option('alt_group_listagem');
            if (isset($dados['busca_similaridade']) && $dados['busca_similaridade'] === 'sim') {
                ?>
                <div class="wrap">
                    <div id="alt-index-notices" class="notice" style="display: none;"></div>
                    <button type="button" id="alt-index-reindexar" class="button button-secondary">
                        Reindexar Veículos
                    </button>
                </div>
                <script>
                jQuery(document).ready(function($) {
                    $("#alt-index-reindexar").on("click", function() {
                        var $button = $(this);
                        var $notices = $("#alt-index-notices");
                        
                        $button.prop("disabled", true);
                        $notices.removeClass().addClass('notice notice-info').html('<p>Reindexando veículos...</p>').show();
                        
                        $.ajax({
                            url: ajaxurl,
                            type: "POST",
                            data: {
                                action: "alt_index_reindexar_ajax",
                                nonce: "<?php echo wp_create_nonce('alt_index_nonce'); ?>"
                            },
                            success: function(response) {
                                if (response.success) {
                                    $notices.removeClass().addClass('notice notice-success').html('<p>' + response.data + '</p>');
                                } else {
                                    $notices.removeClass().addClass('notice notice-error').html('<p>' + response.data + '</p>');
                                }
                                $notices.show();
                                
                                // Scroll para a mensagem
                                $('html, body').animate({
                                    scrollTop: $notices.offset().top - 50
                                }, 500);
                            },
                            error: function() {
                                $notices.removeClass().addClass('notice notice-error')
                                    .html('<p>Erro ao conectar com o servidor</p>')
                                    .show();
                            },
                            complete: function() {
                                $button.prop("disabled", false);
                            }
                        });
                    });
                });
                </script>
                <?php
            }
            return '';
        },
        'show_on_cb' => function() {
            $dados = get_option('alt_group_listagem');
            return isset($dados['busca_similaridade']) && $dados['busca_similaridade'] === 'sim';
        }
    ));

    $cmb_options->add_field(array(
        'name' => 'Habilitar autocomplete na busca',
        'desc' => 'Exibe sugestões de veículos enquanto o usuário digita',
        'id' => 'busca_autocomplete',
        'type' => 'select',
        'default' => 'nao',
        'options' => array(
            'sim' => 'Sim',
            'nao' => 'Não',
        ),
    ));

    $cmb_options->add_field(array(
        'before_row' => '<br/><h2>Widget veículos</h2>',
        'name' => 'Características dos veículos',
        'desc' => '',
        'id' => 'caracteristicas',
        'type' => 'multicheck',
        'default' => array('alt_kilometragem', 'alt_cambio', 'alt_ano_mod', 'alt_combustivel', 'alt_marca'),
        'options' => array(
            'alt_kilometragem' => 'Quilometragem',
            'alt_cambio' => 'Cambio',
            'alt_ano_mod' => 'Ano modelo',
            'alt_combustivel' => 'Combustível',
            'alt_marca' => 'Marca',
            'alt_modelo' => 'Modelo',
            'alt_modelo_complemento' => 'Modelo complemento',
            'alt_ano_fab' => 'Ano fabricação',
            'alt_cor' => 'Cor',
            'alt_portas' => 'Porta',
            'alt_horas' => 'Horas',
            'alt_motorizacao' => 'Motorização',
        ),
    ));
}

function get_caracteristas_widget()
{
    $dados = get_option('alt_group_listagem');

    if (is_array($dados) && isset($dados['caracteristicas'])) {
        return $dados['caracteristicas'];
    }
    
    return [
            'alt_kilometragem', 
            'alt_cambio', 
            'alt_ano_mod', 
            'alt_combustivel', 
            'alt_marca',
            'alt_portas',
            'alt_cor'
        ];      
}

function get_tarjeta_destaque()
{
    $dados = get_option('alt_group_listagem');
    return is_array($dados) && $dados['tarjeta_destaque'] == 'sim' ? true : false;
}

function get_tarjeta_repasse()
{
    $dados = get_option('alt_group_listagem');
    return $dados['tarjeta_repasse'] == 'sim' ? true : false;;
}

function get_casas_decimais()
{
    $dados = get_option('alt_group_listagem');
    if (!is_array($dados)) {
        $dados = [];
    }
    return isset($dados['casas_decimais']) && $dados['casas_decimais'] == 'nao' ? '0' : '2';
}

function get_layout_estoque()
{
    $dados = get_option('alt_group_listagem');
    $retorno = alt_validar_chave('layout_estoque', $dados);

    if (isset($_REQUEST['tipo_block'])) {
        $retorno = $_REQUEST['tipo_block'];
    }

    if (isset($_REQUEST['view'])) {
        $retorno = $_REQUEST['view'];
    }

    if(empty($retorno)){
        return 'block';
    }
    return $retorno;
}

function get_total_veiculo_no_estoque()
{

    $dados = get_option('alt_group_listagem');
    return is_array($dados) ? ($dados['total_lista_estoque'] ?? 15) : 15;
}

function get_ordenacao_padrao()
{
    $dados = get_option('alt_group_listagem');
    return (isset($dados['ordenaca_padrao']) && !empty($dados['ordenaca_padrao'])) ? $dados['ordenaca_padrao'] : 'mais_recentes';
}

/**
 * Verifica se o autocomplete estiver ativo
 * 
 * @return bool
 */
function alt_get_busca_autocomplete() {
    $dados = get_option('alt_group_listagem');
    return isset($dados['autocomplete']) && $dados['autocomplete'] === 'sim';
}

/**
 * Retorna verdadeiro se a busca por similaridade estiver ativa
 * 
 * @return bool
 */
function alt_busca_similaridade_ativada() {
    $dados = get_option('alt_group_listagem');
    if(isset($dados['busca_similaridade']) && $dados['busca_similaridade'] === 'sim'){
        return true;
    }
    return false;
}

