<?php

use Cleantalk\Common\Arr;

add_action('cmb2_admin_init', 'setup');

define("URL_LEADS_PRODUCAO", "https://formularios-sites-clientes.altimus.com.br");
define("URL_LEADS_HOMOLOGACAO", "https://formularios-sites-clientes.altimus.com.br/hml");
define("URL_LEADS_DESENVOLVIMENTO", "https://formularios-sites-clientes.altimus.com.br/dev");
if (!defined('VERSION_PLUGIN_ALTIMUS')) {
    define('VERSION_PLUGIN_ALTIMUS', '2024.0.0.0');
}

function setup()
{
    $versao = 1;


    $cmb_options = new_cmb2_box(array(
        'id' => 'alt_setup',
        'title' => 'Configurações do tema Altimus',
        'object_types' => array('options-page'),
        'option_key' => 'alt_group_setup', // The option key and admin menu page slug.
        'icon_url' => 'dashicons-palmtree', // Menu icon. Only applicable if 'parent_slug' is left empty.

    ));


    $btn_personal = '<a href="/wp-admin/admin-ajax.php?action=criar_paginas_default" class="button button-primary">IMPORTAR DADOS INICIAIS</a>';
    $btn_personal .= '<a href="/wp-admin/admin-ajax.php?action=fotos_nao_usadas" class="button button-danger" style="margin: 0px 0px 20px 20px;">LIMPAR FOTOS</a>';

    $cmb_options->add_field(array(
        'before_row' => $btn_personal,
        'name' => 'Tipo/Tema do site',
        'desc' => '',
        'id' => 'tipo_site',
        'type' => 'select',
        'default' => 'altimussite',
        'options' => array(
            '' => 'Selecionar',
            'altimussite' => 'Site Wordpress',
            'altimusportal' => 'Portal de Associação',
        ),
    ));

    $cmb_options->add_field(array(
        'name' => 'Tipo de veículo',
        'desc' => '',
        'id' => 'tipo_veiculo',
        'type' => 'select',
        'default' => 'altimuscarro',
        'options' => array(
            'altimuscarro' => 'Carro',
            'altimusmoto' => 'Moto',
            'altimuscaminhao' => 'Caminhão',
            'altimusbarco' => 'Barco',
            'altimusaviao' => 'Avião',
            'altimustrator' => 'Trator',
        ),
    ));

    $cmb_options->add_field(array(
        'name' => 'Logo',
        'desc' => 'Faça o upload da imagem ou informe a URL (Tamanho recomendado 153x43)',
        'id' => 'logo',
        'type' => 'file',
        'options' => array(
            'url' => true, // Hide the text input for the url
        ),
        'text' => array(
            'add_upload_file_text' => 'Fazer upload' // Change upload button text. Default: "Add or Upload File"
        ),
        'query_args' => array(
            'type' => array(
                // 	'image/gif',
                'image/jpeg',
                'image/png',
            ),
        ),

    ));

    $cmb_options->add_field(array(

        'name' => 'Nome Loja (SEO)',
        'id' => 'nome_seo',
        'desc' => 'Informe o nome que será adicionado como H1 principal da Home',
        'type' => 'text',
        'default' => '',

    ));

    $cmb_options->add_field(array(

        'name' => 'Cabecalho fixo? (SOMENTE MODELO 5)',
        'id' => 'cabecalho_fixo',
        'desc' => 'Indica se o menu deverá ser fixo no topo do site ou não',
        'type' => 'select',
        'defaut' => 'Não',
        'options' => array(
            'sim' => "Sim",
            'nao' => 'Não',
        )
    ));

    $pages = get_pages();
    $arrPages = [];
    foreach ($pages as $page) {
        $arrPages[$page->post_title] = $page->post_title;
    };

    $cmb_options->add_field(array(
        'name' => 'Página padrão de estoque',
        'desc' => '',
        'id' => 'pagina_padrao_estoque',
        'type' => 'select',
        'default' => 'Estoque',
        'options' => $arrPages,
    ));

    $cmb_options->add_field(array(
        'name' => 'Exibir noticias na home',
        'desc' => '',
        'id' => 'exibir_noticias',
        'type' => 'select',
        'default' => 'nao',
        'options' => array(
            'sim' => 'Sim',
            'nao' => 'Não',
        ),
    ));


    $cmb_options->add_field(array(

        'name' => 'Aviso LGPD',
        'desc' => 'Exibir modal LGPD - ATENÇÃO, ao ativar essa modal é necessário criar uma nova página chamada politica de privacidade<br/>O SLUG deve ser obrigatoriamente <strong>politica-de-privacidade</strong>',
        'id' => 'modal_lgpd',
        'type' => 'select',
        'default' => 'sim',
        'options' => array(
            'sim' => 'Sim',
            'nao' => 'Não',
        ),
    ));

    $cmb_options->add_field(array(

        'name' => 'Código GTM',
        'id' => 'codigo_gtm',
        'desc' => 'Lembre-se de cadastrar o cliente no GTM e configurar o Google Analytics<br/> e o relatório do cliente no Google Data Studio através do GTM',
        'type' => 'text',
        'default' => '',

    ));

    $cmb_options->add_field(array(
        'name' => 'Ambiente de envio dos formulários',
        'desc' => 'Alterar ambiente para onde serão enviados os formulários do site',
        'id' => 'ambiente_form',
        'type' => 'select',
        'default' => 'sim',
        'options' => array(
            URL_LEADS_PRODUCAO => 'Produção',
            URL_LEADS_HOMOLOGACAO => 'Homologação',
            URL_LEADS_DESENVOLVIMENTO => 'Desenvolvimento',
        ),
    ));


    $cmb_options->add_field(array(
        'before_row' => '<br/><h2>Imagem padrão</h2>',
        'name' => 'Imagem padrão (Veículos)',
        'desc' => 'Imagem padrão para quando o veículo não tem foto',
        'id' => 'foto_padrao_veiculo',
        'type' => 'file',
        // 'default' => 'https://via.placeholder.com/350x265?text=Sem%20Foto',
        'options' => array(
            'url' => true, // Hide the text input for the url
        ),
        'text' => array(
            'add_upload_file_text' => 'Fazer upload' // Change upload button text. Default: "Add or Upload File"
        ),
        'query_args' => array(
            'type' => array(
                // 	'image/gif',
                'image/jpeg',
                'image/png',
            ),
        ),
    ));

    $cmb_options->add_field(array(
        'before_row' => '<br/><h2>Sessão - Empresa / Sobre / Quem Somos  </h2>',
        'name' => 'Título',
        'desc' => 'Título a ser exibido na sessão/página/widget',
        'default' => '',
        'id' => 'sobre_titulo',
        'type' => 'text',
    ));

    $cmb_options->add_field(array(
        'name' => 'Selecione a imagem de sobre',
        'desc' => 'Selecione o arquivo ou informe a URL.',
        'id' => 'sobre_imagem',
        'type' => 'file',
        // Optional:
        'options' => array(
            'url' => true, // Hide the text input for the url
        ),
        'text' => array(
            'add_upload_file_text' => 'Adicionar arquivo' // Change upload button text. Default: "Add or Upload File"
        ),
        // query_args are passed to wp.media's library query.
        'query_args' => array(
            //'type' => 'application/pdf', // Make library only display PDFs.
            // Or only allow gif, jpg, or png images
            'type' => array(
                'image/gif',
                'image/jpeg',
                'image/png',
                'image/webp',
            ),
        ),
        'preview_size' => array(150, 150), // Image size to use when previewing in the admin.
    ));

    $cmb_options->add_field(array(
        'name' => 'Descrição',
        'desc' => 'Inserir a descrição do sobre',
        'default' => '',
        'id' => 'sobre_descricao',
        'type' => 'wysiwyg',
    ));

    $cmb_options->add_field(array(
        'before_row' => '<br/><h2>Sessão - Depoimentos</h2>',
        'name' => 'Exibir depoimentos',
        'desc' => '',
        'id' => 'exibir_depoimentos',
        'type' => 'select',
        'default' => 'nao',
        'options' => array(
            'sim' => 'Sim',
            'nao' => 'Não',
        ),
    ));

    $cmb_options->add_field(array(
        'name' => 'Layout da sessão depoimentos',
        'desc' => '',
        'id' => 'layout_depoimentos',
        'type' => 'select',
        'default' => 'modelo-1',
        'options' => array(
            'modelo-1' => 'Modelo 1',
            'modelo-2' => 'Modelo 2',
        ),
    ));


    $cmb_options->add_field(array(
        'before_row' => '<br/><h2>Sessão - Filtro</h2>',
        'name' => 'Exibir filtro na página inicial do site?',
        'desc' => '',
        'id' => 'exibir_filtro_home',
        'type' => 'select',
        'default' => 'sim',
        'options' => array(
            'sim' => 'Sim',
            'nao' => 'Não',
        ),
    ));
    $cmb_options->add_field(array(
        'name' => 'Exibir opção de busca textual?',
        'desc' => '',
        'id' => 'exibir_filtro_busca_textual',
        'type' => 'select',
        'default' => 'sim',
        'options' => array(
            'sim' => 'Sim',
            'nao' => 'Não',
        ),
    ));
    $cmb_options->add_field(array(
        'name' => 'Exibir filtro de preço?',
        'desc' => '',
        'id' => 'exibir_filtro_preco',
        'type' => 'select',
        'default' => 'sim',
        'options' => array(
            'sim' => 'Sim',
            'nao' => 'Não',
        ),
    ));

    $cmb_options->add_field(array(
        'before_row' => '<br/><h2>Sessão - Filtros (Tema 5)</h2>',
        'name' => 'Texto placeholder',
        'desc' => 'Texto que será exibido no campo de busca',
        'default' => 'Digite marca, modelo, ano',
        'id' => 'alt_texto_placeholder_filtro',
        'type' => 'text',
    ));

    $cmb_options->add_field(array(
        'name' => 'Exibir filtro de categoria?',
        'desc' => '',
        'id' => 'alt_exibir_filtro_categoria',
        'type' => 'select',
        'default' => 'nao',
        'options' => array(
            'sim' => 'Sim',
            'nao' => 'Não',
        ),
    ));
    $cmb_options->add_field(array(
        'name' => 'Exibir filtro de estado?',
        'desc' => '',
        'id' => 'alt_exibir_filtro_estado',
        'type' => 'select',
        'default' => 'nao',
        'options' => array(
            'sim' => 'Sim',
            'nao' => 'Não',
        ),
    ));
    $cmb_options->add_field(array(
        'name' => 'Exibir filtro de marca?',
        'desc' => '',
        'id' => 'alt_exibir_filtro_marca',
        'type' => 'select',
        'default' => 'sim',
        'options' => array(
            'sim' => 'Sim',
            'nao' => 'Não',
        ),
    ));
    $cmb_options->add_field(array(
        'name' => 'Exibir filtro de modelo?',
        'desc' => '',
        'id' => 'alt_exibir_filtro_modelo',
        'type' => 'select',
        'default' => 'sim',
        'options' => array(
            'sim' => 'Sim',
            'nao' => 'Não',
        ),
    ));
    $cmb_options->add_field(array(
        'name' => 'Exibir filtro de ano?',
        'desc' => '',
        'id' => 'alt_exibir_filtro_ano',
        'type' => 'select',
        'default' => 'sim',
        'options' => array(
            'sim' => 'Sim',
            'nao' => 'Não',
        ),
    ));
    $cmb_options->add_field(array(
        'name' => 'Exibir filtro de câmbio?',
        'desc' => '',
        'id' => 'alt_exibir_filtro_cambio',
        'type' => 'select',
        'default' => 'sim',
        'options' => array(
            'sim' => 'Sim',
            'nao' => 'Não',
        ),
    ));

    $cmb_options->add_field(array(
        'before_row' => '<br/><h2>Sessão - Carroceria/Categoria</h2>',
        'name' => 'Deseja exibir o filtro por carroceria/categoria?',
        'desc' => 'Sedan, Esportivo, Hatch, etc',
        'id' => 'filtro_por_carroceria',
        'type' => 'select',
        'default' => 'sim',
        'options' => array(
            'sim' => 'Sim',
            'nao' => 'Não',
        ),
    ));


    $cmb_options->add_field(array(
        'before_row' => '<br/><h2>Sessão - Marcas</h2>',
        'name' => 'Mostrar marcas',
        'desc' => '',
        'id' => 'mostrar_marcas',
        'type' => 'select',
        'default' => 'nao',
        'options' => array(
            'sim' => 'Sim',
            'nao' => 'Não',
        ),
    ));

    $cmb_options->add_field(array(
        'name' => 'Deseja exibir somente marcas do estoque?',
        'desc' => '',
        'attributes' => ['onChange' => 'mostrarMarcas()'],
        'id' => 'mostrar_somente_estoque',
        'type' => 'select',
        'default' => 'nao',
        'options' => array(
            'sim' => 'Sim',
            'nao' => 'Não',
        ),
    ));


    $group_field_id = $cmb_options->add_field(array(

        'id' => 'marcas_home',
        'type' => 'group',
        'description' => 'Marcas que serão exibidas na home (Tamanho recomendado 142x75) tamanhos fora dessa proporsão não serão exibidos corretamente.',

        'options' => array(
            'closed' => true,
            'group_title' => '{#}º Registro ', // since version 1.1.4, {#} gets replaced by row number
            'add_button' => 'Adicionar',
            'remove_button' => 'Remover',
            'remove_confirm' => 'Tem certeza que deseja remover esse registro?', // Performs confirmation before removing group.

        ),
    ));
    $cmb_options->add_group_field($group_field_id, array(

        'name' => 'Nome',
        'id' => 'nome',
        'description' => 'Esse campo será utilizado no ALT das imagens',
        'type' => 'text',
    ));
    $cmb_options->add_group_field($group_field_id, array(

        'name' => 'URL de destino',
        'id' => 'url_destino',
        'type' => 'text_url',
    ));
    $cmb_options->add_group_field($group_field_id, array(
        'name' => 'Imagem',
        'desc' => 'Faça o upload da imagem',
        'id' => 'imagem',
        'type' => 'file',

    ));


    $cmb_options->add_field(array(
        'before_row' => '<br/><h2>Sessão - Veículos em destaque (Home)</h2>',
        'name' => 'Exibir veiculos em destaque',
        'desc' => '',
        'id' => 'exibir_destaques',
        'type' => 'select',
        'default' => 'sim',
        'options' => array(
            'sim' => 'Sim',
            'nao' => 'Não',
        ),
    ));


    $cmb_options->add_field(array(
        'name' => 'Destaques',
        'desc' => 'Total de veículos em destaque na Home',
        'id' => 'total_veiculos_em_destaque',
        'type' => 'text',
        'default' => '6',
    ));

    $cmb_options->add_field(array(
        'name' => 'Tipo de veículo a ser exibido como destaque',
        'desc' => '',
        'id' => 'tipo_veiculo_destaque',
        'type' => 'select',
        'default' => 'todos',
        'options' => listaTipos(),
    ));
    $cmb_options->add_field(array(
        'name' => 'Exibir repasses em destaque',
        'desc' => '',
        'id' => 'exibir_repasse_destaque',
        'type' => 'select',
        'default' => 'sim',
        'options' => array(
            'sim' => 'Sim',
            'nao' => 'Não',
        ),
    ));
    $cmb_options->add_field(array(
        'name' => 'Titulo da página destaques',
        'desc' => 'Titulo da página destaques',
        'default' => '',
        'id' => 'destaques_titulo',
        'type' => 'textarea_small',
    ));


    $cmb_options->add_field(array(
        'before_row' => '<br/><h2>Sessão - Veículos mais recentes (Home)</h2>',
        'name' => 'Exibir veiculos mais recentes',
        'desc' => '',
        'id' => 'exibir_mais_recentes',
        'type' => 'select',
        'default' => 'sim',
        'options' => array(
            'sim' => 'Sim',
            'nao' => 'Não',
        ),
    ));


    $cmb_options->add_field(array(
        'name' => 'Mais recentes',
        'desc' => 'Total de veículos mais recentes na Home',
        'id' => 'total_veiculos_mais_recentes',
        'type' => 'text',
        'default' => '6',
    ));
    $cmb_options->add_field(array(
        'name' => 'Tipo de veículo a ser exibido como mais recentes',
        'desc' => '',
        'id' => 'tipo_veiculo_recentes',
        'type' => 'select',
        'default' => 'todos',
        'options' => listaTipos(),
    ));

    $cmb_options->add_field(array(
        'name' => 'Exibir repasses em veículos mais recentes',
        'desc' => '',
        'id' => 'exibir_repasse_mais_recentes',
        'type' => 'select',
        'default' => 'sim',
        'options' => array(
            'sim' => 'Sim',
            'nao' => 'Não',
        ),
    ));
    $cmb_options->add_field(array(
        'name' => 'Titulo da página mais recentes',
        'desc' => 'Titulo da página mais recentes',
        'default' => '',
        'id' => 'mais_recentes_titulo',
        'type' => 'textarea_small',
    ));


    $cmb_options->add_field(array(
        'before_row' => '<br/><h2>Sessão - Veículos mais procurados (Home)</h2>',
        'name' => 'Exibir veículos mais procurados',
        'desc' => '',
        'id' => 'exibir_mais_procurados',
        'type' => 'select',
        'default' => 'sim',
        'options' => array(
            'sim' => 'Sim',
            'nao' => 'Não',
        ),
    ));
    $cmb_options->add_field(array(
        'name' => 'Total de veículos mais procurados',
        'desc' => '',
        'id' => 'total_veiculos_mais_procurados',
        'type' => 'text',
        'default' => '3',
    ));
    $cmb_options->add_field(array(
        'name' => 'Titulo da página mais procurados',
        'desc' => 'Titulo da página mais procurados',
        'default' => '',
        'id' => 'mais_procurados_titulo',
        'type' => 'textarea_small',
    ));


    $cmb_options->add_field(array(
        'before_row' => '<br/><h2>Apresentação de titulo dos veículos</h2>',
        'name' => 'Mostrar titulo personalizado',
        'desc' => '',
        'id' => 'titulo_personalizado',
        'type' => 'select',
        'default' => 'nao',
        'options' => array(
            'sim' => 'Sim',
            'nao' => 'Não',
        ),
    ));

    $cmb_options->add_field(array(

        'name' => 'Formação do titulo personalizado dos veículos',
        'desc' => '',
        'id' => 'titulo',
        'type' => 'multicheck',
        'default' => array('marca', 'modelo', 'modelo_complemento', 'ano_fabricacao'),
        'options' => array(
            'marca' => 'Marca',
            'modelo' => 'Modelo',
            'modelo_complemento' => 'Modelo complemento',
            'ano_fabricacao' => 'Ano fabricação',
            'ano_modelo' => 'Ano modelo',
            'cor' => 'Cor',
            'porta' => 'Porta',
            'cambio' => 'Cambio',
        ),
    ));


    $cmb_options->add_field(array(
        'before_row' => '<br/><h2>Página de notícias</h2>',
        'name' => 'Importar noticias automaticamente?',
        'id' => 'importar_noticias',
        'type' => 'select',
        'default' => 'nao',
        'options' => array(
            'sim' => 'Sim',
            'nao' => 'Não',
        ),
    ));


    $cmb_options->add_field(array(
        'before_row' => '<br/><h2>Relatório de performance</h2>',
        'name' => 'Emitir automaticamente relatório de performance?',
        'id' => 'emitir_relatorio_performance',
        'type' => 'select',
        'default' => 'nao',
        'options' => array(
            'sim' => 'Sim',
            'nao' => 'Não',
        ),
    ));

    $cmb_options->add_field(array(
        'name' => 'Para qual e-mail o relatório de performance deve ser enviado?',
        'desc' => '',
        'id' => 'email_relatorio_performance',
        'type' => 'text',
        'default' => '',
    ));


    $cmb_options->add_field(array(
        'before_row' => '<br/><h2>Formatar placa</h2>',
        'name' => 'Formatação da placa',
        'desc' => 'Selecione quantos caracteres mostrar da placa',
        'id' => 'formatar_placa',
        'type' => 'select',
        'default' => 'modelo1',
        'options' => array(
            'formatacao1' => 'Primeiro e último',
            'formatacao2' => 'Apenas o último',
            'formatacao3' => 'Apenas o primeiro',
            'formatacao4' => 'Toda a placa',
        ),
    ));

    $cmb_options->add_field(array(
        'before_row' => '<br/><h2>Barra de rolagem</h2>',
        'name' => 'Exibir icone top page?',
        'desc' => 'Icone que fica no campo esquerdo responsável por rolar a tela para o topo novamente quando clicado.',
        'id' => 'barra_rolagem',
        'type' => 'select',
        'default' => 'sim',
        'options' => array(
            'sim' => 'Sim',
            'nao' => 'Não',
        ),
    ));


    //Init plugin


    $values = get_option('alt_group_setup');

    if (isset($values['marcas_home'])) {
        if (count($values['marcas_home']) == 0) {

            if (empty($values['marcas_home'][0]['nome'])) {
                $values['marcas_home'] = alt_lista_marcas_padrao();
                update_option('alt_group_setup', $values);
            }
        };
    }
}

function get_layout_totalizadores()
{
    $dados = get_option('alt_group_setup');
    if (!empty($dados['layout_totalizadores'])) {
        return $dados['layout_totalizadores'];
    }
    return 'default';
}

function get_exibir_titulo_personalizado()
{
    $dados = get_option('alt_group_setup');
    return $dados['titulo_personalizado'] == 'sim' ? true : false;
}

function get_titulo_destaques()
{
    $dados = get_option('alt_group_setup');
    if (!empty($dados['destaques_titulo'])) {
        return $dados['destaques_titulo'];
    }
    return null;
}

function get_titulo_mais_recentes()
{
    $dados = get_option('alt_group_setup');
    if (!empty($dados['mais_recentes_titulo'])) {
        return $dados['mais_recentes_titulo'];
    }
    return null;
}

function get_titulo_mais_procurados()
{
    $dados = get_option('alt_group_setup');
    if (!empty($dados['mais_procurados_titulo'])) {
        return $dados['mais_procurados_titulo'];
    }
    return null;
}

function get_marca_destaque($veiculo_id)
{
    $objMarca = get_the_terms($veiculo_id, 'marca');

    $marcas = get_option('alt_group_setup');

    $marca_select = $objMarca[0]->name;
    $output = false;
    foreach ($marcas['marcas_home'] as $marca) {
        if ($marca['nome'] == $marca_select) {
            $output = $marca['imagem'];
        }
    }
    return $output;
}

function get_todas_marcas()
{


    $dados = get_option('alt_group_setup');


    if ($dados['mostrar_somente_estoque'] == 'sim') {
        return get_marcas_do_estoque_com_veiculo();
    }

    return $dados['marcas_home'];
}

function get_marcas_do_estoque_com_veiculo()
{

    $categories = get_terms([
        'taxonomy' => 'marca',
        'hide_empty' => true,
        'orderby' => 'count',
        'order' => 'DESC'
    ]);
    $arrRetorno = [];
    foreach ($categories as $key => $categoria) {


        $info['url_destino'] = alt_get_url_estoque() . '?marca=' . $categoria->slug;
        $info['imagem'] = get_term_meta($categoria->term_id, 'marca_img', true);
        $info['nome'] = $categoria->name;
        $info['total'] = $categoria->count;
        $info['slug'] = $categoria->slug;

        if (empty($info['imagem'])) {
            continue;
        }


        $arrRetorno[$key] = $info;
    }


    return $arrRetorno;
}

function get_marcas_mais_buscadas()
{
    global $wpdb;

    $prefix = alt_prefixo();

    // Definindo nome das tabelas com prefixo dinâmico
    $term_relationships = $prefix . 'term_relationships';
    $term_taxonomy      = $prefix . 'term_taxonomy';
    $postmeta           = $prefix . 'postmeta';
    $terms              = $prefix . 'terms';

    $sql = "
        SELECT name, slug, total
        FROM (
            SELECT ter.name, ter.slug, SUM(pm.meta_value) AS total 
            FROM $term_relationships t 
            JOIN $term_taxonomy tt ON tt.term_taxonomy_id = t.term_taxonomy_id
            JOIN $terms ter ON ter.term_id = tt.term_id
            JOIN $postmeta pm ON pm.post_id = t.object_id
            WHERE tt.taxonomy = 'marca'
            AND pm.meta_key = 'post_views_count'
            GROUP BY ter.name, ter.slug
        ) AS subquery
        ORDER BY total DESC
        LIMIT 5
    ";

    return $wpdb->get_results($sql);
}

function get_show_barra_rolagem()
{
    $dados = get_option('alt_group_setup');
    return $dados['barra_rolagem'] == 'sim' ? true : false;
}

function get_importar_noticias()
{
    $dados = get_option('alt_group_setup');
    return (!empty($dados['importar_noticias']) && $dados['importar_noticias'] == 'sim') ? true : false;
}


function get_formatar_placa()
{
    $dados = get_option('alt_group_setup');
    return $dados['formatar_placa'];
}


function get_formacao_titulo()
{
    $dados = get_option('alt_group_setup');
    return $dados['titulo'];
}

function buscarFormularios($form_id = null)
{

    $args = array('post_type' => 'wpcf7_contact_form', 'posts_per_page' => -1);
    $cf7Forms = get_posts($args);
    $arrIds = wp_list_pluck($cf7Forms, 'ID');
    $arrTitulos = wp_list_pluck($cf7Forms, 'post_title');
    $arrDados[0] = 'Inativo';

    foreach ($arrIds as $index => $ids) {
        $arrDados[$ids] = $arrTitulos[$index];
    }

    return $arrDados;
}

function listaTipos()
{


    $arrTermos = get_terms('tipo');

    $arrRet = [];

    $arrRet['todos'] = 'Todos';
    foreach ($arrTermos as $termos) {
        $arrRet[$termos->slug] = $termos->name;
    }
    return $arrRet;
}

function get_mostrar_ultimas_noticias()
{
    $dados = get_option('alt_group_setup');
    return $dados['exibir_noticias'] == 'sim' ? true : false;
}

function alt_get_conteudo_sobre()
{
    $dados = get_option('alt_group_setup');
    $sobre['titulo'] = $dados['sobre_titulo'] ?? '';
    $sobre['imagem'] = $dados['sobre_imagem'] ?? '';
    $sobre['descricao'] = $dados['sobre_descricao'] ?? '';
    return $sobre;
}

function get_layout_depoimentos()
{
    $dados = get_option('alt_group_setup');
    $modelo = $dados['layout_depoimentos'];
    if (empty($modelo)) {
        return 'modelo-1';
    }
    return $modelo;
}

if (!function_exists('formato_visualizacao')) {
    function formato_visualizacao()
    {

        $dados = get_option('alt_group_setup');


        if (isset($dados['formato_visualizacao']) && $dados['formato_visualizacao'] == 'wide') {
            return 'container-fluid';
        }

        return 'container';
    }
}

function get_mostrar_depoimentos()
{
    $dados = get_option('alt_group_setup');
    return $dados['exibir_depoimentos'] == 'sim' ? true : false;
}

function get_mostrar_veiculos_mais_procurados()
{
    $dados = get_option('alt_group_setup');
    return $dados['exibir_mais_procurados'] == 'sim' ? true : false;
}

function get_mostrar_total_veiculos_mais_procurados()
{
    $dados = get_option('alt_group_setup');
    return $dados['total_veiculos_mais_procurados'];
}


function get_mostrar_veiculos_destaque()
{
    $dados = get_option('alt_group_setup');
    return $dados['exibir_destaques'] == 'sim' ? true : false;
}

function get_total_veiculos_destaque()
{
    $dados = get_option('alt_group_setup');
    return $dados['total_veiculos_em_destaque'];
}

function get_exibir_repasse_destaques()
{
    $dados = get_option('alt_group_setup');
    return $dados['exibir_repasse_destaque'];
}

function get_exibir_repasse_recentes()
{
    $dados = get_option('alt_group_setup');
    return $dados['exibir_repasse_mais_recentes'];
}

function get_tipo_veiculo_destaques()
{
    $dados = get_option('alt_group_setup');
    return $dados['tipo_veiculo_destaque'];
}

function get_tipo_veiculo_mais_recentes()
{
    $dados = get_option('alt_group_setup');
    return $dados['tipo_veiculo_recentes'];
}

function get_mostrar_veiculos_mais_recentes()
{
    $dados = get_option('alt_group_setup');
    return $dados['exibir_mais_recentes'] == 'sim' ? true : false;
}


function mostrar_icones_sociais_header()
{
    $dados = get_option('alt_group_midias_sociais');
    return !empty($dados['exibir_social_cabecalho']) && $dados['exibir_social_cabecalho'] == 'sim' ? true : false;
}

function mostrar_icones_sociais_footer()
{
    $dados = get_option('alt_group_midias_sociais');
    return !empty($dados['exibir_social_rodape']) && $dados['exibir_social_rodape'] == 'sim' ? true : false;
}

function get_total_veiculos_mais_recentes()
{
    $dados = get_option('alt_group_setup');

    return $dados['total_veiculos_mais_recentes'];
}

add_shortcode('alt_short_code_logo', 'alt_short_code_logo');

function alt_get_url_logo()
{
    $arrOptions = get_option('alt_group_setup');
    if (empty($arrOptions['logo'])) {
        $url = get_template_directory_uri() . '/assets/images/logo.png';
    } else {
        $url = $arrOptions['logo'];
    }

    return $url;
}

function alt_get_url_imagem_padrao()
{
    $arrOptions = get_option('alt_group_setup');
    if (empty($arrOptions['foto_padrao_veiculo']) || $arrOptions['foto_padrao_veiculo'] == "https://via.placeholder.com/350x265?text=Sem%20Foto ") {
        return 'https://cdn-wp-altimus.s3-sa-east-1.amazonaws.com/imagens/veiculo-sem-foto.jpg';
    }

    return $arrOptions['foto_padrao_veiculo'];
}

function alt_get_ultima_foto_mantida()
{
    $arrOptions = get_option('alt_group_setup');
    return $arrOptions['ultima_foto_mantida'];
}


function alt_short_code_logo($size = null)
{

    $arrOptions = get_option('alt_group_setup');

    if (empty($arrOptions['logo'])) {
        $url = get_template_directory_uri() . '/assets/images/logo.png';
        echo '<img alt="logo da empresa" src="' . $url . '" class="logo-header img-responsive" alt="Logo da loja" ' . $size . '/>';
    } else {
        echo '<img alt="logo da empresa"  src="' . $arrOptions['logo'] . '" class="logo-header img-responsive" alt="Logo da loja" ' . $size . '/>';
    }
}

function alt_url_logo()
{
    $arrOptions = get_option('alt_group_setup');
    $site_url = get_site_url();

    if (empty($arrOptions['logo'])) {
        $url = get_template_directory_uri() . '/assets/images/logo.png';
        return $url;
    }
    $url_logo = $arrOptions['logo'];

    $site_url = str_replace(['http://', 'https://'], '', $site_url);
    $url_logo = str_replace(['http://', 'https://'], '', $url_logo);

    $logo_url_relativa = str_replace($site_url, '', $url_logo);
    return $logo_url_relativa;
}

function alt_get_url_imagem($imagem)
{
    return get_template_directory_uri() . '/assets/images/' . $imagem;
}

function get_mostrar_totalizadores()
{
    $dados = get_option('alt_group_setup');
    return $dados['mostrar_totalizadores'] == 'sim' ? true : false;
}

function get_totalizadores()
{
    $dados = get_option('alt_group_setup');


    $arr['titulo_sessao_totalizadores'] = $dados['titulo_sessao_totalizadores'] ?? null;
    $arr['experiencia'] = $dados['anos_experiencia'] ?? null;
    $arr['total_veiculos'] = $dados['total_veiculos'] ?? null;
    $arr['total_ofertas'] = $dados['total_ofertas'] ?? null;
    $arr['total_clientes'] = $dados['total_clientes'] ?? null;

    return $arr;
}

function get_mostrar_carroceria()
{
    $dados = get_option('alt_group_setup');
    return $dados['filtro_por_carroceria'] == 'sim' ? true : false;
}
function alt_get_mostrar_carroceria()
{
    $dados = get_option('alt_group_setup');
    return $dados['filtro_por_carroceria'] == 'sim' ? true : false;
}

function get_listar_carrocerias()
{
    $categories = get_terms(['taxonomy' => 'carroceria', 'hide_empty' => false, 'orderby' => 'count', 'order' => 'DESC']);
    $arrRetorno = [];
    
    $total = 0;
    foreach ($categories as $key => $categoria) {

        $total++;
        if ($total > 6) {
            continue;
        }
        $img = get_term_meta($categoria->term_id, 'carroceria_img', true);

        if (empty($img)) {
            continue;
        }

        $info['slug'] = $categoria->slug;
        $info['imagem'] = $img;
        $info['nome'] = $categoria->name;
        $info['total'] = $categoria->count;
        $info['slug'] = $categoria->slug;


        $arrRetorno[$key] = $info;
    }


    return $arrRetorno;
}

function alt_get_lista_carrocerias()
{
    $lista_imagens = alt_get_lista_imagens_carrocerias();
    $categorias = get_terms([
        'taxonomy' => 'carroceria',
        'hide_empty' => false,
        'orderby' => 'count',
        'order' => 'DESC',
    ]);

    $relacionadas = [];

    foreach ($categorias as $categoria) {
        $nome_categoria = $categoria->name;
        $slug_categoria = $categoria->slug;

        // Verificar se já foi adicionado (usando slug como chave única)
        if (isset($relacionadas[$slug_categoria])) {
            continue;
        }

        // Divide por '/' e adiciona também a string original
        $partes = explode('/', $nome_categoria);
        array_unshift($partes, $nome_categoria);

        foreach ($partes as $parte) {
            foreach ($lista_imagens as $palavra) {
                // Normalize ambas
                $palavraNorm = strtolower($palavra);
                $parteNorm = strtolower($parte);

                // Verificação direta
                if (strpos($palavraNorm, $parteNorm) !== false || strpos($parteNorm, $palavraNorm) !== false) {
                    $relacionadas[$slug_categoria] = [
                        'nome' => ucfirst($nome_categoria),
                        'imagem' => get_template_directory_uri() . "/assets/images/categorias/" . $palavra . ".png",
                    ];
                    break 2; // Sai dos dois loops internos, já que encontrou correspondência
                }

                // Verificação por similaridade
                similar_text($parteNorm, $palavraNorm, $percentual);
                if ($percentual >= 80) {
                    $relacionadas[$slug_categoria] = [
                        'nome' => ucfirst($nome_categoria),
                        'imagem' => get_template_directory_uri() . "/assets/images/categorias/" . $palavra . ".png",
                    ];
                    break 2;
                }
            }
        }
    }

    return $relacionadas;

}

function get_mostrar_marcas()
{
    $dados = get_option('alt_group_setup');
    return $dados['mostrar_marcas'] == 'sim' ? true : false;
}


function get_show_filtro_home()
{
    $dados = get_option('alt_group_setup');

    if (!isset($dados['exibir_filtro_home'])) {
        return true;
    }
    return $dados['exibir_filtro_home'] == 'sim' ? true : false;
}

function get_show_textual_busca_home()
{
    $dados = get_option('alt_group_setup');

    if (!isset($dados['exibir_filtro_busca_textual'])) {
        return true;
    }
    return $dados['exibir_filtro_busca_textual'] == 'sim' ? true : false;
}

function get_show_filtro_preco()
{
    $dados = get_option('alt_group_setup');

    if (!isset($dados['exibir_filtro_preco'])) {
        return true;
    }
    return $dados['exibir_filtro_preco'] == 'nao' ? false : true;
}

/**
 * Retorna o conteúdo que deve ser exibido no placeholder no campo de pesquisa no filtro.
 *
 * Esta função verifica a opção 'alt_group_setup' para buscar o conteudo que deve ser exibido no placeholder.
 * Se não houver conteúdo definido, a função retornará 'Digite marca, modelo, ano', do contrário retornará o conteudo inserido.
 *
 * @return string Retorna uma string que deve ser exibido no placeholder.
 */
function alt_get_texto_placeholder_filtro()
{
    $dados = get_option('alt_group_setup');
    if (isset($dados['alt_texto_placeholder_filtro'])) {
        return $dados['alt_texto_placeholder_filtro'];
    }
    return 'Digite marca, modelo, ano';
}

/**
 * Verifica se o filtro de categoria deve ser exibido.
 *
 * Esta função verifica a opção 'alt_group_setup' para determinar se o filtro de categoria
 * deve ser exibido. Se a opção 'alt_exibir_filtro_categoria' estiver definida como 'sim',
 * a função retornará true. Caso contrário, retornará false.
 *
 * @return bool Retorna true se o filtro de categoria deve ser exibido, false caso contrário.
 */
function alt_get_show_filtro_categoria()
{
    $dados = get_option('alt_group_setup');
    if (isset($dados['alt_exibir_filtro_categoria']) && $dados['alt_exibir_filtro_categoria'] == 'sim') {
        return true;
    }
    return false;
}

/**
 * Verifica se o filtro de estado deve ser exibido.
 *
 * Esta função verifica a opção 'alt_group_setup' para determinar se o filtro de estado
 * deve ser exibido. Se a opção 'alt_exibir_filtro_estado' estiver definida como 'sim',
 * a função retornará true. Caso contrário, retornará false.
 *
 * @return bool Retorna true se o filtro de estado deve ser exibido, false caso contrário.
 */
function alt_get_show_filtro_estado()
{
    $dados = get_option('alt_group_setup');
    if (isset($dados['alt_exibir_filtro_estado']) && $dados['alt_exibir_filtro_estado'] == 'sim') {
        return true;
    }
    return false;
}

/**
 * Verifica se o filtro de marca deve ser exibido.
 *
 * Esta função verifica a opção 'alt_group_setup' para determinar se o filtro de marca
 * deve ser exibido. Se a opção 'alt_exibir_filtro_marca' estiver definida como 'sim',
 * a função retornará true. Caso contrário, retornará false.
 *
 * @return bool Retorna true se o filtro de marca deve ser exibido, false caso contrário.
 */
function alt_get_show_filtro_marca()
{
    $dados = get_option('alt_group_setup');
    if (isset($dados['alt_exibir_filtro_marca']) && $dados['alt_exibir_filtro_marca'] == 'nao') {
        return false;
    }
    return true;
}

/**
 * Verifica se o filtro de modelo deve ser exibido.
 *
 * Esta função verifica a opção 'alt_group_setup' para determinar se o filtro de modelo
 * deve ser exibido. Se a opção 'alt_exibir_filtro_modelo' estiver definida como 'sim',
 * a função retornará true. Caso contrário, retornará false.
 *
 * @return bool Retorna true se o filtro de modelo deve ser exibido, false caso contrário.
 */
function alt_get_show_filtro_modelo()
{
    $dados = get_option('alt_group_setup');
    if (isset($dados['alt_exibir_filtro_modelo']) && $dados['alt_exibir_filtro_modelo'] == 'nao') {
        return false;
    }
    return true;
}

/**
 * Verifica se o filtro de ano deve ser exibido.
 *
 * Esta função verifica a opção 'alt_group_setup' para determinar se o filtro de ano
 * deve ser exibido. Se a opção 'alt_exibir_filtro_ano' estiver definida como 'sim',
 * a função retornará true. Caso contrário, retornará false.
 *
 * @return bool Retorna true se o filtro de ano deve ser exibido, false caso contrário.
 */
function alt_get_show_filtro_ano()
{
    $dados = get_option('alt_group_setup');
    if (isset($dados['alt_exibir_filtro_ano']) && $dados['alt_exibir_filtro_ano'] == 'nao') {
        return false;
    }
    return true;
}

/**
 * Verifica se o filtro de cambio deve ser exibido.
 *
 * Esta função verifica a opção 'alt_group_setup' para determinar se o filtro de cambio
 * deve ser exibido. Se a opção 'alt_exibir_filtro_cambio' estiver definida como 'sim',
 * a função retornará true. Caso contrário, retornará false.
 *
 * @return bool Retorna true se o filtro de cambio deve ser exibido, false caso contrário.
 */
function alt_get_show_filtro_cambio()
{
    $dados = get_option('alt_group_setup');
    if (isset($dados['alt_exibir_filtro_cambio']) && $dados['alt_exibir_filtro_cambio'] == 'nao') {
        return false;
    }
    return true;
}

function alt_get_tipo_veiculo()
{
    $dados = get_option('alt_group_setup');

    if (!empty($dados['tipo_veiculo'])) {
        return $dados['tipo_veiculo'];
    }
    return 'altimuscarro';
}

function get_modal_lgpd()
{

    $dados = get_option('alt_group_setup');

    if (!isset($dados['modal_lgpd'])) {
        return true;
    }
    return $dados['modal_lgpd'] == 'sim' ? true : false;
}

function get_imagem_padrao_veiculo_id()
{

    $dados = get_option('alt_group_setup');
    if (empty($dados['foto_padrao_veiculo']) || $dados['foto_padrao_veiculo'] == 'https://via.placeholder.com/350x265?text=Sem%20Foto') {
        return "https://cdn-wp-altimus.s3-sa-east-1.amazonaws.com/imagens/veiculo-sem-foto.jpg";
    }

    return $dados['foto_padrao_veiculo'] ?? null;
}



function get_pagina_padrao_estoque()
{

    $dados = get_option('alt_group_setup');

    if (!isset($dados['pagina_padrao_estoque'])) {
        return 'estoque';
    }
    return $dados['pagina_padrao_estoque'];
}

function get_emitir_relatorio_performance()
{
    $dados = get_option('alt_group_setup');

    if (!isset($dados['emitir_relatorio_performance'])) {
        return true;
    }
    return $dados['emitir_relatorio_performance'] == 'sim' ? true : false;
}

function get_email_relatorio_performance()
{

    $dados = get_option('alt_group_setup');
    return $dados['email_relatorio_performance'];
}

function hook_javascript()
{
?>
    <script>
        alert('Page is loading...');
    </script>
<?php
}

add_action('wp_head', 'alt_tag_google');
add_action('after_body_open_tag', 'alt_tag_google_body');
function alt_tag_google()
{

    $dados = get_option('alt_group_setup');
    $gtm = $dados['codigo_gtm'] ?? null;

    if (empty($gtm)) {
        return;
    }
    echo "<!-- Google Tag Manager -->
<script>(function(w,d,s,l,i){w[l]=w[l]||[];w[l].push({'gtm.start':
new Date().getTime(),event:'gtm.js'});var f=d.getElementsByTagName(s)[0],
j=d.createElement(s),dl=l!='dataLayer'?'&l='+l:'';j.async=true;j.src=
'https://www.googletagmanager.com/gtm.js?id='+i+dl;f.parentNode.insertBefore(j,f);
})(window,document,'script','dataLayer','" . $gtm . "');</script>
<!-- End Google Tag Manager -->";
}

add_action('admin_notices', 'mensagem_de_erro_gtm');
function mensagem_de_erro_gtm()
{
    $dados = get_option('alt_group_setup');
    $gtm = $dados['codigo_gtm'] ?? null;

    if (empty($gtm)) {
        $class = 'notice notice-error';
        $message = 'Código GTM Não foi configurado, ele é obrigatório para a emissão de relatórios de performance.';
        printf('<div class="%1$s"><p>%2$s</p></div>', esc_attr($class), esc_html($message));
    }
}

function alt_tag_google_body()
{
    $dados = get_option('alt_group_setup');
    $gtm = $dados['codigo_gtm'] ?? null;

    if (empty($gtm)) {
        return;
    }

    echo "<!-- Google Tag Manager (noscript) -->
<noscript><iframe src=\"https://www.googletagmanager.com/ns.html?id=" . $gtm . "\"
height=\"0\" width=\"0\" style=\"display:none;visibility:hidden\"></iframe></noscript>
<!-- End Google Tag Manager (noscript) -->";
}

//Retorna a URL do ambiente configurado para envio de leads. Caso não esteja salvo, considera a url de produção
function alt_get_ambiente_form()
{
    $arrOptions = get_option('alt_group_setup');
    if (!empty($arrOptions['ambiente_form'])) {
        return $arrOptions['ambiente_form'];
    } else {
        return URL_LEADS_PRODUCAO;
    }
}

add_action('wpcf7_before_send_mail', 'tratar_formularios', 10, 3);
/**
 * Função que trata os formulários do CF7 e envia para o Altimus
 * 
 * Esta função é chamada antes de enviar o email pelo CF7 e 
 * faz o envio dos dados do formulário para o Altimus.
 * 
 * @param int $form_id o id do formulário
 * @param object $submission o objeto de envio do CF7
 */
function tratar_formularios($form_id, $submission)
{
    //Pegar nome e id
    $wpcf7 = WPCF7_ContactForm::get_current();
    $form_id = $wpcf7->id;
    $user_loja = null;

    //pegar dados e URL do formulário
    $submission = WPCF7_Submission::get_instance();
    $posted_data = $submission->get_posted_data();

    //Pega Id do veículo do Altimus no campo do WP
    $id_veiculo_wordpress = ($_POST['_wpcf7_container_post']);
    $post_veiculo = get_post_meta($id_veiculo_wordpress);
    $veiculo_id = $post_veiculo['alt_id'][0] ?? '';

    // Tenta buscar o id do post de outra forma se não encontrado
    if (empty($veiculo_id) && isset($posted_data['page_url'])) {
        $page_url = $posted_data['page_url']; // Pega a URL da página do campo oculto
        $post = alt_get_post_by_guid($page_url); // Função personalizada para buscar o post pelo GUID

        if ($post && isset($post->ID)) {
            $veiculo_id = $post->ID;
            $user_loja = get_userdata($post->post_author);
        }
    }

    //URL Integracao
    $url_base = alt_get_ambiente_form();
    $site_cliente =  get_home_url();

    if (!empty($utm_tags)) {
        $posted_data['utm_tags'] = $utm_tags;
    }

    if (!empty($veiculo_id)) {
        $posted_data['id_altimus'] = $veiculo_id;
    }

    // Remove campos indesejados
    $campos_para_remover = ['ct_checkjs_cf7', 'apbct_event_id', 'g-recaptcha-response', 'recaptcha'];
    foreach ($campos_para_remover as $campo) {
        if (isset($posted_data[$campo])) {
            unset($posted_data[$campo]);
        }
    }

    $json_posted = json_encode($posted_data);
    $string_posted = base64_encode($json_posted);

    //Dados que serão enviados ao Altimus
    $data = [
        'url' => $site_cliente,
        'formulario' => $string_posted,
    ];

    // Adiciona o login do usuário dependendo do tipo de portal
    if (alt_is_portal()) {
        if (alt_get_portal_destinatario() === 'associacao' || empty($veiculo_id)) {
            $user = wp_get_current_user();
            $data['user_login'] = $user->user_login ?? null;
        } elseif (alt_get_portal_destinatario() === 'lojas' && !empty($veiculo_id)) {
            $post_veiculo = get_post($id_veiculo_wordpress);
            $user_loja = get_userdata($post_veiculo->post_author);
            $data['user_login'] = $user_loja->user_login ?? null;

            // Altera o destinatário do email para o email da loja
            $mail = $wpcf7->get_properties()['mail'];
            $mail['recipient'] = sanitize_email($user_loja->user_email);
            $wpcf7->set_properties(['mail' => $mail]);
        }
    }

    //Faz envio
    $response = wp_safe_remote_post($url_base, [
        'headers'     => [
            'Content-Type'  => 'application/json',
        ],
        'body' => json_encode($data),
        'method' => 'POST',
    ]);

    // Trata erros na requisição
    if (is_wp_error($response)) {
        $error_message = $response->get_error_message();
        $submission->set_response($error_message);
        $submission->set_status('api_failed');
    } else {
        $body = wp_remote_retrieve_body($response);
        $result = json_decode($body);

        if (isset($result->error)) {
            $submission->set_response($result->error);
            $submission->set_status('api_failed');
        }
    }
}

// function get_utm_tags()
// {
//     echo "<script>document.addEventListener('DOMContentLoaded', function() {
//         const url_to_format = window.location.search;
//         const url_formatada = url_to_format.replace('?', '').replaceAll('&', ',');
//         const myArray = url_formatada.split(", ");
//         const tags = myArray.toString();

//         if(tags.includes('utm_')){
//           window.localStorage.setItem('altimus_tags', myArray);
//           let tagsSite = localStorage.getItem('altimus_tags')
//           document.getElementById('utm_tags').value = tagsSite;
//         }
//     }, false);</script>";
// }
// add_action('init', 'get_utm_tags');


function add_opengraph($output)
{
    return $output . ' xmlns:og="http://opengraphprotocol.org/schema/" xmlns:fb="http://www.facebook.com/2008/fbml"';
}
add_filter('language_attributes', 'add_opengraph');


function add_facebook_no_header()
{
    global $post;
    if (isset($post)) {
        echo '<meta property="og:title" content="' . get_the_title() . '"/>';
        echo '<meta property="og:type" content="website"/>';
        echo '<meta property="og:url" content="' . get_bloginfo('url') . '"/>';
        echo '<meta property="og:description" content="' . get_bloginfo('description') . '"/>';
        echo '<meta property="og:site_name" content="' . get_bloginfo() . '"/>';
        echo '<meta property="og:locale" content="pt_BR"/>';
        if (!has_post_thumbnail($post->ID)) {
            $default_image = alt_get_url_logo();
            echo '<meta property="og:image" content="' . alt_get_url_logo() . '"/>';
            echo '<meta property="og:image:type" content="image/png"/>';
        } else {
            $thumbnail_src = wp_get_attachment_image_src(get_post_thumbnail_id($post->ID), 'thumbnail');
            echo '<meta property="og:image" content="' . esc_attr($thumbnail_src[0]) . '"/>';
        }
        echo '<meta property="og:image:width" content="250" />';
    }
}
add_action('wp_head', 'add_facebook_no_header', 5);

function alt_cabecalho_fixo()
{
    $dados = get_option('alt_group_setup');
    $menuFixo = $dados['cabecalho_fixo'];

    if ($menuFixo === 'sim') {
        return 'fixed';
    }

    return '';
}

function alt_get_lista_imagens_carrocerias()
{
    $dir = 'wp-content/themes/altimus5/assets/images/categorias/';
    $files = scandir($dir);
    return array_filter(array_map(function ($file) {
        $nome = pathinfo($file, PATHINFO_FILENAME);
        return strlen($nome) >= 3 ? $nome : null;
    }, $files));
}
