<?php
if (!defined('ABSPATH')) {
    define('ABSPATH', dirname(__FILE__) . '/');
}
    
// set permalink
function set_permalink(){
    global $wp_rewrite;
    $wp_rewrite->set_permalink_structure('/%postname%/');
}

/**
 * VERIFICAR SE EXISTE ALGUMA MARCA CADASTRADA, SE NÃO, ENTÃO INCLUIR AUTOMATICAMENTE AS MARCAS PADRÕES
 */

function create_database_lead()
{
    // create the custom table
    global $wpdb;


    $table_name = $wpdb->prefix . 'alt_leads';
    $charset_collate = $wpdb->get_charset_collate();

    $sql = "CREATE TABLE IF NOT EXISTS $table_name ( 
  `id` INT NOT NULL AUTO_INCREMENT,
  `permalink` VARCHAR(255),
  `nome` VARCHAR(255),
  `email` VARCHAR(255),
  `telefone` VARCHAR(255),
  `marca` VARCHAR(255),
  `modelo` VARCHAR(255),
  `valor` VARCHAR(255),
  `created_at` VARCHAR(255),
  `mensagem` TEXT,
  PRIMARY KEY (`id`)
) $charset_collate;";

    require_once(ABSPATH . 'wp-admin/includes/upgrade.php');
    dbDelta($sql);
}


/**
 * Função que salva as informações do formulário em uma tabela customizada,
 * essa função é chamada antes de enviar o e-mail.
 * 
 * @param object $form_to_DB Objeto com as informações do formulário.
 */
function contactform7_before_send_mail($form_to_DB)
{


    global $wpdb;

    $table_name = $wpdb->prefix . 'alt_leads';

    $form_to_DB = WPCF7_Submission::get_instance();
    if ($form_to_DB)
        $formData = $form_to_DB->get_posted_data();

    $form['permalink'] = isset($formData['permalink']) ? $formData['permalink'] : '';
    $form['nome'] = isset($formData['nome']) ? $formData['nome'] : '';
    $form['email'] = isset($formData['email']) ? $formData['email'] : '';
    $form['telefone'] = isset($formData['telefone']) ? $formData['telefone'] : '';
    $form['marca'] = isset($formData['marca']) ? $formData['marca'] : '';
    $form['modelo'] = isset($formData['modelo']) ? $formData['modelo'] : '';
    $form['valor'] = isset($formData['valor']) ? $formData['valor'] : '';
    $form['mensagem'] = isset($formData['mensagem']) ? $formData['mensagem'] : '';
    $form['created_at'] = date('Y-m-d H:i:s');

    $wpdb->insert($table_name, $form, array('%s', '%s', '%s', '%s', '%s', '%s', '%s', '%s', '%s'));
    $my_id = $wpdb->insert_id;
}


//remove_all_filters('wpcf7_before_send_mail');
add_action('wpcf7_before_send_mail', 'contactform7_before_send_mail');


/**
 * Criação automatica de dados
 */

add_action('wp_ajax_criar_paginas_default', 'criar_paginas_default');
//add_action('wp_ajax_nopriv_criar_paginas_default','criar_paginas_default');
//do_action('criar_paginas_default');
function criar_paginas_default()
{
    // Importar o formulário XML
    ImportarXML();

    // Importar as páginas XML
    ImportarPaginasXML();
    
    // Definine a estrutura de permalinks no tipo 'nome do post'
    set_permalink();
    
    /**
     * Listagem de paginas por tema, assim como nome e template.
     */
    $paginas_por_tema = array(
        'padrao' => array(
            'Home' => array('post_name' => 'home', 'template' => ''),
            'Estoque' => array('post_name' => 'estoque', 'template' => 'page-estoque.php'),
            'Empresa' => array('post_name' => 'empresa', 'template' => ''),
            'Contato' => array('post_name' => 'contato', 'template' => 'page-contato.php'),
            'Ficha Cadastral' => array('post_name' => 'ficha-cadastral', 'template' => ''),
        ),
        'altimus5' => array(
            'Home' => array('post_name' => 'home', 'template' => ''),
            'Estoque' => array('post_name' => 'estoque', 'template' => 'page-estoque.php'),
            'Empresa' => array('post_name' => 'empresa', 'template' => ''),
            'Contato' => array('post_name' => 'contato', 'template' => ''),
        ),
        'portal' => array(
            'Home' => array('post_name' => 'home', 'template' => ''),
            'Estoque' => array('post_name' => 'estoque', 'template' => 'page-estoque.php'),
            'Quem Somos' => array('post_name' => 'quem-somos', 'template' => 'page-sobre.php'),
            'Notícias' => array('post_name' => 'noticias', 'template' => ''),
            'Loja' => array('post_name' => 'loja', 'template' => 'page-loja.php'),
            'Associar-se' => array('post_name' => 'associar', 'template' => 'page-associar.php'),
            'Parceria' => array('post_name' => 'parceria', 'template' => 'page-parceria.php'),
            'Contato' => array('post_name' => 'contato', 'template' => 'page-contato.php'),
        ),
    );

    // Verificar qual é o tema padrão
    $nome_tema = get_template();

    // Define quais paginas serão criadas de acordo com o tema
    if (alt_is_portal()) {
        $tema_atual = 'portal';
    } else if ($nome_tema == 'altimus5') {
        $tema_atual = 'altimus5';
    } else {
        $tema_atual = 'padrao';
    }

    $paginas = $paginas_por_tema[$tema_atual];

    // Criar as páginas para o tema atual
    foreach ($paginas as $titulo => $dados) {
        if (!alt_get_page_by_title($titulo)) {
            $page_id = wp_insert_post(array(
                'comment_status' => 'close',
                'ping_status' => 'close',
                'post_author' => 1,
                'post_title' => $titulo,
                'post_name' => $dados['post_name'],
                'post_status' => 'publish',
                'post_content' => '',
                'post_type' => 'page',
                'post_parent' => ''
            ));
            if (!empty($dados['template'])) {
                update_post_meta($page_id, '_wp_page_template', $dados['template']);
            }
        }
    }

    // Criar os widgets de acordo com o tema
    alt_gerar_widget_tema($nome_tema);

    // Busca os dados da matriz
    $matriz = get_info_principal(true);

    // Gera mensagem padrão para o whatsapp
    $testo_whatsapp = !empty($matriz) ?'Olá, estou no site ' . $matriz['nome_fantasia'] . ' e gostaria de comprar!' : '';
    
    // Define as opções padrões do tema
    $defaults = array(
        // Seta todos os valores padrões da Listagem
        'layout_estoque' => 'bloco',
        'total_lista_estoque' => '15',
        'ordenaca_padrao' => 'mais_recentes',
        'tarjeta_destaque' => 'sim',
        'tarjeta_repasse' => 'sim',
        'caracteristicas' => array('alt_kilometragem', 'alt_cambio', 'alt_ano_mod', 'alt_combustivel', 'alt_marca', 'alt_cor', 'alt_placa'),
        // Seta todos os valores padrões do Whtasapp
        'icone_whatsapp' => !empty($matriz) ? 'sim' : 'nao',
        'popup_whatsapp' => 'nao',
        'form_wpp' => 'Selecione',
        'mostrar_whatsapp' => !empty($matriz) ? 'sim' : 'nao',
        'texto_do_botao' => '',
        'numero_whatsapp' => !empty($matriz) ? $matriz['whatsapp_full'] : '',
        'mensagem_whatsapp' => $testo_whatsapp,
        // Seta todos os valores padrões dos Detalhes
        'habilita_financiamentos' => 'nao',
        'layout_produto' => 'modelo1',
        'ordem_itens' => 'acessorio',
        'formatar_ano' => 'ano_modelo',
    );

    foreach ($defaults as $key => $value) {
        // Cria ou atualiza a opção com o valor fornecido
        update_option($key, $value);
    }

    /**
     * Menu principal único
     */
    if (!term_exists('principal', 'nav_menu')) {
        $menu = wp_insert_term('Principal', 'nav_menu', array('slug' => 'principal'));
        $menu_id = $menu['term_id'];
        $locations = get_theme_mod('nav_menu_locations');
        $locations['primary'] = $menu_id;
        set_theme_mod('nav_menu_locations', $locations);
    } else {
        $menu = wp_get_nav_menu_object('Principal');
        $menu_id = $menu->term_id;
    }

    // Chama a função para setar as localizações
    alt_set_menu_locations($menu_id);

    // Adicionar os itens do menu de acordo com as páginas do tema
    foreach ($paginas as $titulo => $dados) {
        $page = alt_get_page_by_title($titulo);
        if ($page && !alt_menu_item_exists($menu_id, $page->ID)) {
            wp_update_nav_menu_item($menu_id, 0, array(
                'menu-item-title' => $titulo,
                'menu-item-object-id' => $page->ID,
                'menu-item-object' => 'page',
                'menu-item-status' => 'publish',
                'menu-item-type' => 'post_type',
            ));
        }
    }

    /**
     * Definir paginas padrao
     */
    $home = alt_get_page_by_title('Home');

    if ($home) {
        update_option('show_on_front ', 'page');
        update_option('page_on_front ', $home->ID);
    }

    wp_redirect(admin_url('/admin.php?page=alt_group_setup'));
    exit;
}

// Função para verificar se o item de menu já existe
function alt_menu_item_exists($menu_id, $page_id) {
    $menu_items = wp_get_nav_menu_items($menu_id);
    foreach ($menu_items as $item) {
        if ($item->object_id == $page_id) {
            return true;
        }
    }
    return false;
}

function alt_set_menu_locations($menu_id) {
    // Definir localizações de menus: 'alt_main_menu' e 'footer_menu'
    $locations = get_theme_mod('nav_menu_locations'); // Obtém as localizações atuais dos menus

    // Associa o menu principal ao 'alt_main_menu' e ao 'footer_menu'
    $locations['alt_main_menu'] = $menu_id;
    $locations['footer_menu'] = $menu_id;

    // Salva as alterações nas localizações
    set_theme_mod('nav_menu_locations', $locations);
}

function alt_gerar_widget_tema($nome_tema) {
    $lista_widgets = array(
        'altimus5' => array(
            array('alt_portal_sobre', 'alt_sobre', array('show_about' => 'yes')),
            array('alt_portal_sobre', 'alt_home1', array('show_about' => 'yes')),
            array('alt_portal_noticias', 'alt_home2', array('show_about' => 'yes', 'total_noticias' => '4')),
            array('alt_portal_divulgacao', 'alt_divulgacao', array('show_about' => 'yes')),
            array('alt_portal_duvida', 'alt_home3', array('show_about' => 'yes')),
            array('categories', 'alt_blog_right', array('count' => 'checked')),
            array('alt_portal_contato', 'alt_contato', array('show_about' => 'yes')),
        ),
    );

    if (array_key_exists($nome_tema, $lista_widgets)) {
        foreach ($lista_widgets[$nome_tema] as $widget) {
            alt_set_widget_in_sidebar($widget[0], $widget[1], $widget[2]);
        }
    } 
    
}

function alt_set_widget_in_sidebar($widget_name, $sidebar_id, $widget_instance = array()) {
    // Obtém as configurações atuais das sidebars e widgets
    $sidebars_widgets = get_option('sidebars_widgets', array());
    $widget_instances = get_option("widget_$widget_name", array());

    // Verifica se a sidebar especificada existe
    if (!isset($sidebars_widgets[$sidebar_id])) {
        $sidebars_widgets[$sidebar_id] = array();
    }

    // // Adiciona os valores padrão ao widget, se necessário
    // $default_values = array(
    //     'show_about' => '', // Exemplo de campo padrão, pode ser ajustado
    // );
    // $widget_instance = wp_parse_args($fields, $default_values);

    // Adiciona a nova instância do widget ao banco de dados
    $widget_instances[] = $widget_instance;
    $new_instance_id = array_key_last($widget_instances);

    // Atualiza as instâncias do widget
    update_option("widget_$widget_name", $widget_instances);

    // Adiciona o widget à sidebar
    $sidebars_widgets[$sidebar_id][] = "$widget_name-$new_instance_id";
    update_option('sidebars_widgets', $sidebars_widgets);
}

function getAllItensMenu($id_menu)
{

    $arrReturn = [];
    $arrItensMenu = wp_get_nav_menu_items($id_menu);

    foreach ($arrItensMenu as $itens) {

        $arrReturn[] = $itens->object_id;
    };

    return $arrReturn;
}

function alt_create_menu_thema_5(){
    if(alt_current_theme('Altimus - Modelo 5')){
        $names = ['Venda', 'Simulação', 'Acessibilidade'];

        foreach ($names as $name) {
            
            if (!alt_get_page_by_title($name)) {
                $item_id = wp_insert_post(
                    array(
                        'comment_status' => 'close',
                        'ping_status' => 'close',
                        'post_author' => 1,
                        'post_title' => $name,
                        'post_name' => sanitize_title($name),
                        'post_status' => 'publish',
                        'post_content' => '',
                        'post_type' => 'page',
                        'post_parent' => ''
                    )
                );
        
                if (!metadata_exists('post', $item_id, '_wp_page_template')) {
                    update_post_meta($item_id, '_wp_page_template', 'page-'.sanitize_title($name).'.php');
                }
            };
        }
    }
}

function alt_all_pages(){
    $pages = [];
    $query = new WP_Query(
        array(
            'post_type'              => 'page',
            'post_status'            => 'all',
            'posts_per_page'         => -1,
            'no_found_rows'          => true,
            'ignore_sticky_posts'    => true,
            'update_post_term_cache' => false,
            'update_post_meta_cache' => false,
            'orderby'                => 'date',
            'order'                  => 'ASC',
        )
    );
    if ( $query->have_posts() ) {
        while ( $query->have_posts() ) {
            $query->the_post();
            $pages[] = esc_html( get_the_title() );
        }
        wp_reset_postdata();
        return $pages;
    }
}

//função para buscar as páginas no banco, a função original alt_get_page_by_title(), está depreciada.
function alt_get_page_by_title($page) {
    $query = new WP_Query(
        array(
            'post_type'              => 'page',
            'title'                  => $page,
            'post_status'            => 'all',
            'posts_per_page'         => 1,
            'no_found_rows'          => true,
            'ignore_sticky_posts'    => true,
            'update_post_term_cache' => false,
            'update_post_meta_cache' => false,
            'orderby'                => 'date',
            'order'                  => 'ASC',
        )
    );
    if ( ! empty( $query->post ) ) {
        $_post = $query->post;
        if ( ARRAY_A === OBJECT ) {
            return $_post->to_array();
        } elseif ( ARRAY_N === OBJECT ) {
            return array_values( $_post->to_array() );
        }
        return $_post;
    }
    return null;
}

function alt_current_theme($name){
    if(wp_get_theme() == $name){
        return true;
    }
}