<?php

add_action('cmb2_admin_init', 'cores');

function cores()
{
    //GERENCIAR CORES


    $cmb_cores = new_cmb2_box(array(
        'id' => 'alt_setup_cores',
        'title' => 'Configuração de cores',
        'object_types' => array('options-page'),
        'option_key' => 'alt_group_cores', // The option key and admin menu page slug.
        'parent_slug' => 'alt_group_setup', // Make options page a submenu item of the themes menu.
    ));


    $default_cores = [
        'orange' => 'Laranja',
        'black' => 'Preto',
        'blue' => 'Azul',
        'red' => 'Vermelho',
        'green' => 'Verde',
        'altimus' => 'Personalizada',
    ];

    if (function_exists('get_lista_cores_array')) {
        $default_cores = get_lista_cores_array();
    }

    $cores_por_tema = $default_cores;


    $cmb_cores->add_field(array(
        'after_row' => '<hr/>',
        'name' => 'Escolha a paleta de cores',
        'desc' => 'Selecione uma das paletas de cores',
        'id' => 'paleta_cores',
        'type' => 'select',
        'default' => 'altimus',
        'options' => $cores_por_tema,
    ));

    $cmb_cores->add_field(array(
        'before_row' => '<h1>Cores personalizadas</h1><hr/>',
        'name' => 'Cor primária',
        'desc' => 'Selecione a cor primária do site - default #1e73be',
        'id' => 'cor_primaria',
        'type' => 'colorpicker',
        'default' => '#1e73be',
    ));
    $cmb_cores->add_field(array(
        'name' => 'Cor secundária',
        'desc' => 'Selecione a cor secundaria do site - default #000000',
        'id' => 'cor_secundaria',
        'type' => 'colorpicker',
        'default' => '#000000',
    ));
    $cmb_cores->add_field(array(
        'name' => 'Cor fundo',
        'desc' => 'Cor de Fundo Dark #363636',
        'id' => 'cor_fundo',
        'type' => 'colorpicker',
        'default' => '#ffffff',
    ));
    $cmb_cores->add_field(array(
        'name' => 'Cor fundo da logo - Empresa - Modelo 5',
        'desc' => 'Cor de fundo no quadrado da página empresa do modelo 5',
        'id' => 'cor_fundo_logo_empresa',
        'type' => 'colorpicker',
        'default' => '',
    ));
    $cmb_cores->add_field(array(
        'name' => 'Cor do Cabecalho e rodapé - Modelo 5',
        'desc' => 'Cor de fundo do cabeçalho e rodapé no modelo 5',
        'id' => 'cor_cabecalho_rodape',
        'type' => 'colorpicker',
        'default' => '',
    ));
    $cmb_cores->add_field(array(
        'name' => 'Cor topbar - Modelo 5',
        'desc' => 'Cor da barra superior no topo do modelo 5',
        'id' => 'cor_topbar',
        'type' => 'colorpicker',
        'default' => '',
    ));
    $cmb_cores->add_field(array(
        'name' => 'Cor dos textos Cabecalho e rodapé - Modelo 5',
        'desc' => 'Cor dos textos no cabeçalho e rodapé no modelo 5',
        'id' => 'cor_textos_header_footer',
        'type' => 'colorpicker',
        'default' => '',
    ));
}

if (!function_exists('get_paleta_de_cores')) {
    function get_paleta_de_cores()
    {
        $dados = get_option('alt_group_cores');
        return $dados['paleta_cores'] ?? 'altimus';
    }
}

if (!function_exists('get_cor')) {
    function get_cor($tipo)
    {
        $dados = get_option('alt_group_cores');
        if (!empty($dados[$tipo])) {
            return $dados[$tipo];
        }
        return '';
    }
}

function cores_plugin_enqueue_scripts(){
    wp_enqueue_script('altimus-dynamic-fields.js', plugin_dir_url('altimus') . '/altimus/assets/js/altimus-dynamic-fields.js', array('jquery'), VERSION_PLUGIN_ALTIMUS, true);
}
add_action('admin_enqueue_scripts', 'cores_plugin_enqueue_scripts');