<?php
add_action('cmb2_admin_init', 'config_integracao');

function config_integracao() 
{
    $cmb_options = new_cmb2_box(array(
        'id' => 'alt_setup_integracao',
        'title' => 'Configuração de Integração',
        'object_types' => array('options-page'),
        'option_key' => 'alt_group_integracao',
        'parent_slug' => 'alt_group_setup',
        'menu_title' => 'Configuração de Integração', // Título que aparecerá no menu
        'capability' => 'manage_options', // Permissão necessária
        'position' => 5, // Posição após "Configuração detalhes do veículo"
    ));

    $cmb_options->add_field(array(
        'name' => 'Ativar Credere',
        'desc' => '',
        'id' => 'alt_credere_status',
        'type' => 'select',
        'default' => 'inativo',
        'options' => array(
            'ativo' => 'Ativo',
            'inativo' => 'Inativo',
        ),
    ));

    $cmb_options->add_field(array(
        'name' => 'Cliente Credere',
        'desc' => 'Selecione se o Credere será exibido usando o CNPJ da Matriz ou da Loja',
        'id' => 'alt_credere_cliente',
        'type' => 'select',
        'default' => 'matriz',
        'options' => array(
            'matriz' => 'Matriz',
            'loja' => 'Loja',
        ),
    ));
}

/**
 * Função que verifica se a integração do credere está ativa.
 * 
 * @return bool True se a integração estiver ativa, false caso contrário.
 */
function alt_credere_ativado()
{
    $options = get_option('alt_group_integracao');
    $credere = isset($options['alt_credere_status']) ? $options['alt_credere_status'] : 'inativo';
    return $credere === 'ativo';
}

/**
 * Função que verifica se a loja ou a matriz tem cnpj.
 * Caso exista um cnpj, o script de integração do credere é exibido/chamado.
 * 
 * @param int $post_id ID do post da loja.
 * 
 */
function alt_credere_get_cnpj($post_id)
{
    $cnpj = '';
    $cliente = alt_credere_get_cliente();
    
    if ($cliente === 'matriz') {
        $dados_matriz = alt_get_dados_matriz(); 
        $cnpj = $dados_matriz['cnpj'];
    } elseif ($cliente === 'loja') {
        $dados_loja = alt_get_dados_loja($post_id);
        $cnpj = $dados_loja['cnpj'];
    }

    if (empty($cnpj)) {
        return '';
    }
    return $cnpj;
}

function alt_credere_cnpj($post_id)
{
    $cnpj = alt_credere_get_cnpj($post_id);
    
    if (!empty($cnpj)) {
        echo '<script src="https://app.meucredere.com.br/simulador/loja/' . $cnpj . '/veiculo/detectar.js"></script>';
    }
}

function alt_credere_existe_cnpj($post_id)
{
    $cnpj = alt_credere_get_cnpj($post_id);

    if (!empty($cnpj)) {
        return true;
    }
}

/**
 * Função que retorna o cliente configurado para o Credere
 * 
 * @return string|'' 'matriz', 'loja' ou string vazia se não existir
 */
function alt_credere_get_cliente()
{
    $options = get_option('alt_group_integracao');
    return isset($options['alt_credere_cliente']) ? $options['alt_credere_cliente'] : '';
}