<?php


if (!function_exists('alt_carregar_schema')) {

    function alt_carregar_schema($post)
    {
        global $post;
        if (isset($post)) {
            
            $empresa = get_info_principal(true);

            $nome_da_loja = $empresa['nome_fantasia'] ?? '';
            $logo_loja = alt_get_url_logo();
            $site_loja = get_home_url();
            $valor_veiculo = get_preco_veiculo($post->ID) ?? '';
            $cidade_da_loja = $empresa['cidade'] ?? '';
            $estado_da_loja = $empresa['estado'] ?? '';
            $endereco_da_loja = $empresa['endereco'] ?? '';
            $telefone_da_loja = !empty($empresa['telefone']) ? formatarNumero($empresa['telefone']) : '';

            if (empty($empresa['nome_fantasia'])) {
                echo "<div class='alert alert-danger' style='font-size: 24px;'><strong>Atenção:</strong> Informe o titulo da revenda matriz</div>";
            }

            if ($post->post_type == 'veiculos') {

                $arrImagens = alt_get_caracteristicas($post->ID, 'alt_imagens');
                $lista_imagens = array_slice($arrImagens, 0, 1);
                $url_imagem = array_shift($lista_imagens);


                $titulo = alt_formatar_titulo($post->ID);
                $descricao = $post->post_content;
                $cor = alt_get_caracteristicas($post->ID, 'alt_cor') ?? 'Não definida';
                $ano_modelo = alt_get_caracteristicas($post->ID, 'alt_ano_mod') ?? 'Não definida';
                $cambio = alt_get_caracteristicas($post->ID, 'alt_cambio') ?? 'Não definida';

                $objCarroceria = get_the_terms($post->ID, 'carroceria');
                $carroceria = $objCarroceria[0]->name ?? 'Hatchback';



                $portas = alt_get_caracteristicas($post->ID, 'alt_portas') ?? 'Não definida';
                $combustivel = alt_get_caracteristicas($post->ID, 'alt_combustivel') ?? 'Não definida';
                $quilometragem = alt_get_caracteristicas($post->ID, 'alt_kilometragem') ?? 'Não definida';
                $marca = alt_get_marca_modelo_tipo($post->ID, 'marca') ?? 'Não definida';
                $modelo = alt_get_marca_modelo_tipo($post->ID, 'modelo') ?? 'Não definida';

                $cars = array(
                    '@context' => 'https://schema.org/',
                    '@type' => 'Product',
                    'name' => $titulo,
                    'image' => $url_imagem ?? 'https://cdn-wp-altimus.s3-sa-east-1.amazonaws.com/imagens/veiculo-sem-foto.jpg',
                    'description' => $descricao,
                    'brand' => array(
                        '@type' => 'Brand',
                        'name' => $marca
                    ),
                    'offers' => array(
                        '@type' => 'Offer',
                        'url' => get_permalink(),
                        'priceCurrency' => 'BRL',
                        'price' => alt_get_caracteristicas($post->ID, 'alt_preco'),
                        'availability' => 'https://schema.org/InStock'
                    ),
                );
                echo "<script type=\"application/ld+json\">" . json_encode($cars) . "</script>";
            }

            /**
             * Json LocalBusiness
             */

            $localBusiness = array(
                '@context' => 'https://schema.org',
                '@type' => 'LocalBusiness',
                'name' => $nome_da_loja,
                'image' => $logo_loja,
                'url' => $site_loja,
                'telephone' => $telefone_da_loja,
                'address' => array(
                    '@type' => 'PostalAddress',
                    'streetAddress' => $endereco_da_loja,
                    'addressLocality' => $cidade_da_loja,
                    'addressCountry' => 'BR'
                )
            );


            $facebook = get_social_links('facebook');
            $instagram = get_social_links('instagram');
            $youtube = get_social_links('youtube');

            if (!empty($facebook)) {
                $localBusiness['sameAs'][] = $facebook;
            }
            if (!empty($instagram)) {
                $localBusiness['sameAs'][] = $instagram;
            }
            if (!empty($youtube)) {
                $localBusiness['sameAs'][] = $youtube;
            }

            echo "<script type=\"application/ld+json\">" . json_encode($localBusiness) . "</script>";
        }
    }

    add_action('after_body_open_tag', 'alt_carregar_schema', 10, 1);
}