<?php

if (!function_exists('alt_portal_get_noticias')) {
    function alt_portal_get_noticias($total)
    {
        $args = array(
            'post_type' => 'post',
            'posts_per_page' => $total,
            'post_status' => 'publish',
            'orderBy' => 'date',
            'order' => 'asc'

        );

        $query = new WP_Query($args);

        if ($query->have_posts()){
            return $query;
        }
    }
}

/**
 * Verifica se o site é um portal de associações
 *
 * @return boolean
 */
function alt_is_portal()
{
    $dados = get_option('alt_group_setup');
    if (!empty($dados['tipo_site']) && $dados['tipo_site'] == 'altimusportal') {
        return true;
    }
    return false;
}

/**
 * Retorna o destinatário do portal
 *
 * @return string
 */
function alt_get_portal_destinatario()
{
    $dados = get_option('alt_portal_config');
    if (!empty($dados['portal_destinatario'])) {
        return $dados['portal_destinatario'];
    }
    return '';
}

/**
 * Verifica se deve exibir os nomes das lojas no portal
 *
 * @return boolean
 */
function alt_get_portal_exibir_nomes()
{
    $dados = get_option('alt_portal_config');
    if (alt_is_portal() && !empty($dados['portal_exibicao_nomes']) && $dados['portal_exibicao_nomes'] == 'sim') {
        return true;
    }
    return false;
}

/**
 * Verifica se deve exibir estoque das lojas no portal
 * A lógica: se o site é um portal de associações e o estoque estiver desabilitado, retorna false
 * todos os demais casos, retorna true
 *
 * @return boolean
 */

function alt_get_portal_exibir_estoque()
{
    $dados = get_option('alt_portal_config');
    if (alt_is_portal() && !empty($dados['portal_exibir_estoque']) && $dados['portal_exibir_estoque'] == 'nao') {
        return false;
    }
    return true;
}

/**
 * Verifica a quantidade de veículos por loja que deve exibido nos destaques
 * A lógica: se houver essa informação no banco, será retornado,
 * todos os demais casos, retorna 1
 *
 * @return integer
 */

function alt_total_veiculos_destaque()
{
    $dados = get_option('alt_portal_config');
    if (isset($dados) && !empty($dados['portal_quantidade_veiculo_destaque'])) {
        return $dados['portal_quantidade_veiculo_destaque'];
    }
    return 1;
}