<?php
/**
 * Agrupamento de configurações relativas ao portal
 */

// Função para adicionar o menu "Portal" e submenus
function alt_add_menu() {
    // Cria o menu principal "Portal"
    add_menu_page(
        'Portal', // Título da página
        'Configurações do Portal de Associações', // Título do menu
        'manage_options', // Capacidade necessária
        'portal', // Slug do menu
        'alt_exibir_pagina_portal', // Função de callback para a página de "Portal"
        'dashicons-admin-site', // Ícone do menu
        998 // Posição no menu
    );

    // Adiciona "Agenda" como submenu de "Portal"
    add_submenu_page(
        'portal', // Slug do menu pai
        'Agenda', // Título da página
        'Agenda', // Título do submenu
        'manage_options', // Capacidade necessária
        'edit.php?post_type=agenda' // URL para gerenciar parcerias
    );
    
    // Adiciona "Gestor" como submenu de "Portal"
    add_submenu_page(
        'portal', // Slug do menu pai
        'Gestor', // Título da página
        'Gestor', // Título do submenu
        'manage_options', // Capacidade necessária
        'edit.php?post_type=gestor' // URL para gerenciar parcerias
    );

    // Adiciona "Parcerias" como submenu de "Portal"
    add_submenu_page(
        'portal', // Slug do menu pai
        'Lojas', // Título da página
        'Lojas', // Título do submenu
        'manage_options', // Capacidade necessária
        'edit.php?post_type=lojas' // URL para gerenciar parcerias
    );

    // Adiciona "Parcerias" como submenu de "Portal"
    add_submenu_page(
        'portal', // Slug do menu pai
        'Parcerias', // Título da página
        'Parcerias', // Título do submenu
        'manage_options', // Capacidade necessária
        'edit.php?post_type=parcerias' // URL para gerenciar parcerias
    );
}
add_action('admin_menu', 'conditional_alt_add_menu');

function conditional_alt_add_menu() {
    if (alt_is_portal()) {
        alt_add_menu();
    }
}

// Função de callback para a página de "Portal"
function alt_exibir_pagina_portal() {
    // Conteúdo da página
    echo '<div class="wrap">';
    echo '<h1>Configurações do Portal de Associações</h1>';

    // Formulário simples para uma configuração do portal
    echo '<form method="post" action="options.php">';
    
    // Campos de configuração (exemplo)
    settings_fields('alt_portal_options_group'); // Define o grupo de opções
    do_settings_sections('alt_portal_options_page'); // Seções e campos definidos em outro ponto
    
    submit_button('Salvar Configurações');
    echo '</form>';

    echo '</div>';
}

function alt_registrar_configuracoes_portal() {
    // Registrar as configurações
    register_setting('alt_portal_options_group', 'alt_portal_config');

    // Adicionar uma seção à página de configurações
    add_settings_section(
        'alt_portal_section', 
        'Configurações Gerais do Portal', 
        '', 
        'alt_portal_options_page'
    );

    // Adicionar campo de seleção do destinatário
    add_settings_field(
        'alt_portal_select', 
        'Selecionar Destinatário', 
        'alt_portal_selecionar_destinatario', 
        'alt_portal_options_page', 
        'alt_portal_section'
    );
    
    // Adicionar campo de seleção de exibição
    add_settings_field(
        'alt_portal_exibir_nomes', 
        'Exibir Nomes das lojas', 
        'alt_portal_selecionar_exibicao_nomes', 
        'alt_portal_options_page', 
        'alt_portal_section'
    );
    
    // Adicionar campo de seleção de exibição de estoque
    add_settings_field(
        'alt_portal_exibir_estoque', 
        'Exibir Estoque', 
        'alt_portal_selecionar_exibir_estoque', 
        'alt_portal_options_page', 
        'alt_portal_section'
    );
    
    // Adicionar campo de seleção da quantidade de exibição nos destaques por loja
    add_settings_field(
        'alt_portal_quantidade_veiculo_destaque', 
        'Veículos por loja nos destaques', 
        'alt_portal_quantidade_veiculo_destaque_loja', 
        'alt_portal_options_page', 
        'alt_portal_section'
    );
    
    // Adicionar campo de seleção para o limite de inatividade da loja
    add_settings_field(
        'alt_portal_limite_intividade', 
        'Limite de Inatividade',
        'alt_portal_selecionar_limite_inatividade',
        'alt_portal_options_page', 
        'alt_portal_section'
    );
}
add_action('admin_init', 'alt_registrar_configuracoes_portal');

// Exibe o campo "Selecionar Destinatário" com descrição abaixo
function alt_portal_selecionar_destinatario() {
    $config = get_option('alt_portal_config');
    $select_value = isset($config['portal_destinatario']) ? esc_attr($config['portal_destinatario']) : '';

    // Renderiza o campo select
    echo '<select name="alt_portal_config[portal_destinatario]">';
    echo '<option value="associacao" ' . selected($select_value, 'associacao', false) . '>Portal de Associações</option>';
    echo '<option value="lojas" ' . selected($select_value, 'lojas', false) . '>Lojas Parceiras</option>';
    echo '</select>';

    // Adiciona a descrição abaixo do select
    echo '<p class="description">Selecione o destinatário que receberá as leads relacionadas aos veículos.</p>';
}

// Exibe o campo "Exibição de nomes" com descrição abaixo
function alt_portal_selecionar_exibicao_nomes() {
    $config = get_option('alt_portal_config');
    $select_value = isset($config['portal_exibicao_nomes']) ? esc_attr($config['portal_exibicao_nomes']) : '';

    // Renderiza o campo select
    echo '<select name="alt_portal_config[portal_exibicao_nomes]">';
    echo '<option value="sim" ' . selected($select_value, 'sim', false) . '>Sim</option>';
    echo '<option value="nao" ' . selected($select_value, 'nao', false) . '>Não</option>';
    echo '</select>';

    // Adiciona a descrição abaixo do select
    echo '<p class="description">Selecione se será exibido os nomes das lojas ou não.</p>';
}

// Exibe o campo "Exibição de estoque" com descrição abaixo
function alt_portal_selecionar_exibir_estoque() {
    $config = get_option('alt_portal_config');
    $select_value = isset($config['portal_limite_inatividade']) ? esc_attr($config['portal_limite_inatividade']) : '';

    // Renderiza o campo select
    echo '<select name="alt_portal_config[portal_exibir_estoque]">';
    echo '<option value="sim" ' . selected($select_value, 'sim', false) . '>Sim</option>';
    echo '<option value="nao" ' . selected($select_value, 'nao', false) . '>Não</option>';
    echo '</select>';

    // Adiciona a descrição abaixo do select
    echo '<p class="description">Selecione se será exibido estoque de veículos.</p>';
}

// Exibe o campo "Limite de Inatividade" com descrição abaixo
function alt_portal_selecionar_limite_inatividade() {
    $config = get_option('alt_portal_config');
    $select_value = isset($config['portal_limite_inatividade']) ? esc_attr($config['portal_limite_inatividade']) : '90';

    // Renderiza o campo select
    echo '<select name="alt_portal_config[portal_limite_inatividade]">';
    echo '<option value="30" ' . selected($select_value, '30', false) . '>30 dias</option>';
    echo '<option value="60" ' . selected($select_value, '60', false) . '>60 dias</option>';
    echo '<option value="90" ' . selected($select_value, '90', false) . '>90 dias</option>';
    echo '<option value="120" ' . selected($select_value, '120', false) . '>120 dias</option>';
    echo '</select>';

    // Adiciona a descrição abaixo do select
    echo '<p class="description">Selecione o limite de inatividade permitido para loja. (Padrão: 90 dias)</p>';
}

// Exibe o campo "Quantidade de veículos à ser exibido nos destaques por loja"
function alt_portal_quantidade_veiculo_destaque_loja() {
    $config = get_option('alt_portal_config');
    $select_value = isset($config['portal_quantidade_veiculo_destaque']) ? esc_attr($config['portal_quantidade_veiculo_destaque']) : '';

    // Renderiza o campo select
    echo '<select name="alt_portal_config[portal_quantidade_veiculo_destaque]">';
    echo '<option value="1" ' . selected($select_value, '1', false) . '>1</option>';
    echo '<option value="2" ' . selected($select_value, '2', false) . '>2</option>';
    echo '<option value="3" ' . selected($select_value, '3', false) . '>3</option>';
    echo '<option value="4" ' . selected($select_value, '4', false) . '>4</option>';
    echo '<option value="5" ' . selected($select_value, '5', false) . '>5</option>';
    echo '</select>';

    // Adiciona a descrição abaixo do select
    echo '<p class="description">Selecione a quantidade de veículos exibidos nos destaques.</p>';
}