<?php
add_action('cmb2_init', 'alt_metabox_gestor');
/**
 * Define the metabox and field configurations.
 */
function alt_metabox_gestor()
{


    // Start with an underscore to hide fields from custom fields list
    $prefix = 'alt_';

    /**
     * Initiate the metabox
     */
    $cmb = new_cmb2_box(array(
        'id' => 'field_gestor',
        'title' => 'Gestor',
        'object_types' => array('gestor'), // Post type
        'context' => 'normal',
        'priority' => 'high',
        'show_names' => true,
        'show_in_rest' => false,
    ));

    $cmb->add_field(array(
        'name' => 'Imagem',
        'desc' => 'Selecione a imagem do gestor.',
        'id' => $prefix . 'gestor_imagem',
        'type' => 'file',
        'options' => array(
            'url' => true, // Hide the text input for the url
        ),
        'text' => array(
            'add_upload_file_text' => 'Adicionar arquivo' // Change upload button text. Default: "Add or Upload File"
        ),
        'preview_size' => 'thumbnail',
    ));

    $cmb->add_field(array(
        'name' => 'Cargo',
        'desc' => 'Informe o cargo do gestor.',
        'id' => $prefix . 'gestor_cargo',
        'type' => 'text',
    ));

    $cmb->add_field(array(
        'name' => 'Ordem de exibição',
        'desc' => 'Ordem de exibição do gestor. Quanto maior o número, maior a prioridade.',
        'id' => $prefix . 'gestor_ordem',
        'type' => 'text_small',
        'attributes' => array(
            'type' => 'number',
        ),
    ));

}

