<?php
add_action('cmb2_init', 'alt_metabox_agenda');
/**
 * Define the metabox and field configurations.
 */
function alt_metabox_agenda()
{
    $prefix = 'alt_';

    /**
     * Initiate the metabox
     */
    $cmb = new_cmb2_box(array(
        'id' => 'field_agenda',
        'title' => 'Agenda',
        'object_types' => array('agenda'), // Post type
        'context' => 'normal',
        'priority' => 'high',
        'show_names' => true,
        'show_in_rest' => false,
    ));

    $cmb->add_field(array(
        'name' => 'Data',
        'desc' => 'Data do evento',
        'id' => $prefix . 'agenda_data',
        'type' => 'text_date',
        'date_format' => 'd-m-Y',
        'repeatable' => true,
    ));

    $cmb->add_field(array(
        'name' => 'Hora',
        'desc' => 'Hora do evento',
        'id' => $prefix . 'agenda_hora',
        'type' => 'text_time',
        'time_format' => 'H:i',
    ));

    $cmb->add_field(array(
        'name' => 'Link',
        'desc' => 'Link para o evento',
        'id' => $prefix . 'agenda_link',
        'type' => 'text_url',
        'protocols' => array('http', 'https'),

    ));
}
