<?php
/*
* Controla o comportamento no Dashboard quando o site é do tipo Portal.
* Adicione aqui os widgets que você deseja adicionar ou remover do dashboard.
*/

// Primeiro, adicione um hook para inicialização
add_action('init', 'alt_inicializar_configuracoes_dashboard');

/**
 * Inicializa as configurações do dashboard após o WordPress estar completamente carregado
 */
function alt_inicializar_configuracoes_dashboard() {
    // Agora é seguro verificar permissões
    if(alt_is_portal() && (current_user_can('associacao') || current_user_can('lojista'))) {
        add_action('wp_dashboard_setup', 'alt_remover_widgets_dashboard');
        add_action('wp_dashboard_setup', 'alt_adicionar_widgets_personalizados_dashboard');
    }
}

/**
 * Esta função remove os widgets padrão do dashboard do WordPress.
 * Você pode adicionar ou remover widgets conforme necessário.
 */
function alt_remover_widgets_dashboard() {
    remove_meta_box('dashboard_activity', 'dashboard', 'normal'); // Atividade
    remove_meta_box('dashboard_right_now', 'dashboard', 'normal'); // Agora mesmo
    remove_meta_box('dashboard_recent_comments', 'dashboard', 'normal'); // Comentários recentes
    remove_meta_box('dashboard_incoming_links', 'dashboard', 'normal'); // Links de entrada
    remove_meta_box('dashboard_plugins', 'dashboard', 'normal'); // Plugins
    remove_meta_box('dashboard_quick_press', 'dashboard', 'side'); // Rascunho rápido
    remove_meta_box('dashboard_recent_drafts', 'dashboard', 'side'); // Rascunhos recentes
    remove_meta_box('dashboard_primary', 'dashboard', 'side'); // Blog do WordPress
    remove_meta_box('dashboard_secondary', 'dashboard', 'side'); // Outras notícias do WordPress
    remove_meta_box('e-dashboard-overview', 'dashboard', 'normal'); // Outras notícias do WordPress
    remove_meta_box('dashboard_site_health', 'dashboard', 'normal'); // Outras notícias do WordPress
}

/**
 * Esta função adiciona widgets personalizados ao dashboard do WordPress.
 * Você pode adicionar ou remover widgets conforme necessário.
 */
function alt_adicionar_widgets_personalizados_dashboard() {
    // Remove containers vazios
    echo '<style>#wpbody-content #dashboard-widgets .empty-container { display: none; }</style>';
    
    // Widget Links Importantes - Coluna Esquerda
    add_meta_box(
        'meu_widget_links_importantes',
        'Links Importantes',
        'alt_exibir_links_importantes',
        'dashboard',
        'normal',
        'high'
    );

}


/**
 * Callback para exibir o conteúdo do widget Links Importantes
 */
function alt_exibir_links_importantes() {
    ?>
    <div class="dashboard-widget-content">
        <ul>
            <li><a href="<?php echo admin_url('admin.php?page=usuario_loja'); ?>">Gerenciar Usuários e Lojas</a></li>
            <li><a href="<?php echo admin_url('profile.php'); ?>">Editar Perfil</a></li>
            <!-- Adicione mais links conforme necessário -->
        </ul>
    </div>
    <?php
}

