<?php
if (!defined('ABSPATH')) {
    exit;
}
?>

<div class="wrap">
    <h1><?php echo esc_html(get_admin_page_title()); ?></h1>
    
    <div id="poststuff">
        <div id="post-body" class="metabox-holder columns-2">
            <!-- Coluna principal -->
            <div id="post-body-content">
                <!-- Mova o formulário existente para aqui -->
                <div class="postbox">
                    <form method="post" action="<?php echo esc_url(admin_url('admin.php?page=usuario_loja')); ?>" 
                          class="postbox" 
                          enctype="multipart/form-data" 
                          id="form_usuario_loja"
                          style="margin-bottom: 0px !important;">
                        <?php wp_nonce_field('usuario_loja', 'editar_usuario_loja_nonce'); ?>
                        <input type="hidden" name="modo" value="editar">
                        <input type="hidden" name="user_id" value="<?php echo esc_attr($dados_edicao['user']->ID); ?>">
                        <input type="hidden" name="loja_id" value="<?php echo esc_attr($dados_edicao['loja']->ID); ?>">
                        
                        <div class="postbox-header" id="poststuff">
                            <h2>Dados do Usuário</h2>
                        </div>
                        <div class="inside">
                            <table class="form-table">
                                <!-- Campos do Usuário -->
                                <tr>
                                    <th><label for="editar_username">Nome de Usuário</label></th>
                                    <td>
                                        <input type="text" name="username" id="editar_username" 
                                               value="<?php echo esc_attr($dados_edicao['user']->display_name); ?>" 
                                               class="regular-text" required autocomplete="name">
                                        <p class="description">Nome que será exibido publicamente.</p>

                                    </td>
                                </tr>
                                <tr>
                                    <th><label for="editar_email">E-mail</label></th>
                                    <td>
                                        <input type="email" name="email" id="editar_email" 
                                               value="<?php echo esc_attr($dados_edicao['user']->user_email); ?>" 
                                               class="regular-text" required autocomplete="email">
                                        <p class="description">Se alterado, <strong style="color: #b80707;">atualizar a informação no Altimus também.<strong></strong></p>
                                    </td>
                                </tr>
                                <tr>
                                    <th><label for="editar_password">Nova Senha</label></th>
                                    <td>
                                        <input type="password" name="password" id="editar_password" 
                                               class="regular-text" autocomplete="new-password">
                                        <p class="description">Se alterado, <strong style="color: #b80707;">atualizar a informação no Altimus também.<strong></strong></p>
                                    </td>
                                </tr>
                                <tr>
                                    <th><label for="editar_nome_login">Usuário integração</label></th>
                                    <td>
                                        <input type="text" name="password" id="editar_nome_login" 
                                               class="regular-text" disabled 
                                               value="<?php echo esc_attr($dados_edicao['user']->user_login); ?>">
                                        <p class="description">Atenção. <strong>Campo utilizado para fazer integração no Altimus ou plataforma terceira.<strong></strong></p>
                                    </td>
                                </tr>
                            </table>
                        </div>

                        <div class="postbox-header" style="border-top: 1px solid #c3c4c7;">
                            <h2>Dados da Loja</h2>
                        </div>
                        <div class="inside">
                            <table class="form-table">
                                <!-- Campos da Loja -->
                                <tr>
                                    <th><label for="editar_nome_loja">Nome da Loja*</label></th>
                                    <td>
                                        <input type="text" name="nome_loja" id="editar_nome_loja" 
                                               value="<?php echo esc_attr($dados_edicao['loja']->post_title); ?>" 
                                               class="regular-text" required autocomplete="organization">
                                        <p class="description">Nome que será exibido ao longo do site.<br><b>*Campo obrigatório.</b></p>
                                    </td>
                                </tr>
                                <tr>
                                    <th><label for="editar_tipo_integracao">Tipo de integração</label></th>
                                    <td>
                                        <select name="tipo_integracao" id="editar_tipo_integracao" class="regular-text">
                                            <option value="altimus" <?php selected($dados_edicao['loja_meta']['tipo_integracao'], 'altimus'); ?>>Altimus</option>
                                            <option value="api" <?php selected($dados_edicao['loja_meta']['tipo_integracao'], 'api'); ?>>API</option>
                                            <option value="json" <?php selected($dados_edicao['loja_meta']['tipo_integracao'], 'json'); ?>>Leitura JSON</option>
                                        </select>
                                        <p class="description">Selecionar a forma que os veículos serão recebidos no site. O padrão é Altimus.</p>
                                    </td>
                                </tr>
                                <tr id="json_url_row">
                                    <th><label for="editar_json_url">URL do JSON*</label></th>
                                    <td>
                                        <input type="url" name="json_url" id="editar_json_url" 
                                               value="<?php echo esc_url($dados_edicao['loja_meta']['json_url']); ?>" 
                                               class="regular-text">
                                        <p class="description">Informe a URL onde o JSON com os veículos está localizado. <br><b>*Campo obrigatório quando tipo de integração for JSON</b></p>
                                    </td>
                                </tr>
                                <tr>
                                    <th><label for="editar_whatsapp">WhatsApp*</label></th>
                                    <td>
                                        <input type="text" name="whatsapp" id="editar_whatsapp" 
                                               value="<?php echo esc_attr($dados_edicao['loja_meta']['whatsapp']); ?>" 
                                               class="regular-text" required autocomplete="tel">
                                        <p class="description">Informe apenas os números.<br><b>*Campo obrigatório.</b></p>
                                    </td>
                                </tr>
                                <tr>
                                    <th><label for="editar_link_loja">Link da Loja*</label></th>
                                    <td>
                                        <input type="url" name="link_loja" id="editar_link_loja" 
                                               value="<?php echo esc_url($dados_edicao['loja_meta']['link']); ?>" 
                                               class="regular-text" required>
                                        <p class="description">URL do site da loja.<br><b>*Campo obrigatório.</b></p>
                                    </td>
                                </tr>
                                <tr>
                                    <th><label for="editar_cnpj">CNPJ</label></th>
                                    <td>
                                        <input type="text" name="cnpj" id="editar_cnpj" 
                                        value="<?php echo esc_attr($dados_edicao['loja_meta']['cnpj']); ?>" 
                                        class="regular-text">
                                        <p class="description">Informe apenas os números.</p>
                                    </td>
                                </tr>
                                <tr>
                                    <th><label for="editar_frase">Frase/Slogan</label></th>
                                    <td>
                                        <input type="text" name="frase" id="editar_frase" 
                                               value="<?php echo esc_attr($dados_edicao['loja_meta']['frase']); ?>" 
                                               class="regular-text">
                                        <p class="description">Slogan ou frase de efeito da empresa</p>
                                    </td>
                                </tr>
                                <tr>
                                    <th><label for="editar_telefone">Telefone</label></th>
                                    <td>
                                        <input type="text" name="telefone" id="editar_telefone" 
                                               value="<?php echo esc_attr($dados_edicao['loja_meta']['telefone']); ?>" 
                                               class="regular-text" autocomplete="tel">
                                        <p class="description">Informe apenas os números.</p>
                                    </td>
                                </tr>
                                <tr>
                                    <th><label for="editar_email_loja">E-mail da Loja</label></th>
                                    <td>
                                        <input type="email" name="email_loja" id="editar_email_loja" 
                                               value="<?php echo esc_attr($dados_edicao['loja_meta']['email']); ?>" 
                                               class="regular-text" autocomplete="email">
                                    </td>
                                </tr>
                                <tr>
                                    <th><label for="editar_endereco">Endereço</label></th>
                                    <td>
                                        <input type="text" name="endereco" id="editar_endereco" 
                                               value="<?php echo esc_attr($dados_edicao['loja_meta']['endereco']); ?>" 
                                               class="regular-text" autocomplete="street-address">
                                    </td>
                                </tr>
                                <tr>
                                    <th><label for="editar_cidade">Cidade</label></th>
                                    <td>
                                        <input type="text" name="cidade" id="editar_cidade" 
                                               value="<?php echo esc_attr($dados_edicao['loja_meta']['cidade']); ?>" 
                                               class="regular-text" autocomplete="address-level2">
                                    </td>
                                </tr>
                                <tr>
                                    <th><label for="editar_estado">Estado</label></th>
                                    <td>
                                        <select name="estado" id="editar_estado" class="regular-text" autocomplete="address-level1">
                                            <?php
                                            $estados = alt_get_lista_estados(); // Obtém a lista de estados
                                            foreach ($estados as $sigla => $nome) {
                                                echo '<option value="' . esc_attr($sigla) . '" ' . selected($dados_edicao['loja_meta']['estado'], $sigla, false) . '>' . esc_html($nome) . '</option>';
                                            }
                                            ?>
                                        </select>
                                    </td>
                                </tr>
                                <tr>
                                    <th><label for="editar_cep">CEP</label></th>
                                    <td>
                                        <input type="text" name="cep" id="editar_cep" 
                                               value="<?php echo esc_attr($dados_edicao['loja_meta']['cep']); ?>" 
                                               class="regular-text" autocomplete="postal-code">
                                        <p class="description">Informe apenas os números.</p>
                                    </td>
                                </tr>
                                <tr>
                                    <th><label for="editar_google_maps">Link Google Maps</label></th>
                                    <td>
                                        <input type="url" name="google_maps" id="editar_google_maps" 
                                               value="<?php echo esc_url($dados_edicao['loja_meta']['google_maps']); ?>" 
                                               class="regular-text">
                                        <p class="description">URL da localização no Google Maps</p>
                                    </td>
                                </tr>
                                <tr>
                                    <th><label for="editar_logo">Logo da loja</label></th>
                                    <td>
                                        <?php 
                                            $logo_atual = get_post_meta($dados_edicao['loja_meta']['loja_id'], 'alt_lojas_logo', true);

                                            if ($logo_atual) {
                                                // Gera o URL completo se o valor for relativo
                                                if (!filter_var($logo_atual, FILTER_VALIDATE_URL)) {
                                                    $upload_dir = wp_upload_dir();
                                                    $logo_atual = $upload_dir['baseurl'] . '/' . ltrim($logo_atual, '/');
                                                }

                                                echo '<img src="' . esc_url($logo_atual) . '" id="logo-preview" style="max-width:200px; margin-bottom:10px; display:block;">';
                                            }
                                        ?>
                                        <input type="file" name="logo" id="editar_logo" class="regular-text" 
                                               accept="image/gif,image/jpeg,image/png,image/webp">
                                        <p class="description">Selecione uma imagem para a logo da empresa (GIF, JPEG, PNG ou WEBP).</p>
                                    </td>
                                </tr>
                            </table>
                        </div>
                        <div id="major-publishing-actions">
                            <div id="delete-action">
                                <a href="<?php echo esc_url(admin_url('admin.php?page=usuario_loja')); ?>" 
                                    class="button">Voltar</a>
                                
                                <?php 
                                // Verifica o status atual da loja
                                $status_loja = get_post_meta($dados_edicao['loja']->ID, 'alt_lojas_status_loja', true);
                                
                                // Exibe o botão "Inativar" apenas se a loja estiver ativa
                                if ($status_loja !== 'inativa'): ?>
                                    <a href="<?php echo esc_url(admin_url('admin-post.php?action=inativar_loja&loja_id=' . $dados_edicao['loja']->ID . '&_wpnonce=' . wp_create_nonce('inativar_loja_' . $dados_edicao['loja']->ID))); ?>" 
                                        class="button button-secondary" 
                                        style="background-color: #f0ad4e; color: #fff; border-color: #eea236; margin-left: 5px;"
                                        onclick="return confirm('Tem certeza que deseja inativar esta loja? Esta ação pode ser revertida posteriormente.');">
                                        Inativar
                                    </a>
                                <?php endif; ?>
                                
                                <?php 
                                // Exibe o botão "Reativar" apenas se a loja estiver inativa
                                if ($status_loja === 'inativa'): ?>
                                    <a href="<?php echo esc_url(admin_url('admin-post.php?action=reativar_loja&loja_id=' . $dados_edicao['loja']->ID . '&_wpnonce=' . wp_create_nonce('reativar_loja_' . $dados_edicao['loja']->ID))); ?>" 
                                        class="button button-secondary" 
                                        style="background-color: #5cb85c; color: #fff; border-color: #4cae4c; margin-left: 5px;"
                                        onclick="return confirm('Tem certeza que deseja reativar esta loja?');">
                                        Reativar
                                    </a>
                                <?php endif; ?>
                            </div>
                            
                            <div id="publishing-action">
                                <span class="spinner"></span>
                                <input type="submit" name="submit_usuario_loja" id="publish" 
                                        class="button button-primary button-large" 
                                        value="Atualizar">
                            </div>
                            <div class="clear"></div>
                        </div>
                    </form>
                </div>
            </div>

            <!-- Coluna lateral direita -->
            <div id="postbox-container-1" class="postbox-container">
                <div id="side-sortables" class="meta-box-sortables ui-sortable">
                    <div id="submitdiv" class="postbox">
                        <div class="postbox-header">
                            <h2 class="hndle ui-sortable-handle">Publicar</h2>
                        </div>
                        <div class="inside">
                            <div class="submitbox" id="submitpost">
                                <div id="minor-publishing">
                                    <!-- Status -->
                                    <div id="misc-publishing-actions">
                                        <div class="misc-pub-section">
                                            <span class="dashicons dashicons-calendar-alt"></span>
                                            <span id="timestamp">
                                                Data de criação: <b><?php echo get_the_date('d \d\e F \d\e Y \à\s H:i', $dados_edicao['loja']->ID); ?></b>
                                            </span>
                                        </div>

                                        <div class="misc-pub-section misc-pub-visibility" id="visibility">
                                            Visibilidade: <span id="post-visibility-display">Público</span>
                                        </div>

                                        <div class="misc-pub-section curtime misc-pub-curtime">
                                            <span class="dashicons dashicons-backup"></span>
                                            Última atualização: <b><?php echo get_the_modified_date('d/m/Y \à\s H:i', $dados_edicao['loja']->ID); ?></b>
                                        </div>
                                        <?php $inaticava_em = alt_data_inatividade_loja($dados_edicao['loja']->ID); ?>
                                        <?php if(!empty($inaticava_em)) :?>
                                        <div class="misc-pub-section curtime misc-pub-curtime">
                                            <span class="dashicons dashicons-info"></span>
                                            Inativada em: <b><?= $inaticava_em;  ?></b>
                                        </div>
                                        <?php endif; ?>
                                        <?php if(!empty($inaticava_em)) :?>
                                        <div class="misc-pub-section curtime misc-pub-curtime" style="color: #b80707;">
                                            <span class="dashicons dashicons-trash"></span>
                                            Excluir em: <b><?php echo alt_get_prazo_exclusao_loja($dados_edicao['loja']->ID); ?></b>
                                        </div>
                                        <?php endif; ?>
                                        <div class="misc-pub-section misc-pub-post-status">
                                            Status: <span id="post-status-display">Publicado</span>
                                        </div>
                                    </div>
                                    <div class="clear"></div>
                                </div>

                                <div id="major-publishing-actions">
                                    <div id="delete-action">
                                    <?php
                                    // Usa a função alt_get_delete_loja_usuario_link para gerar um link de exclusão permanente
                                    $delete_url = function_exists('alt_get_delete_loja_usuario_link') 
                                        ? alt_get_delete_loja_usuario_link($dados_edicao['loja']->ID, true) 
                                        : admin_url('admin-post.php?action=delete_loja_usuario&loja_id=' . $dados_edicao['loja']->ID);
                                    ?>
                                    <a class="submitdelete deletion" href="<?php echo esc_url($delete_url); ?>"
                                    onclick="return confirm('ATENÇÃO! Esta ação excluirá permanentemente tanto a loja quanto o usuário vinculado. Esta ação NÃO pode ser desfeita. Deseja continuar?');"
                                    style="color: #b32d2e;">
                                        Excluir Permanentemente
                                    </a>
                                    </div>
                                    <div class="clear"></div>
                                    <div class="clear"></div>
                                </div>
                            </div>
                        </div>
                    </div>
               </div>
           </div>
        </div>
    
<script>
    jQuery(document).ready(function($) {
    function readURL(input) {
        if (input.files && input.files[0]) {
            var reader = new FileReader();
            
            reader.onload = function(e) {
                if (!$('#logo-preview').length) {
                    $(input).before('<img id="logo-preview" src="" style="max-width:200px; margin-bottom:10px; display:block;"/>');
                }
                $('#logo-preview').attr('src', e.target.result);
            }
            
            reader.readAsDataURL(input.files[0]);
        }
    }

    $("#editar_logo").change(function() {
        readURL(this);
    });
});
</script>

